package com.yifu.cloud.plus.v1.yifu.common.core.util;

import lombok.extern.slf4j.Slf4j;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static java.util.regex.Pattern.compile;

/**
 * 身份证处理
 * @Author fxj
 * @Date 2019-11-15
 * @return
 **/
@Slf4j
public class IdCardUtil {
    public static int IdNOToAge(String IdNO){
        int leh = IdNO.length();
        Date dates;
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        String year=df.format(new Date());
        dates = getBirthdate(IdNO);
        int u=Integer.parseInt(year)-Integer.parseInt(df.format(dates));
        return u;


    }

	/**
	 * 根据身份证号计算周岁
	 *
	 * @author licancan
	 * @param idNO
	 * @return {@link int}
	 */
	public static int getFullAge(String idNO){
		Date birthday = getBirthdate(idNO);
		// 从Calendar对象中获得一个Date对象
		Calendar cal = Calendar.getInstance();
		// 把出生日期放入Calendar类型的bir对象中，进行Calendar和Date类型进行转换
		Calendar bir = Calendar.getInstance();
		bir.setTime(birthday);
		// 如果生日大于当前日期，则抛出异常：出生日期不能大于当前日期
		if (cal.before(birthday)) {
			throw new IllegalArgumentException("The birthday is after Now,It's unbelievable");
		}
		// 取出当前年月日
		int yearNow = cal.get(Calendar.YEAR);
		int monthNow = cal.get(Calendar.MONTH);
		int dayNow = cal.get(Calendar.DAY_OF_MONTH);
		// 取出出生年月日
		int yearBirth = bir.get(Calendar.YEAR);
		int monthBirth = bir.get(Calendar.MONTH);
		int dayBirth = bir.get(Calendar.DAY_OF_MONTH);
		int age;
		// 如果当前月大于出生月，或者当前月等于出生月但是当前日大于出生日 直接减，否则再减1
		if ((monthBirth < monthNow) || (monthBirth == monthNow && dayBirth < dayNow)) {
			age = yearNow - yearBirth;
		} else {
			age = yearNow - yearBirth - 1;
		}
		return age;
	}

    /**
     * 提取身份证中的出生日期，身份证非法则返回空
     * @param idNum
     * @return
     */
    public static Date getBirthdate(String idNum){
        Pattern idNumPattern = null;
        Matcher idNumMatcher = null;
        Date date = null;
        //定义判别用户身份证号的正则表达式（要么是15位，要么是18位，最后一位可以为字母）
        idNumPattern = compile("(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])");
        //通过Pattern获得Matcher
        idNumMatcher = idNumPattern.matcher(idNum);
        //判断用户输入是否为身份证号
        if(idNumMatcher.matches()){
            Pattern birthDatePattern =null;
            Matcher birthDateMather = null;
            String year = null;
            if(idNum.length()==18){
                //如果是，定义正则表达式提取出身份证中的出生日期
                birthDatePattern= compile("\\d{6}(\\d{4})(\\d{2})(\\d{2}).*");//身份证上的前6位以及出生年月日
                //通过Pattern获得Matcher
                birthDateMather= birthDatePattern.matcher(idNum);
            }else if(idNum.length()==15){
                //如果是，定义正则表达式提取出身份证中的出生日期
                birthDatePattern= compile("\\d{6}(\\d{2})(\\d{2})(\\d{2}).*");//身份证上的前6位以及出生年月日
                //通过Pattern获得Matcher
                birthDateMather= birthDatePattern.matcher(idNum);
            }
            //通过Matcher获得用户的出生年月日
            if(birthDateMather.find()){
                if(idNum.length()==18){
                    year = birthDateMather.group(1);
                }else if(idNum.length()==15){
                    year = "19"+birthDateMather.group(1);
                }
                String month = birthDateMather.group(2);
                String datetemp = birthDateMather.group(3);
                String dateStr =year+"-"+month+"-"+datetemp;
                SimpleDateFormat sdf = new SimpleDateFormat( "yyyy-MM-dd" );
                Date shijian = null;
                try {
                    shijian =sdf.parse(dateStr);
                    String temp = sdf.format(shijian);
                    if(dateStr.equals(temp)){
                        //输出用户的出生年月日
                        date = shijian;
                    }
                } catch (ParseException e) {
                    //数据有误
                }

            }
        }
        return date;
    }
    /**
     * 获取身份证的性别
     * @Author fxj
     * @Date 2019-12-25
     * @param idNum
     * @return
     **/
    public static String getSex(String idNum){
        Pattern idNumPattern = null;
        Matcher idNumMatcher = null;
        Date date = null;
        //定义判别用户身份证号的正则表达式（要么是15位，要么是18位，最后一位可以为字母）
        idNumPattern = compile("(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])");
        //通过Pattern获得Matcher
        idNumMatcher = idNumPattern.matcher(idNum);
        //判断用户输入是否为身份证号
        String sex = null;
        if(idNumMatcher.matches()) {
            if (idNum.length() == 18) {
                if (Integer.parseInt(idNum.substring(16).substring(0, 1)) % 2 == 0) {// 判断性别
                    sex = "2";
                } else {
                    sex = "1";
                }
            } else if (idNum.length() == 15) {
                if (Integer.parseInt(idNum.substring(14, 15)) % 2 == 0) {
                    sex = "2";
                } else {
                    sex = "1";
                }
            }
        }
        return sex;
    }
}
