package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.client.RestTemplate;

import java.net.URI;

/**
* @author fxj
* @date 2022/5/23 18:13
*/
@Log4j2
public class HttpDaprUtil {
	private static RestTemplate restTemplate;
	private static HttpHeaders headers;
	private static StringBuffer stringBuffer;

	/**
	 * @param appUrl
	 * @param appId
	 * @param method
	 * @param param
	 * @param cs
	 * @return com.yifu.cloud.plus.v1.yifu.common.core.util.R<T>
	 * @author fxj
	 * @date 2022-05-23 17:56
	 * @description get请求获取指定对象信息
	 **/
	public static <T> R<T> invokeMethodGet(String appUrl,
										   String appId,
										   String method,
										   String param,
										   Class cs) {
		// 实例化 RestTemplate
		initResTemplate();
		// 初始化请求URL
		initUrl(appUrl, appId, method, param);
		ResponseEntity<T> res;
		try {
			res = restTemplate.getForEntity(stringBuffer.toString(), cs);
		} catch (Exception e) {
			return R.failed("获取信息失败:" + e.getMessage());
		}
		if (null != res && CommonConstants.SUCCESS == res.getStatusCodeValue()) {
			return R.ok(res.getBody());
		} else {
			return R.failed("获取信息失败！");
		}

	}
	/**
	 * @param appUrl
	 * @param appId
	 * @param method
	 * @param param
	 * @param cs
	 * @return com.yifu.cloud.plus.v1.yifu.common.core.util.R<T>
	 * @author fxj
	 * @date 2022-05-23 17:56
	 * @description get请求获取指定对象信息
	 **/
	public static <T> R<T> invokeMethodGet(String appUrl,
										   String appId,
										   String method,
										   String param,
										   Class cs,
										   @RequestHeader(SecurityConstants.FROM) String from) {
		// 实例化 RestTemplate
		initResTemplate();
		// 初始化请求URL
		initUrl(appUrl, appId, method, param);
		ResponseEntity<T> res;
		HttpHeaders headers = new HttpHeaders();
		headers.add(SecurityConstants.FROM, from);
		headers.setContentType(MediaType.APPLICATION_JSON);
		headers.add("Authorization", null);
		HttpEntity<String> entity = new HttpEntity(param, headers);
		try {
			res = restTemplate.exchange(stringBuffer.toString(), HttpMethod.GET,entity,cs);
		} catch (Exception e) {
			return R.failed("获取信息失败:" + e.getMessage());
		}
		if (null != res && CommonConstants.SUCCESS == res.getStatusCodeValue()) {
			return R.ok(res.getBody());
		} else {
			return R.failed("获取信息失败！");
		}

	}
	public static <T> R<T> invokeMethodPost(String appUrl,
											String appId,
											String method,
											Object param,
											Class cs,
											@RequestHeader(SecurityConstants.FROM) String from){
		// 实例化 RestTemplate
		initResTemplate();
		// 初始化请求URL
		initUrl(appUrl, appId, method, "");
		ResponseEntity<T> res;
		HttpHeaders headers = new HttpHeaders();
		headers.add(SecurityConstants.FROM, from);
		headers.setContentType(MediaType.APPLICATION_JSON);
		headers.add("Authorization", null);
		HttpEntity<String> entity = new HttpEntity(param, headers);
		try {
			res = restTemplate.postForEntity(URI.create(stringBuffer.toString()),entity, cs);
		} catch (Exception e) {
			log.error("日志保存异常：",e);
			return R.failed("获取信息失败:" + e.getMessage());
		}
		if (null != res && CommonConstants.SUCCESS == res.getStatusCodeValue()) {
			return R.ok(res.getBody());
		} else {
			return R.failed("获取信息失败！");
		}

	}
	private static void initResTemplate() {
		if (null == restTemplate) {
			restTemplate = new RestTemplate();
		}
	}

	/**
	 * @param appUrl
	 * @param appId
	 * @param method
	 * @param param
	 * @author fxj
	 * @date 2022/5/23 18:11
	 */
	private static void initUrl(String appUrl, String appId, String method, String param) {
		stringBuffer = new StringBuffer();
		stringBuffer.append(appUrl);
		stringBuffer.append(appId);
		stringBuffer.append("/method");
		stringBuffer.append(method);
		stringBuffer.append(param);
	}

	public static <T> R<T> invokeMethodGetR(String appUrl,
										   String appId,
										   String method,
										   String param) {
		// 实例化 RestTemplate
		initResTemplate();
		// 初始化请求URL
		initUrl(appUrl, appId, method, param);
		ResponseEntity<R> res;
		try {
			res = restTemplate.getForEntity(stringBuffer.toString(), R.class);
		} catch (Exception e) {
			return R.failed("获取信息失败:" + e.getMessage());
		}
		if (null != res && CommonConstants.SUCCESS == res.getStatusCodeValue()) {
			return (R)res.getBody();
		} else {
			return R.failed("获取信息失败！");
		}

	}

}
