package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AllUserNaVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaMap;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.SysUserListVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @Author huyc
 * @Date 2022-07-18
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprUpmsProperties.class)
public class UpmsDaprUtils {

	@Autowired
	private DaprUpmsProperties daprUpmsProperties;

	/**
	 * 获取所有区域数据
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	public R<AreaVo> getAreaListR() {
		R<AreaVo> areaListR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/area/inner/getAreaVo","", AreaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(areaListR)){
			return R.failed("获取所有区域数据失败！");
		}
		return areaListR;
	}
	/**
	 * 获取所有区域数据
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	public R<AreaMap> getAreaMapR() {
		R<AreaMap> areaListR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/area/inner/getAreaMap","", AreaMap.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(areaListR)){
			return R.failed("获取所有区域数据失败！");
		}
		return areaListR;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有用户数据
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	**/
	public R<AllUserNaVo> getAllUserName() {
		R<AllUserNaVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getAllUserName","", AllUserNaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取所有用户数据失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author fxj
	 * @Description 获取指定用户名对应用户IDs
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	 **/
	public R<SysUserListVo> getUserIdsByUserNames(String usernames) {
		R<SysUserListVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getUserIdsByUserNames", usernames, SysUserListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取指定用户名对应用户IDs失败！");
		}
		return allUserVoR;
	}

	public R<SysUser> getSimpleUser(String userId) {
		R<SysUser> userR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getSimpleUser",userId, SysUser.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(userR)){
			return R.failed("获取所有用户数据失败！");
		}
		return userR;
	}
}
