package com.yifu.cloud.plus.v1.yifu.common.ldap.entity;

import lombok.Data;
import lombok.ToString;
import org.springframework.ldap.odm.annotations.Attribute;
import org.springframework.ldap.odm.annotations.Entry;

import java.util.Date;


@Data
@ToString
@Entry(objectClasses = {"posixAccount","top","inetOrgPerson"}, base = "ou=皖信人力集团,ou=wanxin")
public class PersonVo {

	/**
	 * 主键
	 */
	@Attribute(name = "uid")
	private String uid;

	/**
	 * 常用姓名
	 */
	@Attribute(name = "cn")
	private String personName;

	/**
	 * 电话
	 */
	@Attribute(name = "telephoneNumber")
	private String telephoneNumber;

	/**
	 * 邮箱
	 */
	@Attribute(name = "email")
	private String email;

	/**
	 * 展示姓名
	 */
	@Attribute(name = "displayName")
	private String displayName;

	/**
	 * 真实姓名
	 */
	@Attribute(name = "sn")
	private String sn;

	/**
	 * 用户url
	 */
	@Attribute(name = "homeDirectory")
	private String homeDirectory;

	/**
	 * 部门名称
	 */
	@Attribute(name = "ou")
	private String deptName;

	/**
	 * 用户密码
	 */
	@Attribute(name = "userPassword")
	private String password;


	/**
	 * 创建时间
	 */
	@Attribute
	protected Date createTime;

	/**
	 * 更新时间
	 */
	@Attribute
	protected Date updateTime;

	/**
	 * 状态
	 */
	@Attribute
	protected Integer status;
}

