package com.yifu.cloud.plus.v1.yifu.insurances.constants;

/**
 * @author licancan
 * @description 商险常量
 * @date 2022-07-18 17:52:59
 */
public class InsurancesConstants {

	/**
	 * 主键不能为空
	 */
	public static final String ID_IS_EMPTY = "主键不能为空";
	/**
	 * 新增
	 */
	public static final String ADD = "“新增”提交申请";
	/**
	 * 替换导出新增
	 */
	public static final String INSERT = "新增";
	/**
	 * 批增
	 */
	public static final String BATCH_INSERT = "批增";
	/**
	 * 离职
	 */
	public static final String QUIT = "离职";
	/**
	 * 批增
	 */
	public static final String BATCH = "“批增”提交申请";
	/**
	 * 替换
	 */
	public static final String REPLACE = "“替换”提交申请";
	/**
	 * 被替换成功
	 */
	public static final String SOURCE_REPLACE = "被替换成功";
	/**
	 * 删除
	 */
	public static final String DELETE = "删除";
	/**
	 * 编辑
	 */
	public static final String EDIT = "编辑";
	/**
	 * 数据发生变动，请刷新数据后重新办理
	 */
	public static final String CHANGE_ERROR = "数据发生变动，请刷新数据后重新办理";
	/**
	 * 投保导出办理
	 */
	public static final String EXPORT = "投保中";
	/**
	 * 投保退回
	 */
	public static final String ROLLBACK = "投保退回";
	/**
	 * 投保成功
	 */
	public static final String SUCCESSFUL = "投保成功";
	/**
	 * 登记保单保费
	 */
	public static final String REGISTERED = "登记保单保费";
	/**
	 * 登记发票号
	 */
	public static final String REGISTERED_INVOICE = "登记发票号";
	/**
	 * 已投保信息修改
	 */
	public static final String UPDATE_INSURED = "已投保信息修改";
	/**
	 * 新增投保成功
	 */
	public static final String ADD_SUCCESS = "新增投保成功";
	/**
	 * 批增投保成功
	 */
	public static final String BATCH_SUCCESS = "批增投保成功";
	/**
	 * 替换成功
	 */
	public static final String REPLACE_SUCCESS = "替换成功";
	/**
	 * 操作成功
	 */
	public static final String OPERATE_SUCCESS = "操作成功";
	/**
	 * 非投保退回状态，无法删除
	 */
	public static final String DELETE_ERROR = "非投保退回状态，无法删除";

	/**
	 * 不允许编辑
	 */
	public static final String EDIT_NOT_ALLOW = "不允许编辑";
	/**
	 * 投保记录已存在
	 */
	public static final String DATA_IS_EXIST = "投保记录已存在";
	/**
	 * 投保记录不存在
	 */
	public static final String DATA_IS_NOT_EXIST = "投保记录不存在";
	/**
	 * 未找到符合条件的参保记录
	 */
	public static final String NOT_FOUND_INSURANCE_RECORD = "未找到符合条件的参保记录";
	/**
	 * 未找到符合条件的新增或批增投保数据
	 */
	public static final String NOT_FOUND_INSERT_OR_BATCH_RECORD = "未找到符合条件的新增或批增投保数据";
	/**
	 * 当前投保状态无法变更投保记录
	 */
	public static final String CURRENT_STATUS_NOT_CHANGE_INSURANCE_RECORD = "当前投保状态无法变更投保记录";
	/**
	 * 当前投保状态无法登记发票号
	 */
	public static final String CURRENT_STATUS_NOT_REGISTER_INVOICE_NO = "当前投保状态无法登记发票号";
	/**
	 * 结算信息不存在
	 */
	public static final String SETTLE_DATA_IS_NOT_EXIST = "结算信息不存在";
	/**
	 * 推送信息不存在
	 */
	public static final String PUSH_DATA_IS_NOT_EXIST = "推送信息不存在";
	/**
	 * 被替换员工投保记录不存在
	 */
	public static final String REPLACE_IS_NOT_EXIST = "被替换员工投保记录不存在";
	/**
	 * 项目编码不存在
	 */
	public static final String DEPT_NO_IS_NOT_EXIST = "项目编码不存在";
	/**
	 * 对应项目编码已停止合作
	 */
	public static final String EMP_DISPATCH_SETTLEDOMAIN_STOP = "对应项目编码已停止合作";
	/**
	 * 对应替换员工项目编码已停止合作
	 */
	public static final String EMP_DISPATCH_REPALCE_SETTLEDOMAIN_STOP = "对应替换员工项目编码已停止合作";
	/**
	 * 替换员工项目不存在
	 */
	public static final String REPLACE_DEPT_NO_IS_NOT_EXIST = "替换员工项目不存在";
	/**
	 * 未找到项目的结算方式
	 */
	public static final String PROJECT_NOT_FIND_SETTLE_TYPE = "未找到项目的结算方式";
	/**
	 * 根据替换员工的项目，未找到项目的结算方式
	 */
	public static final String REPLACE_PROJECT_NOT_FIND_SETTLE_TYPE = "根据替换员工的项目，未找到项目的结算方式";
	/**
	 * 替换员工投保记录已存在
	 */
	public static final String REPLACE_IS_EXIST = "替换员工投保记录已存在";
	/**
	 * 替换投保不允许变更投保类型
	 */
	public static final String REPLACE_NOT_ALLOW = "替换投保不允许变更投保类型";
	/**
	 * 当前记录是待投保，无法替换
	 */
	public static final String ONE_REPLACE_IS_NOT_ALLOW = "当前记录是待投保，无法替换";
	/**
	 * 当前记录是投保中，无法替换
	 */
	public static final String TWO_REPLACE_IS_NOT_ALLOW = "当前记录是投保中，无法替换";
	/**
	 * 当前记录是投保退回，无法替换
	 */
	public static final String FOUR_REPLACE_IS_NOT_ALLOW = "当前记录是投保退回，无法替换";
	/**
	 * 当前记录已出险，无法替换
	 */
	public static final String USE_REPLACE_IS_NOT_ALLOW = "当前记录已出险，无法替换";
	/**
	 * 当前记录已失效，无法替换
	 */
	public static final String EFFECT_REPLACE_IS_NOT_ALLOW = "当前记录已失效，无法替换";
	/**
	 * 当前记录已过期，无法替换
	 */
	public static final String OVERDUE_REPLACE_IS_NOT_ALLOW = "当前记录已过期，无法替换";
	/**
	 * 当前记录已减员，无法替换
	 */
	public static final String FIVE_REPLACE_IS_NOT_ALLOW = "当前记录已减员，无法替换";
	/**
	 * 当前记录在减员流程中，无法替换
	 */
	public static final String REDUCE_REPLACE_IS_NOT_ALLOW = "当前记录在减员流程中，无法替换";
	/**
	 * 投保状态不是待投保、投保中、已投保，无法退回
	 */
	public static final String REDUCE_ROLLBACK_IS_NOT_ALLOW = "投保状态不是待投保、投保中、已投保，无法退回";
	/**
	 * 商险减员中，无法退回
	 */
	public static final String REDUCE_ROLLBACK_REDUCE_IS_NOT_ALLOW = "商险减员中，无法退回";
	/**
	 * 员工姓名不能为空
	 */
	public static final String EMP_NAME_NOT_EMPTY = "员工姓名不能为空";
	/**
	 * 员工姓名超过20字符长度限制
	 */
	public static final String EMP_NAME_MORE_THAN_20 = "员工姓名超过20字符长度限制";
	/**
	 * 替换员工姓名不能为空
	 */
	public static final String REPLACE_EMP_NAME_NOT_EMPTY = "替换员工姓名不能为空";
	/**
	 * 替换员工姓名超过20字符长度限制
	 */
	public static final String REPLACE_EMP_NAME_MORE_THAN_20 = "替换员工姓名超过20字符长度限制";
	/**
	 * 员工身份证号不能为空
	 */
	public static final String EMP_IDCARD_NO_NOT_EMPTY = "员工身份证号不能为空";
	/**
	 * 替换员工身份证号不能为空
	 */
	public static final String REPLACE_EMP_IDCARD_NO_NOT_EMPTY = "替换员工身份证号不能为空";
	/**
	 * 员工身份证号格式错误
	 */
	public static final String EMP_IDCARD_NO_NOT_LEGITIMATE = "员工身份证号格式错误";
	/**
	 * 员工年龄需在16岁-70岁之间
	 */
	public static final String EMP_AGE_NOT_LEGITIMATE = "员工年龄需在16岁-70岁之间";
	/**
	 * 替换员工年龄需在16岁-70岁之间
	 */
	public static final String REPLACE_EMP_AGE_NOT_LEGITIMATE = "替换员工年龄需在16岁-70岁之间";
	/**
	 * 员工未通过实名认证
	 */
	public static final String EMP_ID_CARD_NO_NOT_FIT = "员工未通过实名认证";
	/**
	 * 替换员工未通过实名认证
	 */
	public static final String REPLACE_EMP_ID_CARD_NO_NOT_FIT = "替换员工未通过实名认证";
	/**
	 * 替换信息和被替换信息一致，无法替换
	 */
	public static final String REPLACE_EMP_INFO_SAME = "替换信息和被替换信息一致，无法替换";
	/**
	 * 替换员工身份证号格式错误
	 */
	public static final String REPLACE_EMP_IDCARD_NO_NOT_LEGITIMATE = "替换员工身份证号格式错误";
	/**
	 * 项目编码不能为空
	 */
	public static final String DEPT_NO_NOT_EMPTY = "项目编码不能为空";
	/**
	 * 替换员工项目编码不能为空
	 */
	public static final String REPLACE_DEPT_NO_NOT_EMPTY = "替换员工项目编码不能为空";
	/**
	 * 保险公司名称不能为空
	 */
	public static final String INSURANCE_COMPANY_NAME_NOT_EMPTY = "保险公司名称不能为空";
	/**
	 * 保险公司不存在
	 */
	public static final String INSURANCE_COMPANY_NAME_NOT_EXIST = "保险公司不存在";
	/**
	 * 险种名称不能为空
	 */
	public static final String INSURANCE_TYPE_NAME_NOT_EMPTY = "险种名称不能为空";
	/**
	 * 险种不存在
	 */
	public static final String INSURANCE_TYPE_NAME_NOT_EXIST = "险种不存在";
	/**
	 * 费率不存在
	 */
	public static final String INSURANCE_TYPE_RATE_NOT_EXIST = "费率不存在";
	/**
	 * 保单开始时间不能为空
	 */
	public static final String POLICY_START_NOT_EMPTY = "保单开始时间不能为空";
	/**
	 * 保单开始时间格式错误
	 */
	public static final String POLICY_START_PARSE_ERROR = "保单开始时间格式错误";
	/**
	 * 变更后保单开始时间格式错误
	 */
	public static final String POLICY_START_NEW_PARSE_ERROR = "变更后保单开始时间格式错误";
	/**
	 * 变更后保单结束时间格式错误
	 */
	public static final String POLICY_END_NEW_PARSE_ERROR = "变更后保单结束时间格式错误";
	/**
	 * 保单开始时间需要大于派单日期
	 */
	public static final String POLICY_START_SHOULD_IS_FUTURE = "保单开始时间需要大于派单日期";
	/**
	 * 保单结束时间需要大于保单开始时间
	 */
	public static final String POLICY_START_SHOULD_LESS_THAN_POLICY_END = "保单结束时间需要大于保单开始时间";
	/**
	 * 变更后的保单开始时间需早于保单结束时间
	 */
	public static final String POLICY_START_NEW_SHOULD_LESS_THAN_POLICY_END_NEW = "变更后的保单开始时间需早于保单结束时间";
	/**
	 * 保单起止时间不能超过365天
	 */
	public static final String POLICY_DATE_NOT_MORE_THAN_365 = "保单起止时间不能超过365天";
	/**
	 * 保单结束时间不能为空
	 */
	public static final String POLICY_END_NOT_EMPTY = "保单结束时间不能为空";
	/**
	 * 保单结束时间格式错误
	 */
	public static final String POLICY_END_PARSE_ERROR = "保单结束时间格式错误";
	/**
	 * 保单结束时间需要大于派单日期
	 */
	public static final String POLICY_END_SHOULD_IS_FUTURE = "保单结束时间需要大于派单日期";
	/**
	 * 购买标准不能为空
	 */
	public static final String BUY_STANDARD_NOT_EMPTY = "购买标准不能为空";
	/**
	 * 变更后保单开始时间、变更后保单结束时间、变更后投保类型三个字段至少填写一个
	 */
	public static final String CHOOSE_ONE_OF_THREE = "变更后保单开始时间、变更后保单结束时间、变更后投保类型三个字段至少填写一个";
	/**
	 * 购买标准不存在
	 */
	public static final String BUY_STANDARD_NOT_EXIST = "购买标准不存在";
	/**
	 * 商险购买地省名称不能为空
	 */
	public static final String INSURANCE_PROVINCE_NAME_NOT_EMPTY = "商险购买地省名称不能为空";
	/**
	 * 商险购买地省不存在
	 */
	public static final String INSURANCE_PROVINCE_NAME_NOT_EXIST = "商险购买地省不存在";
	/**
	 * 商险购买地市名称
	 */
	public static final String INSURANCE_CITY_NAME_NOT_EMPTY = "商险购买地市名称不能为空";
	/**
	 * 商险购买地市不存在
	 */
	public static final String INSURANCE_CITY_NAME_NOT_EXIST = "商险购买地市不存在";
	/**
	 * 商险办理地省名称不能为空
	 */
	public static final String INSURANCE_HANDLE_PROVINCE_NAME_NOT_EMPTY = "商险办理地省名称不能为空";
	/**
	 * 商险办理地省不存在
	 */
	public static final String INSURANCE_HANDLE_PROVINCE_NAME_NOT_EXIST = "商险办理地省不存在";
	/**
	 * 商险办理地城市名称不能为空
	 */
	public static final String INSURANCE_HANDLE_CITY_NAME_NOT_EMPTY = "商险办理地城市名称不能为空";
	/**
	 * 商险办理地城市不存在
	 */
	public static final String INSURANCE_HANDLE_CITY_NAME_NOT_EXIST = "商险办理地城市不存在";
	/**
	 * 结算月不能为空
	 */
	public static final String SETTLE_MONTH_NOT_EMPTY = "结算月不能为空";
	/**
	 * 结算月格式错误
	 */
	public static final String SETTLE_MONTH_PARSE_ERROR = "结算月格式错误";
	/**
	 * 结算月不能小于派单月
	 */
	public static final String SETTLE_MONTH_SHOULD_IS_FUTURE = "结算月不能小于派单月";
	/**
	 * 岗位不能为空
	 */
	public static final String POST_NOT_EMPTY = "岗位不能为空";
	/**
	 * 岗位长度超过32字符限制
	 */
	public static final String POST_NOT_MORE_THAN_32 = "岗位长度超过32字符限制";
	/**
	 * 备注长度超过50字符限制
	 */
	public static final String REMARK_NOT_MORE_THAN_50 = "备注长度超过50字符限制";
	/**
	 * 保单号不能为空
	 */
	public static final String POLICY_NO_EMPTY = "保单号不能为空";
	/**
	 * 保单号长度超过50字符限制
	 */
	public static final String POLICY_NO_MORE_THAN_50 = "保单号长度超过50字符限制";
	/**
	 * 发票号不能为空
	 */
	public static final String INVOICE_NO_EMPTY = "发票号不能为空";
	/**
	 * 变更原因不能为空
	 */
	public static final String REASON_EMPTY = "变更原因不能为空";
	/**
	 * 变更原因超过50字符限制
	 */
	public static final String REASON_MORE_THAN_50 = "变更原因超过50字符限制";
	/**
	 * 发票号长度超过50字符限制
	 */
	public static final String INVOICE_NO_MORE_THAN_50  = "发票号长度超过50字符限制";
	/**
	 * 保费不能为空
	 */
	public static final String ACTUAL_PREMIUM_EMPTY = "保费不能为空";
	/**
	 * 保费金额需要填写不大于9999999.99的正数，最多支持两位小数
	 */
	public static final String ACTUAL_PREMIUM_PARSE_ERROR= "保费金额需要填写不大于9999999.99的正数，最多支持两位小数";
	/**
	 * 替换类型无法登记保单保费
	 */
	public static final String BUY_TYPE_FOUR_NOT_REGISTERED= "替换类型无法登记保单保费";
	/**
	 * 变更后投保类型只能填写新增、批增
	 */
	public static final String BUY_TYPE_ERROR_NEW = "变更后投保类型只能填写新增、批增";
	/**
	 * 商险待投保，无法登记保单保费
	 */
	public static final String BUY_HANDLE_ONE_NOT_REGISTERED = "商险待投保，无法登记保单保费";
	/**
	 * 商险投保中，无法登记保单保费
	 */
	public static final String BUY_HANDLE_TWO_NOT_REGISTERED = "商险投保中，无法登记保单保费";
	/**
	 * 非投保中状态，无法标记投保成功
	 */
	public static final String INSURANCE_BUY_STATUS_NOT_TWO = "非投保中状态，无法标记投保成功";
	/**
	 * 商险投保退回，无法登记保单保费
	 */
	public static final String BUY_HANDLE_FOUR_NOT_REGISTERED = "商险投保退回，无法登记保单保费";
	/**
	 * 商险结算中，无法登记保单保费
	 */
	public static final String SETTLE_HANDLE_TWO_NOT_REGISTERED = "商险结算中，无法登记保单保费";
	/**
	 * 商险已结算，无法登记保单保费
	 */
	public static final String SETTLE_HANDLE_THREE_NOT_REGISTERED = "商险已结算，无法登记保单保费";
	/**
	 * 保单号不存在或已过期
	 */
	public static final String POLICY_NO_EXIST = "保单号不存在或已过期";
	/**
	 * 保单已禁用
	 */
	public static final String POLICY_NO_FORBIDDEN = "保单已禁用";
	/**
	 * 保单号不存在
	 */
	public static final String POLICY_NO_NOT_EXIST = "保单号不存在";
	/**
	 * 保单号信息错误
	 */
	public static final String POLICY_NO_ERROR = "保单号信息错误";
	/**
	 * 保险公司错误
	 */
	public static final String POLICY_NO_COMPANY_NAME_NOT_SAME = "保险公司错误";
	/**
	 * 险种名称错误
	 */
	public static final String POLICY_NO_TYPE_NAME_NOT_SAME = "险种名称错误";

	/***********************减员办理错误码********************************/

	/**
	 * 商险已出险，无法减员
	 */
	public static final String INSURANCE_IS_USE_ERROR = "商险已出险，无法减员";

	/**
	 * 非已投保状态，无法减员
	 */
	public static final String REFUND_ERROR = "非已投保状态，无法减员";

	/**
	 * 商险待投保，无法减员
	 */
	public static final String INSURANCE_BUY_STATUS_ONE_ERROR = "商险待投保，无法减员";

	/**
	 * 商险投保中，无法减员
	 */
	public static final String INSURANCE_BUY_STATUS_TWO_ERROR = "商险投保中，无法减员";

	/**
	 * 商险投保退回，无法减员
	 */
	public static final String INSURANCE_BUY_STATUS_FOUR_ERROR = "商险投保退回，无法减员";

	/**
	 * 商险无效，无法减员
	 */
	public static final String INSURANCE_IS_EFFECT_ERROR = "商险无效，无法减员";

	/**
	 * 商险已过期，无法减员
	 */
	public static final String INSURANCE_IS_OVERDUE_ERROR = "商险已过期，无法减员";

	/**
	 * 商险待减员，无法减员
	 */
	public static final String INSURANCE_REFUND_STATUS_ONE_ERROR = "商险待减员，无法减员";

	/**
	 * 商险减员中，无法减员
	 */
	public static final String INSURANCE_REFUND_STATUS_TWO_ERROR = "商险减员中，无法减员";

	/**
	 * 商险已减员，无法减员
	 */
	public static final String INSURANCE_REFUND_STATUS_FOUR_ERROR = "商险已减员，无法减员";

	/**
	 * 变更结算月和当前结算月一致
	 */
	public static final String SETTLE_MONTH_IDENTICAL = "变更结算月和当前结算月一致";

	/**
	 * 商险待投保，无法减员
	 */
	public static final String SETTLE_MONTH_CHANGE_REDUCE_HANDLE_STATUS_ERROR = "商险待投保，无法减员";

	/**
	 * 商险待投保，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_BUY_STATUS_ONE_ERROR = "商险待投保，无法变更结算月";

	/**
	 * 商险投保中，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_BUY_STATUS_TWO_ERROR = "商险投保中，无法变更结算月";

	/**
	 * 商险投保退回，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_BUY_STATUS_FOUR_ERROR = "商险投保退回，无法变更结算月";

	/**
	 * 商险已减员，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_REFUND_STATUS_FOUR_ERROR = "商险已减员，无法变更结算月";

	/**
	 * 减员流程中，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_REFUND_STATUS_ONE_ERROR = "减员流程中，无法变更结算月";

	/**
	 * 商险结算中，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_SETTLE_STATUS_TWO_ERROR = "商险结算中，无法变更结算月";

	/**
	 * 商险已结算，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_SETTLE_STATUS_THREE_ERROR = "商险已结算，无法变更结算月";

	/**
	 * 替换类型无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_IS_EFFECT_ERROR ="替换类型无法变更结算月";



	/**
	 * 替换项目编码和原编码一致
	 */
	public static final String DEPT_NO_IDENTICAL = "替换项目编码和原编码一致";

	/**
	 * 重复数据
	 */
	public static final String DUPLICATE_DATA_ERROR = "重复数据";

	/**
	 * 当前变更结算月列表为空
	 */
	public static final String SETTLE_MONTH_CHANGE_LIST_IS_EMPTY ="当前变更结算月列表为空";

	/**
	 * 减员办理导入列表为空
	 */
	public static final String INSURANCE_REFUND_IMPORT_LIST_IS_EMPTY ="减员办理导入列表为空";

	/**
	 * 替换类型无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_IS_EFFECT_ERROR ="替换类型无法变更项目";

	/**
	 * 商险待投保，无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_BUY_STATUS_ONE_ERROR = "商险待投保，无法变更项目";

	/**
	 * 商险投保中，无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_BUY_STATUS_TWO_ERROR = "商险投保中，无法变更项目";

	/**
	 * 商险投保退回，无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_BUY_STATUS_FOUR_ERROR = "商险投保退回，无法变更项目";

	/**
	 * 商险已减员，无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_REFUND_STATUS_FOUR_ERROR = "商险已减员，无法变更项目";

	/**
	 * 商险已减员，无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_REFUND_STATUS_ONE_ERROR = "减员流程中，无法变更项目";

	/**
	 * 商险结算中，无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_SETTLE_STATUS_TWO_ERROR = "商险结算中，无法变更项目";

	/**
	 * 商险已结算，无法变更项目
	 */
	public static final String DEPT_NO_CHANGE_SETTLE_STATUS_THREE_ERROR = "商险已结算，无法变更项目";

	/**
	 * 替换项目编码不能为空
	 */
	public static final String DEPT_NO_CHANGE_NOT_EMPTY = "替换项目编码不能为空";

	/**
	 * 无替换项目的操作权限
	 */
	public static final String NEW_DEPT_NO_NOT_IN_DEPT_LIST = "无替换项目的操作权限";

	/**
	 * 无被替换项目的操作权限
	 */
	public static final String OLD_DEPT_NO_NOT_IN_DEPT_LIST = "无被替换项目的操作权限";

	/**
	 * 无该项目的操作权限
	 */
	public static final String DEPT_NO_NOT_IN_USER_DEPT_LIST = "无该项目的操作权限";

	/**
	 * 替换项目不存在
	 */
	public static final String DEPT_NO_CHANGE_NEW_IS_NOT_EXIST = "替换项目不存在";

	/**
	 * 被替换的项目不存在
	 */
	public static final String DEPT_NO_CHANGE_OLD_IS_NOT_EXIST = "被替换的项目不存在";


	/**
	 * 保险公司不能为空
	 */
	public static final String REFUND_INSURANCE_COMPANY_NOT_EMPTY = "保险公司不能为空";

	/**
	 * 险种不能为空
	 */
	public static final String REFUND_INSURANCE_TYPE_NOT_EMPTY = "险种不能为空";

	/**
	 * 保单开始日期不能为空
	 */
	public static final String REFUND_INSURANCE_START_DATE_NOT_EMPTY = "保单开始日期不能为空";

	/**
	 * 保单结束日期不能为空
	 */
	public static final String REFUND_INSURANCE_END_DATE_NOT_EMPTY = "保单结束日期不能为空";

	/**
	 * 购买标准不能为空
	 */
	public static final String REFUND_BUY_STANDARD_NOT_EMPTY = "购买标准不能为空";

	/**
	 * 退费金额不能为空
	 */
	public static final String REFUND_MONEY_NOT_EMPTY = "保费不能为空";

	/**
	 * 保费金额格式不正确
	 */
	public static final String REFUND_MONEY_PARSE_ERROR = "保费金额格式不正确";

	/**
	 * 员工减员记录不存在
	 */
	public static final String REFUND_IS_NULL = "未找到“减员成功”的参保信息";

	/**
	 * 已更新保单减员退费，不能再次更新
	 */
	public static final String REFUND_MONEY_IS_NOT_NULL = "已更新保单减员退费，不能再次更新";

	/**
	 * 减员导出办理
	 */
	public static final String REFUND_EXPORT = "减员导出办理";

	/**
	 * 减员办理成功
	 */
	public static final String REFUND_EXPORT_SUCCESS = "减员办理成功";

	/**
	 * 减员办理成功
	 */
	public static final String REFUND_EXPORT_FAILED = "减员办理失败";
	/**
	 * 员工投保记录不存在
	 */
	public static final String USER_DATA_IS_NOT_EXIST = "员工投保记录不存在";

	/**
	 * 无该投保记录的操作权限
	 */
	public static final String DEPT_NO_NOT_IN_DEPT_LIST = "无该投保记录的操作权限";

	/**
	 * 存在多条在保记录
	 */
	public static final String MULTIPLE_RECORDS_UNDER_WARRANTY = "存在多条在保记录";

	/***********************商险产品错误码********************************/

	/**
	 * 新增保险公司
	 */
	public static final String NEW_INSURANCE_COMPANY = "新增保险公司";
	/**
	 * 修改保险公司
	 */
	public static final String UPDATE_INSURANCE_COMPANY = "修改保险公司";

	/**
	 * 删除保险公司
	 */
	public static final String DELETE_INSURANCE_COMPANY = "删除保险公司";

	/**
	 * 新增险种
	 */
	public static final String NEW_INSURANCE_TYPE = "新增险种";
	/**
	 * 修改险种
	 */
	public static final String UPDATE_INSURANCE_TYPE = "修改险种";
	/**
	 * 新增费率
	 */
	public static final String NEW_INSURANCE_TYPE_RATE = "新增费率";
	/**
	 * 删除费率
	 */
	public static final String DELETE_INSURANCE_TYPE_RATE = "删除费率";
	/**
	 * 新增购买标准
	 */
	public static final String NEW_INSURANCE_TYPE_STANDARD = "新增购买标准";
	/**
	 * 删除购买标准
	 */
	public static final String DELETE_INSURANCE_TYPE_STANDARD = "删除购买标准";

	/**
	 * 购买标准不能超过9999999.99
	 */
	public static final String INSURANCE_TYPE_STANDARD_MAX_ERROR = "购买标准不能超过9999999.99";

	/**
	 * 医疗额度不能超过9999999.99
	 */
	public static final String MEDICAL_QUOTA_MAX_ERROR = "医疗额度不能超过9999999.99";

	/**
	 * 身故和残疾不能超过9999999.99
	 */
	public static final String DIE_DISABLE_QUOTA_MAX_ERROR = "身故和残疾不能超过9999999.99";

	/**
	 * 导入减员数据
	 */
	public static final String INSURANCE_REFUND_IMPORT = "“减员”提交申请";

	/**
	 * 减员导出办理
	 */
	public static final String INSURANCE_REFUND_EXPORT = "减员中";

	/**
	 * 减员成功
	 */
	public static final String INSURANCE_REFUND_SUCCESS = "减员成功";


	/**
	 * 减员退回
	 */
	public static final String INSURANCE_REFUND_FAILED = "减员退回";

	/**
	 * 变更所属项目
	 */
	public static final String DEPT_CHANGE = "变更所属项目";

	/**
	 * 变更结算月
	 */
	public static final String MONTH_CHANGE = "变更结算月";

	/**
	 * 新增的保险公司信息为空
	 */
	public static final String NEW_COMPANY_IS_EMPTY = "新增的保险公司信息为空";

	/**
	 * 计费方式格式不正确
	 */
	public static final String COMPANY_BILLING_TYPE_IS_ERROR = "计费方式格式不正确";

	/**
	 * 保险公司名称格式不正确
	 */
	public static final String COMPANY_NAME_IS_ERROR = "保险公司名称格式不正确";

	/**
	 * 保险公司地址格式不正确
	 */
	public static final String COMPANY_ADDRESS_IS_ERROR = "保险公司地址格式不正确";

	/**
	 * 保险公司名称不能重复添加
	 */
	public static final String COMPANY_NAME_IS_USE = "保险公司名称不能重复添加";

	/**
	 * 新增保险公司成功
	 */
	public static final String NEW_COMPANY_SUCCESS = "新增保险公司成功";

	/**
	 * 修改保险信息公司成功
	 */
	public static final String UPDATE_COMPANY_SUCCESS = "修改保险信息公司成功";

	/**
	 * 要修改的保险公司id为空
	 */
	public static final String UPDATE_COMPANY_ID_IS_EMPTY = "要修改的保险公司id为空";




	/**
	 * 要修改的保险公司不存在或已被删除
	 */
	public static final String COMPANY_IS_DELETE = "要修改的保险公司不存在或已被删除";


	/**
	 * 要修改的保险公司名称格式不正确
	 */
	public static final String CHANGE_COMPANY_NAME_IS_ERROR = "要修改的保险公司名称格式不正确";

	/**
	 * 当前保险公司的名称已存在对应的商险信息，不能进行修改
	 */
	public static final String COMPANY_IS_USED = "当前保险公司的名称已存在对应的商险信息，不能进行修改";


	/** 权限相关提示语 **/

	/**
	 * 非创建人无法编辑保单信息
	 */
	public static final String NOT_CREATE_USER_UPDATE_ERROR = "非创建人无法编辑保单信息";

	/**
	 * 非创建人无法删除保单信息
	 */
	public static final String NOT_CREATE_USER_DELETE_ERROR = "非创建人无法删除保单信息";

	/**
	 * 无更新当前保单信息的权限
	 */
	public static final String NO_UPDATE_DETAIL_JURISDICTION = "无更新当前保单信息的权限";

	/**
	 * 保单信息已过期，不能进行出险操作
	 */
	public static final String INSURANCES_DETAIL_IS_OVERDUE_ERROR = "保单信息已过期，不能进行出险操作";

	/**
	 * 当前的操作类型不正确
	 */

	/**
	 * 减员办理列表为空
	 */

	/**
	 * 减员/投保退回的办理意见不能为空
	 */
	public static final String ROLLBACK_MESSAGE_IS_EMPTY = "办理失败意见不能为空";

	/**
	 * 该保单信息已被删除
	 */
	public static final String INSURANCES_IS_DELETE = "该保单信息已被删除";

	/**
	 * 导入成功
	 */
	public static final String IMPORT_SUCCESS = "导入成功";


	/**
	 * 成功
	 */
	public static final String SUCCESS = "成功";

	/**
	 * 失败
	 */
	public static final String FAILED = "失败";

	/**
	 * 办理结果类型错误
	 */
	public static final String HAND_RESULT_ERROR = "办理结果请填写成功或者失败";

	/**
	 * 办理结果为空
	 */
	public static final String HAND_RESULT_IS_EMPTY = "办理结果不能为空";

	/**
	 * 无该条数据的操作权限
	 */
	public static final String NO_DETAIL_JURISDICTION = "无该条数据的操作权限";

	/**
	 * 当前为待投保状态，不可办理
	 */
	public static final String BUY_HANDLE_STATUS_ONE_HANDLE_ERROR = "当前为待投保状态，不可办理";
	/**
	 * 当前为投保中状态，不可办理
	 */
	public static final String BUY_HANDLE_STATUS_TWO_HANDLE_ERROR = "当前为投保中状态，不可办理";
	/**
	 * 当前为已投保状态，不可办理
	 */
	public static final String BUY_HANDLE_STATUS_THREE_HANDLE_ERROR = "当前为已投保状态，不可办理";
	/**
	 * 当前不是已投保状态
	 */
	public static final String BUY_HANDLE_STATUS_NOT_THREE = "当前不是已投保状态";
	/**
	 * 当前为投保退回状态，不可办理
	 */
	public static final String BUY_HANDLE_STATUS_FOUR_HANDLE_ERROR = "当前为投保退回状态，不可办理";
	/**
	 * 当前为待减员状态，不可办理
	 */
	public static final String REFUND_STATUS_ONE_HANDLE_ERROR = "当前为待减员状态，不可办理";
	/**
	 * 当前为减员退回状态，不可办理
	 */
	public static final String REFUND_STATUS_THREE_HANDLE_ERROR = "当前为减员退回状态，不可办理";
	/**
	 * 当前为已减员状态，不可办理
	 */
	public static final String REFUND_STATUS_FOUR_HANDLE_ERROR = "当前为已减员状态，不可办理";

	/**
	 * 办理意见长度超过50字符限制
	 */
	public static final String HAND_REMARK_NOT_MORE_THAN_50 = "办理意见长度超过50字符限制";

	/**
	 * 操作类型不正确
	 */
	public static final String OPERATION_TYPE_ERROR = "操作类型不正确";

	/**
	 * 该保单信息已被更新为减员成功
	 */
	public static final String INSURANCE_DETAIL_IS_REFUND_SUCCESS = "该保单信息已被更新为减员成功";

	/**
	 * 该保单信息已被更新为减员退回
	 */
	public static final String INSURANCE_DETAIL_IS_REFUND_FAIL = "该保单信息已被更新为减员退回";

	/**
	 * 减员退回的办理意见不能为空
	 */
	public static final String REMARK_IS_EMPTY = "减员退回的办理意见不能为空";

	/**
	 * 列表为空
	 */
	public static final String OPERATION_LIST_IS_EMPTY = "列表为空";


	/**EKP提示*/

	/**
	 * 更新EKP结算月份失败
	 */
	public static final String EKP_UPDATE_SETTLE_MONTH_ERROR = "更新EKP结算月份失败";


	/**电子保单提示*/

	/**
	 * 电子保单为空
	 */
	public static final String INSURANCE_ENCLOSURE_IS_EMPTY = "电子保单为空";

	/**
	 * 非法的电子保单类型
	 */
	public static final String INSURANCE_ENCLOSURE_TYPE_IS_ERROR = "非法的电子保单类型";

	/**
	 * 电子保单超出上传上限
	 */
	public static final String INSURANCE_ENCLOSURE_SIZE_ERROR = "电子保单超出上传上限";

	/**
	 * 电子保单备注字段不能超过50个字符
	 */
	public static final String INSURANCE_ENCLOSURE_REMARK_SIZE_ERROR = "电子保单备注字段不能超过50个字符";

	/**
	 * 电子保单上传成功
	 */
	public static final String INSURANCE_ENCLOSURE_UPLOAD_SUCCESS = "电子保单上传成功";

	/**
	 * 电子保单上传失败
	 */
	public static final String INSURANCE_ENCLOSURE_UPLOAD_FAIL = "电子保单上传失败";

	/**
	 * 电子保单id为空
	 */
	public static final String INSURANCE_ENCLOSURE_ID_IS_EMPTY = "电子保单id为空";

	/**
	 * 无对应的电子保单信息
	 */
	public static final String INSURANCE_ENCLOSURE_IS_NOT_EXIST = "无对应的电子保单信息";

	/**
	 * 删除电子保单成功
	 */
	public static final String INSURANCE_ENCLOSURE_DELETE_SUCCESS = "删除电子保单成功";

	/**
	 * 电子保单删除失败
	 */
	public static final String INSURANCE_ENCLOSURE_DELETE_FAIL = "电子保单删除失败";

	/**
	 * 电子保单删除异常
	 */
	public static final String INSURANCE_ENCLOSURE_DELETE_ABNORMAL = "电子保单删除异常";

	/**
	 * 未结算
	 */
	public static final String SETTLE_ZERO = "未结算";

	/**
	 * 结算中
	 */
	public static final String SETTLE_ONE = "结算中";

	/**
	 * 已结算
	 */
	public static final String SETTLE_TWO = "已结算";

	/**
	 * 无需结算
	 */
	public static final String SETTLE_THREE = "无需结算";

	/**
	 * 订单编号不能为空
	 */
	public static final String ORDER_NO_IS_EMPTY = "订单编号不能为空";

	/**
	 * 购买类型为空
	 */
	public static final String BUY_TYPE_IS_EMPTY = "购买类型为空";

	/**
	 * 购买类型错误
	 */
	public static final String BUY_TYPE_ERROR = "购买类型错误";


	/**
	 * 预估
	 */
	public static final String ESTIMATE_SETTLE_BILL = "预估";

	/**
	 * 实缴
	 */
	public static final String ACTUAL_SETTLE_BILL = "实缴";

	/**
	 * 新增结算单
	 */
	public static final String NEW_SETTLE_BILL = "新增结算单";

	/**
	 * 更新结算单信息
	 */
	public static final String UPDATE_SETTLE_BILL = "更新结算单信息";

	/**
	 * 作废结算单信息
	 */
	public static final String ABOLISH_SETTLE_BILL = "作废结算单信息";

	/**
	 * 红冲结算单信息
	 */
	public static final String CORRECT_SETTLE_BILL = "红冲结算单信息";

	/**
	 * 突发事件创建
	 */
	public static final String URGENT_UPDATE_IS_USE = "突发事件创建";

	/**
	 * 系统触发
	 */
	public static final String SYSTEM_TRIGGER = "系统触发";


	/**
	 * 一次性导出不可超过20000条，请分批导出
	 */
	public static final String EXPORT_TOO_LONG = "一次性导出不可超过20000条，请分批导出";

	/**
	 * 一次性导入不可超过20000条，请分批导入
	 */
	public static final String IMPORT_TOO_LONG = "一次性导入不可超过20000条，请分批导入";

	/**
	 * 结算类型不一致
	 */
	public static final String SETTLE_TYPE_ATYPISM = "结算类型不一致";

	/**
	 * 预估已推送
	 */
	public static final String ESTIMATE_IS_PUSH = "预估已推送";

	/**
	 * 实缴已推送，请分批导入
	 */
	public static final String ACTUAL_IS_PUSH = "实缴已推送";

	/**
	 * 结算id不一致，请分批导入
	 */
	public static final String SETTLE_ID_ATYPISM = "结算id不一致";

	/**
	 * 登记退保费用
	 */
	public static final String REGISTERED_SURRENDER_EXPENSE = "登记退保费用";



	/**
	 * 获取项目信息失败
	 */
	public static final String GET_DEPT_DETAIL_ERROR = "获取项目信息失败:";

	/**
	 * errorList
	 */
	public static final String ERROR_LIST = "errorList";

	/**
	 * successList
	 */
	public static final String SUCCESS_LIST = "successList";

	/**
	 * OSS文件上传接口异常：
	 */
	public static final String OSS_ERROR = "OSS文件上传接口异常：";

	/**EKP异常重发失败原因*/

	/**
	 * 商险不存在或已被删除
	 */
	public static final String EKP_INSURANCE_IS_DELETE_OR_EMPTY = "商险不存在或已被删除";

	/**
	 * 结算类型发生变更
	 */
	public static final String EKP_SETTLE_TYPE_IS_CHANGE = "结算类型发生变更";

	/**
	 * 结算id发生变更
	 */
	public static final String EKP_SETTLE_ID_IS_CHANGE = "结算id发生变更";

	/**
	 * 预估结算信息已发送
	 */
	public static final String EKP_ESTIMATE_IS_PUSH = "预估结算信息已发送";

	/**
	 * 实缴结算信息已发送
	 */
	public static final String EKP_ACTUAL_IS_PUSH = "实缴结算信息已发送";

	/**
	 * 预估费用已进行结算
	 */
	public static final String EKP_ESTIMATE_STATUS_ERROR = "预估费用已进行结算";

	/**
	 * 实缴费用已进行结算
	 */
	public static final String EKP_ACTUAL_STATUS_ERROR = "实缴费用已进行结算";

	/**
	 * 存在与ekp系统交互异常，请联系管理员处理后再操作
	 */
	public static final String EKP_SEND_ERROR = "存在与ekp系统交互异常，请联系管理员处理后再操作";

	/**
	 * 当前登录人无任何商险办理地的操作权限
	 */
	public static final String NO_PERMISSION = "当前登录人无任何商险办理地的操作权限";

	/**
	 * 该记录的商险办理地为空
	 */
	public static final String HANDLE_PROVINCE_IS_NULL = "该记录的商险办理地为空";

	/**
	 * 再次同步状态成功
	 */
	public static final String AGAIN_UPDATE_STATUS = "再次同步状态成功";

	public static final String UPLOAD_PARAM_CHECK_FAIL="上传必要参数不能为空";
	/**
	 * 商险忽略备注
	 */
	public static final String[] INSURANCE_IGNORE_REMARK = {"已续保", "不续保-员工已离职", "不续保-客户停止合作", "不续保-客户要求不续保", "不续保-客户要求转社保", "未续保"};
	/**
	 * 项目名称不可为空
	 */
	public static final String PROJECT_NAME_IS_NOT_EMPTY = "项目名称不可为空";

	/**
	 * 项目编码不可为空
	 */
	public static final String PROJECT_NO_IS_NOT_EMPTY = "项目编码不可为空";

	/**
	 * 商险到期提醒批量导出
	 */
	public static final String INSURANCE_ALERT_EXPORT = "商险到期提醒批量导出";
}
