package com.yifu.cloud.plus.v1.yifu.order.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author licancan
 * @description 订单附件表 t_order_enclosure
 * @date 2022-08-26 17:20:16
 */
@Data
@TableName("t_order_enclosure")
@Schema(description = "订单附件表")
public class TOrderEnclosure implements Serializable {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 附件标识是0时是订单编号，1时是回复表id
     */
	@JsonIgnore
    private String orderNo;

    /**
     * 附件名
     */
	@Schema(description = "附件名")
    private String enclosureName;

    /**
     * 备注
     */
	@Schema(description = "备注")
    private String remark;

    /**
     * 附件标识 0订单附件 1回复附件
     */
	@JsonIgnore
    private Integer enclosureFlag;

    /**
     * 附件地址
     */
	@Schema(description = "附件地址")
    private String enclosureAddress;

    /**
     * 删除标识
     */
	@Schema(description = "删除标识")
    private Integer deleteFlag;

    private static final long serialVersionUID = 1L;
}