package com.yifu.cloud.plus.v1.yifu.order.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 订单列表VO
 * @date 2022-08-29 09:16:07
 */
@Data
@Schema(description = "订单列表VO")
public class OrderListVO implements Serializable{
	private static final long serialVersionUID = 4067597933537194227L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

	/**
	 * 创建时间（下单时间）
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间（下单时间）")
	private LocalDateTime createTime;

	/**
	 * 创建人姓名（下单人）
	 */
	@Schema(description = "创建人姓名（下单人）")
	private String createName;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String deptName;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 订单状态 0待办理 1办理中 2已办结
	 */
	@Schema(description = "订单状态 0待办理 1办理中 2已办结")
	private Integer orderStatus;
}
