package com.yifu.cloud.plus.v1.yifu.order.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.order.service.TOrderService;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderAddVO;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderReplyAddVO;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * @author licancan
 * @description 接收ekp订单controller
 * @date 2022-08-31 08:54:06
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekp/order")
@Tag(name = "接收ekp订单相关")
public class EkpOrderController {
	@Resource
	private TOrderService tOrderService;

	/**
	 * 接收处理ekp订单
	 *
	 * @author licancan
	 * @param vo
	 * @return {@link R}
	 * @throws IOException
	 */
	@Schema(description = "接收处理ekp订单")
	@PostMapping(value = "/receiveOrder")
	public R receiveOrder(OrderAddVO vo) throws IOException {
		return tOrderService.receiveOrder(vo);
	}

	/**
	 * 接收处理ekp订单回复
	 *
	 * @author licancan
	 * @param vo
	 * @return {@link R}
	 * @throws IOException
	 */
	@Schema(description = "接收处理ekp订单回复")
	@PostMapping(value = "/receiveOrderReply")
	public R receiveOrderReply(OrderReplyAddVO vo) throws IOException {
		return tOrderService.receiveOrderReply(vo);
	}

}
