package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;


/**
 * 各地市最低工资标准
 *
 * @author hgw
 * @date 2019-10-15 21:45:23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_min_salary")
@Tag(name = "薪资配置-最低工资配置")
public class TMinSalary extends BaseEntity {
     private static final long serialVersionUID = 1L;
     /**
      * id
      */
     @TableId(type = IdType.ASSIGN_ID)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "id")
     private String id;
     /**
      * 省
      */
     @ExcelAttribute(name = "省")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "省")
     private Integer province;
     /**
      * 市
      */
     @ExcelAttribute(name = "市")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "市")
	 @TableField(updateStrategy = FieldStrategy.IGNORED)
     private Integer city;
     /**
      * 县
      */
     @ExcelAttribute(name = "县")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "县")
	 @TableField(updateStrategy = FieldStrategy.IGNORED)
     private Integer town;
     /**
      * 最低工资标准
      */
     @NotBlank(message = "最低工资标准不能为空")
     @Length(max = 11, message = "最低工资标准不能超过11个字符")
     @ExcelAttribute(name = "最低工资标准", isNotEmpty = true, errorInfo = "最低工资标准不能为空", maxLength = 11)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最低工资标准")
     private String salaryBase;
     /**
      * 1.启用 2.停用
      */
     @NotNull(message = "1.启用 2.停用不能为空")
     @ExcelAttribute(name = "1.启用 2.停用", isNotEmpty = true, errorInfo = "1.启用 2.停用不能为空")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "1.启用 2.停用")
     private Integer status;
     /**
      * 起始时间
      */
     @ExcelAttribute(name = "起始时间")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "起始时间")
     private LocalDate startDate;
     /**
      * 终止时间
      */
     @ExcelAttribute(name = "终止时间")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "终止时间")
     private LocalDate endDate;
}
