/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标准薪酬工资表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_salary_standard")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "标准薪酬工资表")
public class TSalaryStandard extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 部门ID
	 */
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID不能为空", maxLength = 32)
	@NotBlank(message = "部门ID不能为空")
	@Length(max = 32, message = "部门ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String deptId;
	/**
	 * 部门名称
	 */
	@ExcelAttribute(name = "部门名称", isNotEmpty = true, errorInfo = "部门名称不能为空", maxLength = 50)
	@NotBlank(message = "部门名称不能为空")
	@Length(max = 50, message = "部门名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门名称")
	private String deptName;
	/**
	 * 部门编码
	 */
	@ExcelAttribute(name = "部门编码", maxLength = 32)
	@Length(max = 32, message = "部门编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门编码")
	private String deptNo;
	/**
	 * 结算金额
	 */
	@ExcelAttribute(name = "结算金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算金额")
	private BigDecimal settlementAmount;
	/**
	 * 所属分公司id（创建人的部门id）
	 */
	@ExcelAttribute(name = "所属分公司id（创建人的部门id）", isNotEmpty = true, errorInfo = "所属分公司id（创建人的部门id）不能为空", maxLength = 32)
	@NotBlank(message = "所属分公司id（创建人的部门id）不能为空")
	@Length(max = 32, message = "所属分公司id（创建人的部门id）不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属分公司id（创建人的部门id）")
	private String belongDeptId;
	/**
	 * 所属分公司CODE（创建人的部门CODE）
	 */
	@ExcelAttribute(name = "所属分公司CODE（创建人的部门CODE）", isNotEmpty = true, errorInfo = "所属分公司CODE（创建人的部门CODE）不能为空", maxLength = 50)
	@NotBlank(message = "所属分公司CODE（创建人的部门CODE）不能为空")
	@Length(max = 50, message = "所属分公司CODE（创建人的部门CODE）不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属分公司CODE（创建人的部门CODE）")
	private String belongDeptCode;
	/**
	 * 结算月份（YYYYMM）
	 */
	@ExcelAttribute(name = "结算月份（YYYYMM）", isNotEmpty = true, errorInfo = "结算月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "结算月份（YYYYMM）不能为空")
	@Length(max = 6, message = "结算月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月份（YYYYMM）")
	private String settlementMonth;
	/**
	 * 表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬
	 */
	@ExcelAttribute(name = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬", isNotEmpty = true, errorInfo = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬不能为空", maxLength = 32)
	@NotBlank(message = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬不能为空")
	@Length(max = 32, message = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬")
	private String formType;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 500)
	@Length(max = 500, message = "备注不能超过500个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remark;
	/**
	 * 工资月份（YYYYMM）
	 */
	@ExcelAttribute(name = "工资月份（YYYYMM）", isNotEmpty = true, errorInfo = "工资月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "工资月份（YYYYMM）不能为空")
	@Length(max = 6, message = "工资月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资月份（YYYYMM）")
	private String salaryMonth;
	/**
	 * 款项来源（0客户到款/1垫付）
	 */
	@ExcelAttribute(name = "款项来源（0客户到款/1垫付）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("款项来源（0客户到款/1垫付）")
	private Integer moneyFrom;
	/**
	 * 状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印 10 推送失败 11 推送收入中12推送收入失败）
	 */
	@ExcelAttribute(name = "状态（0待提交1待审核2:待推送明细3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印10 推送失败 11 已审核生成收入中12已审核生成收入失败）", isNotEmpty = true, errorInfo = "状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印）不能为空")
	@NotBlank(message = "状态（0待提交1待审核2:待推送明细3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印10 推送失败 11 已审核生成收入中12已审核生成收入失败）不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("状态（0待提交1待审核2:待推送明细3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印 10 推送失败 11 已审核生成收入中12已审核生成收入失败）")
	private Integer status;
	/**
	 * 提交时间
	 */
	@ExcelAttribute(name = "提交时间", isDate = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("提交时间")
	private Date submitTime;
	/**
	 * 是否删除0：未删除；1:已删除
	 */
	@ExcelAttribute(name = "是否删除0：未删除；1:已删除", isNotEmpty = true, errorInfo = "是否删除0：未删除；1:已删除不能为空")
	@NotBlank(message = "是否删除0：未删除；1:已删除不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否删除0：未删除；1:已删除")
	private Integer deleteFlag;
	/**
	 * 最终审核人
	 */
	@ExcelAttribute(name = "最终审核人", maxLength = 32)
	@Length(max = 32, message = "最终审核人不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最终审核人")
	private String auditUser;
	/**
	 * 最终审核时间
	 */
	@ExcelAttribute(name = "最终审核时间", isDate = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最终审核时间")
	private Date auditTime;
	/**
	 * 审核意见
	 */
	@ExcelAttribute(name = "审核意见", maxLength = 500)
	@Length(max = 500, message = "审核意见不能超过500个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("审核意见")
	private String auditRemark;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("省")
	private Integer province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("市")
	private Integer city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("县")
	private Integer town;
	/**
	 * 类型：0：工资；1：非扣税项
	 */
	@ExcelAttribute(name = "类型：0：工资；1：非扣税项")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0：工资；1：非扣税项")
	private Integer type;
	/**
	 * 自有员工人数，默认0
	 */
	@ExcelAttribute(name = "自有员工人数，默认0")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("自有员工人数，默认0")
	private Integer ownNums;
	/**
	 * 自有员工应发总额
	 */
	@ExcelAttribute(name = "自有员工应发总额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("自有员工应发总额")
	private BigDecimal ownMoney;
	/**
	 * 发薪特殊值人数，默认0
	 */
	@ExcelAttribute(name = "发薪特殊值人数，默认0")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发薪特殊值人数，默认0")
	private Integer specialNums;
	/**
	 * 发薪特殊值应发总额
	 */
	@ExcelAttribute(name = "发薪特殊值应发总额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发薪特殊值应发总额")
	private BigDecimal specialMoney;
	/**
	 * 薪资员工发放稿酬/劳务费人数，默认0
	 */
	@ExcelAttribute(name = "薪资员工发放稿酬/劳务费人数，默认0")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("薪资员工发放稿酬/劳务费人数，默认0")
	private Integer salaryNums;
	/**
	 * 薪资员工发放稿酬/劳务费总额
	 */
	@ExcelAttribute(name = "薪资员工发放稿酬/劳务费总额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("薪资员工发放稿酬/劳务费总额")
	private BigDecimal salaryMoney;
	/**
	 * 本月是否重复金额人数，默认0
	 */
	@ExcelAttribute(name = "本月是否重复金额人数，默认0")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本月是否重复金额人数，默认0")
	private Integer repeatNums;
	/**
	 * 本月是否重复金额总额
	 */
	@ExcelAttribute(name = "本月是否重复金额总额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本月是否重复金额总额")
	private BigDecimal repeatMoney;
	/**
	 * 自有员工强行提交的备注
	 */
	@ExcelAttribute(name = "自有员工强行提交的备注", maxLength = 200)
	@Length(max = 200, message = "自有员工强行提交的备注不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("自有员工强行提交的备注")
	private String ownRemark;

	@Schema(description = "劳务费、稿酬是否含有发薪0：否；1：是")
	@ExcelAttribute(name = "劳务费、稿酬是否含有发薪")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("劳务费、稿酬是否含有发薪")
	private Integer haveSalaryFlag;

	@Schema(description = "含有发薪的强行提交的备注", name = "haveSalaryRemark")
	@ExcelAttribute(name = "含有发薪的强行提交的备注")
	private String haveSalaryRemark;

	@Schema(description = "是否含有特殊金额0：否；1：是")
	@ExcelAttribute(name = "是否含有特殊金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否含有特殊金额")
	private Integer haveSpecialFlag;

	@Schema(description  = "含有特殊金额的强行提交的备注", name = "haveSpecialRemark")
	@ExcelAttribute(name = "含有特殊金额的强行提交的备注")
	private String haveSpecialRemark;

	/**
	 * 本月是否重复金额0：否；1：是重复导入的
	 */
	@ExcelAttribute(name = "本月是否重复金额0：否；1：是重复导入的")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本月是否重复金额0：否；1：是重复导入的")
	private Integer isRepeat;

	@Schema(description  = "本月重复金额的备注", name = "repeatRemark")
	@ExcelAttribute(name = "本月重复金额的备注")
	private String repeatRemark;

	/**
	 * 提交备注
	 */
	@ExcelAttribute(name = "提交备注", maxLength = 1000)
	@Length(max = 1000, message = "提交备注不能超过1000个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("提交备注")
	private String submitRemark;

	/**
	 * 客户ID
	 */
	@ExcelAttribute(name = "客户ID", isNotEmpty = true, errorInfo = "客户ID不能为空", maxLength = 32)
	@NotBlank(message = "客户ID不能为空")
	@Length(max = 32, message = "客户ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户ID")
	private String unitId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", isNotEmpty = true, errorInfo = "客户名称不能为空", maxLength = 50)
	@NotBlank(message = "客户名称不能为空")
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	private String unitNo;

	/**
	 * 推送时间
	 */
	@ExcelAttribute(name = "推送时间", isDate = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("推送时间")
	private Date sendTime;

	/**
	 * 推送月份（YYYYMM）
	 */
	@ExcelAttribute(name = "推送月份（YYYYMM）", isNotEmpty = true, errorInfo = "推送月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "推送月份（YYYYMM）不能为空")
	@Length(max = 6, message = "推送月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("推送月份（YYYYMM）")
	private String sendMonth;
	/**
	 * 封面抬头
	 */
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	@Length(max = 50, message = "封面抬头不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头")
	private String invoiceTitle;

	/**
	 * 订单ID
	 */
	@ExcelAttribute(name = "订单ID")
	@Schema(description = "订单ID" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("订单ID" )
	private String orderId;

	/**
	 * 申请编码
	 */
	@Schema(description = "申请编码")
	private String applyNo;
	/**
	 * 推送时间
	 */
	@ExcelAttribute(name = "退表时间", isDate = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("退表时间")
	private Date backTime;
	/**
	 * 退表EkpId
	 */
	@ExcelAttribute(name = "退表EkpId")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("退表EkpId")
	private String backEkpId;
	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO")
	@ExcelIgnore
	private String bpoFlag;

	/**
	 * 生成、推送收入的开始时间
	 */
	@ExcelAttribute(name = "生成、推送收入的开始时间", isDate = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生成、推送收入的开始时间")
	private Date incomeStartTime;

	/**
	 * 生成、推送收入的完成时间
	 */
	@ExcelAttribute(name = "生成、推送收入的完成时间", isDate = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生成、推送收入的完成时间")
	private Date incomeEndTime;

	/**
	 * 代发户状态（0正常；1代发户）
	 */
	@ExcelAttribute(name = "代发户状态（0正常；1代发户）"  )
	@ExcelProperty("代发户状态（0正常；1代发户）")
	@Schema(description ="代发户状态（0正常；1代发户）")
	private Integer issueStatus;

	/**
	 * 是否差额单 默认0否； 1是
	 */
	@Schema(description = "是否差额单")
	private String isDiff;

	/**
	 * 工资月份-起
	 */
	@TableField(exist = false)
	private String salaryMonthStart;
	/**
	 * 工资月份-止
	 */
	@TableField(exist = false)
	private String salaryMonthEnd;

	@TableField(exist = false)
	@Schema(description = "创建时间起")
	private String createTimeStart;

	@TableField(exist = false)
	@Schema(description = "创建时间止")
	private String createTimeEnd;
}
