/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 薪资表与代发户表关联表
 *
 * @author hgw
 * @date 2023-01-10 11:34:27
 */
@Data
@TableName("t_salary_standard_issue_res")
@Schema(description = "薪资表与代发户表关联表")
public class TSalaryStandardIssueRes implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 代发户配置id
	 */
	@ExcelAttribute(name = "代发户配置id", isNotEmpty = true, errorInfo = "代发户配置id不能为空", maxLength = 32)
	@NotBlank(message = "代发户配置id不能为空")
	@Length(max = 32, message = "代发户配置id不能超过32个字符")
	@ExcelProperty("代发户配置id")
	@Schema(description = "代发户配置id")
	private String issueId;
	/**
	 * 薪资主表id
	 */
	@ExcelAttribute(name = "薪资主表id", isNotEmpty = true, errorInfo = "薪资主表id不能为空", maxLength = 32)
	@NotBlank(message = "薪资主表id不能为空")
	@Length(max = 32, message = "薪资主表id不能超过32个字符")
	@ExcelProperty("薪资主表id")
	@Schema(description = "薪资主表id")
	private String salaryId;
	/**
	 * money
	 */
	@ExcelAttribute(name = "money", isNotEmpty = true, errorInfo = "money不能为空")
	@NotBlank(message = "money不能为空")
	@ExcelProperty("money")
	@Schema(description = "money")
	private BigDecimal money;

	/**
	 * 户名
	 */
	@ExcelAttribute(name = "户名", maxLength = 50)
	@Length(max = 50, message = "户名不能超过50个字符")
	@ExcelProperty("户名")
	@Schema(description = "户名")
	private String orgName;
	/**
	 * 开户行总行
	 */
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Length(max = 50, message = "开户行总行不能超过50个字符")
	@ExcelProperty("开户行总行")
	@Schema(description = "开户行总行")
	private String bankName;
	/**
	 * 开户行支行
	 */
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Length(max = 50, message = "开户行支行不能超过50个字符")
	@ExcelProperty("开户行支行")
	@Schema(description = "开户行支行")
	private String bankSubName;
	/**
	 * 银行卡号
	 */
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	@Length(max = 50, message = "银行卡号不能超过50个字符")
	@ExcelProperty("银行卡号")
	@Schema(description = "银行卡号")
	private String bankNo;
	/**
	 * 开户行省
	 */
	@ExcelAttribute(name = "开户行省")
	@ExcelProperty("开户行省")
	@Schema(description = "开户行省")
	private Integer bankProvince;
	/**
	 * 开户行市
	 */
	@ExcelAttribute(name = "开户行市")
	@ExcelProperty("开户行市")
	@Schema(description = "开户行市")
	private Integer bankCity;

	/**
	 * 开户行省名称
	 */
	@ExcelAttribute(name = "开户行省名称")
	@ExcelProperty("开户行省名称")
	@Schema(description = "开户行省名称")
	private String bankProvinceName;
	/**
	 * 开户行市
	 */
	@ExcelAttribute(name = "开户行市名称")
	@ExcelProperty("开户行市名称")
	@Schema(description = "开户行市名称")
	private String bankCityName;
}
