package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TMinSalary;
import com.yifu.cloud.plus.v1.yifu.salary.service.TMinSalaryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * @Author fxj
 * @Description 各地市最低工资标准
 * @Date 13:32 2022/8/6
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/tminsalary")
@Tag(name = "薪资配置-最低工资配置")
public class TMinSalaryController {

	private final TMinSalaryService tMinSalaryService;

	/**
	 * 简单分页查询
	 *
	 * @param page       分页对象
	 * @param tMinSalary 各地市最低工资标准
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TMinSalary>> getTMinSalaryPage(Page<TMinSalary> page, TMinSalary tMinSalary) {
		return new R<>(tMinSalaryService.getTMinSalaryPage(page, tMinSalary));
	}


	/**
	 * 通过id查询单条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "id查询")
	@GetMapping("/{id}")
	public R<TMinSalary> getById(@PathVariable("id") String id) {
		return new R<>(tMinSalaryService.getById(id));
	}

	/**
	 * 新增记录
	 *
	 * @param tMinSalary
	 * @return R
	 */
	@Operation(description = "新增(wxhr:tminsalary_add)")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tminsalary_add')")
	public R<Boolean> save(@Valid @RequestBody TMinSalary tMinSalary) {
		return tMinSalaryService.saveDiy(tMinSalary);
	}

	/**
	 * 修改记录
	 *
	 * @param tMinSalary
	 * @return R
	 */
	@Operation(description = "修改(wxhr:tminsalary_edit)")
	@SysLog("修改各地市最低工资标准")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tminsalary_edit')")
	public R<Boolean> update(@RequestBody TMinSalary tMinSalary) {
		return tMinSalaryService.updateByIdDIy(tMinSalary);
	}

	/**
	 * 通过id删除一条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "删除(wxhr:tminsalary_del)")
	@SysLog("删除各地市最低工资标准")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('wxhr:tminsalary_del')")
	public R removeById(@PathVariable String id) {
		return new R<>(tMinSalaryService.removeById(id));
	}

}
