/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandard;
import com.yifu.cloud.plus.v1.yifu.salary.vo.AccountByEkpDiffVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 标准薪酬工资表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TSalaryStandardService extends IService<TSalaryStandard> {
    /**
     * 标准薪酬工资表简单分页查询
     * @param tSalaryStandard 标准薪酬工资表
     * @return
     */
    IPage<TSalaryStandard> getTSalaryStandardPage(Page<TSalaryStandard> page, TSalaryStandardSearchVo tSalaryStandard);

    void listExport(HttpServletResponse response, TSalaryStandardSearchVo searchVo);

    List<TSalaryStandardExportVo> noPageDiy(TSalaryStandardSearchVo searchVo);

	/**
	 * 标准薪酬工资表审核页面简单分页查询
	 * @param tSalaryStandard 标准薪酬工资表
	 * @return
	 */
	IPage<TSalaryStandard> getTSalaryStandardAuditPage(Page<TSalaryStandard> page, TSalaryStandardSearchVo tSalaryStandard);

	/**
	 * 标准薪酬工资表审核
	 * @param auditFlag 是否通过 0 是 1 否
	 * @param auditRemark 审核意见
	 * @param id
	 * @return
	 */
	R<String> salaryStandardAudit(String auditFlag, String auditRemark,String id);

	/**
	 * @param id 工资表id
	 * @Description: 重新生成收入
	 * @Author: hgw
	 * @Date: 2022/11/29 17:49
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> salaryDoIncome(String id);

	/**
	 * @Description: 删除工资表
	 * @Author: hgw
	 * @Date: 2022/8/12 16:01
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> deleteSalaryById(String id);

	/**
	 * @param id
	 * @Description: 推送至ekp
	 * @Author: hgw
	 * @Date: 2022/8/26 11:56
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> doSend(String id);

	/**
	 * @Description: 分页查询-申请
	 * @Author: hgw
	 * @Date: 2022/9/6 16:02
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandard>
	 **/
	IPage<TSalaryStandard> getTSalaryStandardPageApply(Page<TSalaryStandard> page, TSalaryStandardSearchVo tSalaryStandard);

	/**
	 * @Description: 添加流程进展明细
	 * @Author: hgw
	 * @Date: 2022/9/6 15:59
	 * @return: void
	 **/
	void saveRecordLog(TSalaryStandard tSalaryStandard, YifuUser user, String status, String nodeId);

	/**
	 * @Description: 从EKP退回薪资表
	 * @Author: hgw
	 * @Date: 2022/11/4 16:32
	 * @return:
	 **/
	R<String> backSalaryByApplyNo(String applyNo);

	String testSendEkpList(String id);

	/**
	 * @Description: 差额单--EKP调用接口
	 * @Author: hgw
	 * @Date: 2023/1/31 17:29
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> saveSalaryDiff(List<AccountByEkpDiffVo> voList);

}
