package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author fxj
 * @Date 2022/7/27
 * @Description
 * @Version 1.0
 */
@Data
public class SocialHandleSearchVo extends TDispatchInfo {
	//派单开始时间（查询专用）
	@ExcelAttribute(name = "创建开始时间")
	@TableField(exist = false)
	private LocalDateTime createTimeStart;
	//派单截止时间（查询专用）
	@ExcelAttribute(name = "创建截止时间")
	@TableField(exist = false)
	private LocalDateTime createTimeEnd;

	/**
	 * 社保户
	 */
	@Schema(description = "社保户" )
	@TableField(exist = false)
	private String socialHouseholdName;

	/**
	 * 公积金户
	 */
	@Schema(description = "公积金户" )
	@TableField(exist = false)
	private String providentHouseholdName;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	private int limitEnd;

	private String idStr;

	/**
	 * 审核时间开始时间
	 */
	@TableField(exist = false)
	@Schema(description = "审核时间开始时间" )
	@ExcelIgnore
	private String auditTimeStart;
	/**
	 * 审核时间截止时间
	 */
	@TableField(exist = false)
	@Schema(description = "审核时间截止时间" )
	@ExcelIgnore
	private String auditTimeEnd;

	/**
	 * 派单项：如 养老、公积金
	 */
	@ExcelAttribute(name = "派单项查询")
	@Schema(description = "派单项查询" )
	private List<String> dispatchItems;
}
