/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentBySalaryVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@Mapper
public interface TPaymentInfoMapper extends BaseMapper<TPaymentInfo> {
    /**
     * 缴费库简单分页查询
     * @param tPaymentInfo 缴费库
     * @return
     */
    IPage<TPaymentInfo> getTPaymentInfoPage(Page<TPaymentInfo> page, @Param("tPaymentInfo") TPaymentInfoSearchVo tPaymentInfo);

	/**
	 * 缴费库简单分页查询
	 * @param searchVo 缴费库
	 * @return
	 */
	Integer selectCountTPaymentInfo(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库简单分页查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfoBatchVo> getTPaymentInfoNoPage(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库合并导出查询
	 * @param searchVo 缴费库
	 * @return
	 */
	Integer selectCountSumPaymentInfo(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库简单分页查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfoPushVo> getTPaymentInfoSumPushList(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库合并导出查询
	 * @param searchVo 缴费库
	 * @return
	 */
	Integer getTPaymentInfoSumPushCount(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库简单分页查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfoExportVo> getTPaymentInfoSumNoPage(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 更新社保或者公积金
	 * @param tPaymentInfo 缴费库
	 * @return
	 */
	int updateDeleteInfo(@Param("tPaymentInfo")TPaymentInfo tPaymentInfo);

	/**
	 * 更新结算状态
	 * @param tPaymentInfo 缴费库
	 * @return
	 */
	int updateStatusById(@Param("tPaymentInfo")TPaymentInfo tPaymentInfo);

	/**
	 * 更新结算状态
	 * @param sUpdateList 缴费库
	 * @return
	 */
	int updateBatchByIdList(@Param("details")List<TPaymentInfo> sUpdateList);

	/**
	 * 更新结算状态
	 * @param sUpdateList 缴费库
	 * @return
	 */
	int updateBatchByIdList1(@Param("details")List<TPaymentInfo> sUpdateList);

	/**
	 * 通过ID获取缴费库 及社保、公积金明细
	 * @param id
	 * @return
	 **/
	TPaymentInfoVo getAllInfoById(String id);

	List<TPaymentInfo> getAllPushInfoById(@Param("idStr") String idStr);

	/*
	* 已存在社保缴费库数据  非删除状态
	* @param months
	* @param idcards
	* @return
	* */
	List<TPaymentInfo> selectListForPaymentImport(@Param("months")List<String> months, @Param("idcards")List<String> idcards);

	/*
	 * 已存在公积金缴费库数据  非删除状态
	 * @param months
	 * @param idcards
	 * @return
	 * */
	List<TPaymentInfo> selectListForPaymentImport1(@Param("months")List<String> months, @Param("idcards")List<String> idcards);

	/**
	 * 薪资获取缴费库
	 * @Author hgw
	 * @Date 2022-8-10 18:06:13
	 **/
	List<TPaymentBySalaryVo> selectTPaymentBySalaryVo(@Param("tPaymentInfo") TPaymentBySalaryVo tPaymentInfo);

	/**
	 * 更新社保结算状态
	 * @Author hgw
	 * @Date 2020-4-13 16:01:59
	 * @param idList
	 * @param status
	 * @return
	 **/
	int updatePaymentSocialStatusByIdList(@Param("idList") List<String> idList, @Param("status") String status);

	int updatePaymentFundStatusByIdList(@Param("idList")List<String> idList, @Param("status") String status);

	void updatePaymentSocialAndFound(@Param("infoVo") UpdateSocialFoundVo infoVo);

	void updateByIncome(@Param("id")String id);

	/**
	 * 更新社保推送
	 * @Author huyc
	 * @Date 2022-8-30
	 * @param idList
	 * @return
	 **/
	int updatePushStatus(@Param("idList") List<String> idList);

	/**
	 * @param idSet
	 * @Description: 校验缴费库是否有已结算的数据，有，则不允许ekp费用划转
	 * @Author: hgw
	 * @Date: 2022/11/16 17:32
	 * @return: int
	 **/
	int checkPaymentChange(@Param("idSet") Set<String> idSet);

	/**
	 * @param idSet
	 * @Description: 修改缴费库
	 * @Author: hgw
	 * @Date: 2022-11-16 17:51:41
	 * @return: int
	 **/
	int changePaymentDept(@Param("idSet") Set<String> idSet, @Param("dept") TSettleDomainSelectVo dept);

	/**
	 * 缴费库未打标数据查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<String> getTPaymentInfoList(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo);

	/**
	 * 缴费库公积金推送查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfo> getTPaymentFundPushInfo(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo,
											   @Param("userId") String userId);

	/**
	 * 缴费库社保收入推送查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfo> getTPaymentSocialIncomeInfo(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo,
												   @Param("userId") String userId);

	/**
	 * 缴费库公积金收入推送查询
	 * @param searchVo 缴费库
	 * @return
	 */
	List<TPaymentInfo> getTPaymentFundIncomeInfo(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo,
												 @Param("userId") String userId);

	void updateBySocialPayment(@Param("id")String id);

	void updateBySocialPaymentList(@Param("idStr")String idStr);

	void updateBySocialIncomePayment(@Param("id")String id);

	void updateBySocialIncomeFlag(@Param("id")String id);

	/**
	 * 缴费库公积金推送查询
	 * @param searchVo 缴费库
	 * @return
	 */
	long getTPaymentFundPushCount(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo,
											   @Param("userId") String userId);

	/**
	 * 缴费库社保收入推送查询
	 * @param searchVo 缴费库
	 * @return
	 */
	long getTPaymentSocialIncomeCount(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo,
												   @Param("userId") String userId);

	/**
	 * 缴费库公积金收入推送查询
	 * @param searchVo 缴费库
	 * @return
	 */
	long getTPaymentFundIncomeCount(@Param("tPaymentInfo") TPaymentInfoSearchVo searchVo,
												 @Param("userId") String userId);

	/**
	 * B端使用，查询缴费库信息
	 * @Author fxj
	 * @Date 2019-10-12
	 * @param paymentInfo
	 * @param settleDomainIds
	 * @param idsStr
	 * @param empIds
	 * @return
	 **/
	List<TPaymentInfoVo> getPaymentAllInfoList(@Param("tPaymentInfo") TPaymentInfo paymentInfo
			, @Param("settleDomainIds") List<String> settleDomainIds, @Param("idsStr") List<String> idsStr
			, @Param("empIds")List<String> empIds);

	/**
	 * B端社保公积金列表查询
	 * @Author fxj
	 * @Date 2020-08-28
	 * @param socialAndFundBusinessPageVo
	 * @param settleDomainIds
	 * @return
	 **/
	List<SocialAndFundBusinessPageVo> getSocialAndFundBusinessDataPage(
			@Param("socialAndFundBusinessPageVo") SocialAndFundBusinessPageVo socialAndFundBusinessPageVo
			, @Param("settleDomainIds")List<String> settleDomainIds);
	/**
	 * B端社保公积金列表查询
	 * @Author fxj
	 * @Date 2020-08-28
	 * @param socialAndFundBusinessPageVo
	 * @param settleDomainIds
	 * @return
	 **/
	List<SocialAndFundBusinessPageVo> getSocialAndFundBusinessDataCount(
			@Param("socialAndFundBusinessPageVo")SocialAndFundBusinessPageVo socialAndFundBusinessPageVo
			, @Param("settleDomainIds")List<String> settleDomainIds);

	// B端
	List<String> getSocialOrFundAddEmpIds(@Param("month")String month, @Param("settleDomainId")String settleDomainId
			, @Param("settleDomainIds")List<String> settleDomainIds);

	// B端
	IPage<PaymentBusinessPageVo> getPaymentBusinessPageVo(Page page
			, @Param("paymentBusinessPageVo") PaymentBusinessPageVo paymentBusinessPageVo
			, @Param("settleDomainIds") List<String> settleDomainIds, @Param("empIds")List<String> empIds);

	/**
	 * B端-获取派增社保或公积金人数
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param month
	 * @param settleDomainId
	 * @param settleDomainIds
	 * @param type 0 获取所有办理成功状态的社保和公积金人数  1 获取所有本月派增办理成功的社保或公积金人数
	 * @return
	 **/
	int getSocialOrFundAddCount(@Param("month") String month, @Param("settleDomainId") String settleDomainId, @Param("settleDomainIds") List<String> settleDomainIds, @Param("type")Integer type);
	/**
	 * B端
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param month
	 * @param settleDomainId
	 * @param settleDomainIds
	 * @return
	 **/
	int getSocialOrFundReduceCount(@Param("month")String month, @Param("settleDomainId")String settleDomainId, @Param("settleDomainIds")List<String> settleDomainIds);

	IPage<SocialAndFundReduceBusinessVo> getSocialAndFundReduceInfo(Page page, @Param("month")String month
			, @Param("settleDomainId")String settleDomainId, @Param("settleDomainIds")List<String> settleDomainIds);

}
