/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TSocialFundInfoExportVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TSocialFundInfoSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 社保公积金查询表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Mapper
public interface TSocialFundInfoMapper extends BaseMapper<TSocialFundInfo> {
    /**
     * 社保公积金查询表简单分页查询
     * @param tSocialFundInfo 社保公积金查询表
     * @return
     */
    IPage<TSocialFundInfo> getTSocialFundInfoPage(Page<TSocialFundInfo> page, @Param("tSocialFundInfo") TSocialFundInfo tSocialFundInfo);

	/**
	 * @Description: 获取可生成预估的社保
	 * @Author: hgw
	 * @Date: 2022/7/19 19:09
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo>
	 **/
	List<TSocialFundInfo> getSocialList(@Param("empIdCard") String empIdCard, @Param("settleDomainIds") List<String> settleDomainIds);

	/**
	 * @Description: 获取可生成预估的公积金
	 * @Author: hgw
	 * @Date: 2022/7/19 19:09
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo>
	 **/
	List<TSocialFundInfo> getFundList(@Param("empIdCard") String empIdCard, @Param("settleDomainIds") List<String> settleDomainIds);


	List<TSocialFundInfoExportVo> exportList(@Param("tSocialFundInfo") TSocialFundInfoSearchVo tSocialFundInfo);

	Integer exportListCount(@Param("tSocialFundInfo") TSocialFundInfoSearchVo tSocialFundInfo);

	void updateSocialAndFoundInfo(@Param("infoVo") UpdateSocialFoundVo infoVo);

	void updateSocialAndFoundInfoF(@Param("infoVo") UpdateSocialFoundVo infoVo);

	/**
	 * @Description: 划转同步更新社保
	 * @Author: hgw
	 * @Date: 2022/11/30 17:36
	 * @return: void
	 **/
	void updateSocialInfo(@Param("infoVo") UpdateSocialFoundVo infoVo);

	/**
	 * @Description: 划转同步更新公积金
	 * @Author: hgw
	 * @Date: 2022/11/30 17:36
	 * @return: void
	 **/
	void updateFundInfo(@Param("infoVo") UpdateSocialFoundVo infoVo);

	String selectSocialByContract(@Param("tSocialFundInfo") TSocialFundInfo tSocialFundInfo);
	String selectFundByContract(@Param("tSocialFundInfo") TSocialFundInfo tSocialFundInfo);

}
