/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SocialAndFundReduceVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import org.apache.shardingsphere.transaction.annotation.ShardingTransactionType;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
public interface TDispatchInfoService extends IService<TDispatchInfo> {
    /**
     * 派单信息记录表简单分页查询
     * @param tDispatchInfo 派单信息记录表
     * @return
     */
    IPage<TDispatchInfoPageVo> getTDispatchInfoPage(Page<TDispatchInfo> page, TDispatchInfoSearchVo tDispatchInfo);

	IPage<TDispatchInfoPageVo> getTDispatchInfoPageAudit(Page<TDispatchInfo> page, TDispatchInfoSearchVo tDispatchInfo);

	R<List<ErrorMessage>> importDiy(InputStream inputStream, String orderId);

    void listExport(HttpServletResponse response, TDispatchInfoSearchVo searchVo);

	void listAuditExport(HttpServletResponse response, TDispatchInfoSearchVo searchVo);

    List<TDispatchInfo> noPageDiy(TDispatchInfoSearchVo searchVo);

	@Transactional
	@ShardingTransactionType(TransactionType.BASE)
	void importTDispatchInfo(List<TDispatchImportVo> excelVOList,
							 List<ErrorMessage> errorMessageList,
							 YifuUser user, String orderId, Map<String, String> idCardMap);

	R<List<ErrorMessage>> importReduceDiy(InputStream inputStream, String orderId);

	@Transactional
	@ShardingTransactionType(TransactionType.BASE)
	void batchReduceDispatch(List<TDispatchReduceVo> excelVOList, List<ErrorMessage> errorMessageList, YifuUser user, String orderId);

	R<Boolean> removeByIdDiy(String id);

	DispatchDetailVo getSocialAndFundInfoById(String id);

    List<ErrorMessage> addBatchApplyAudit(List<String> idsList, YifuUser user, int flag, String auditStatus, String auditRemark, String remark);

	R<List<ErrorMessage>>  addApplyAudit(List<String> ids, String auditStatus, String auditRemark, String remark);

	R<List<ErrorMessage>>  addApplyHandle(List<String> ids, String typeSub, String handleStatus, String handleRemark, String socialType, String remark);

	void doexportSocialRecordRoster(HttpServletResponse response, SocialHandleSearchVo searchVo, String idStr, String[] exportFields);

	IPage<TDispatchInfo> getTDispatchSocialHandlePage(Page<TDispatchInfo> page, SocialHandleSearchVo tDispatchInfo);

	IPage<TDispatchInfo> getTDispatchFundHandlePage(Page<TDispatchInfo> page, SocialHandleSearchVo tDispatchInfo);

	R<List<FundSupplementaryExportVo>> getFundSupplementaryRecords(String idStr,SocialHandleSearchVo dispatchInfo, List<String> settleDomains, String sql);

	void doexportFundRecordChange(HttpServletResponse response,String idStr, SocialHandleSearchVo searchVo);

	/**
	 * 获取社保和公积金派减日期
	 * @Author hgw
	 * @Date 2023-1-5 11:00:47
	 * @param empId
	 * @return
	 **/
	SocialAndFundReduceVo getSocialAndFundReduceInfo(String empId);

}
