package com.yifu.cloud.plus.v1.yifu.social.service;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.ErrorDetailVO;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpSocialViewVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentBySalaryVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 缴费库
 * @author huyc
 * @date 2022-07-22 17:01:22
 */
public interface TPaymentInfoService extends IService<TPaymentInfo> {
	/**
	 * 缴费库简单分页查询
	 * @param tPaymentInfo 缴费库
	 * @return
	 */
	IPage<TPaymentInfo> getTPaymentInfoPage(Page<TPaymentInfo> page, TPaymentInfoSearchVo tPaymentInfo);

	/**
	 * 缴费库批量导入社保
	 * @param inputStream
	 * @return
	 */
	R<List<ErrorDetailVO>> importSocialDiy(InputStream inputStream);

	/**
	 * 批量新增缴费库-合肥三险
	 * @param inputStream
	 * @param random
	 * @param type
	 * @return
	 */
	R<List<ErrorDetailVO>> importSocialHeFeiDiy(InputStream inputStream, String random, String type);

	/**
	 * 批量导入公积金
	 * @param inputStream
	 * @return
	 */
	R<List<ErrorDetailVO>> batchImportPaymentFundInfo(InputStream inputStream);

	/**
	 * 导出缴费库
	 * @param response
	 * @param searchVo
	 * @return
	 */
	void listExport(HttpServletResponse response, TPaymentInfoSearchVo searchVo);

	/**
	 * 合并导出缴费库
	 * @param response
	 * @param searchVo
	 * @return
	 */
	void listSumExport(HttpServletResponse response, TPaymentInfoSearchVo searchVo);

	/**
	 * 删除缴费库数据 包括明细
	 * @Author huyc
	 * @Date 2022-07-24
	 * @param id
	 * @return
	 **/
	R<Boolean> removeInFoById(String id);

	/**
	 * 删除缴费库数据 包括明细
	 * @Author huyc
	 * @Date 2022-07-24
	 * @param ids
	 * @return
	 **/
	R<Boolean> removeAllInfoById(String ids);

	/**
	 * 通过ID获取缴费库 及社保、公积金明细
	 * @Author huyc
	 * @Date 2022-07-24
	 * @param id
	 * @return
	 **/
	R<TPaymentInfoVo> getAllInfoById(String id);

	/**
	 * 根据条件批量删除
	 * @Author huyc
	 * @Date 2022-07-29
	 * @param empIdCard         员工身份证
	 * @param socialHouseId     社保户
	 * @param fundHouseId       公积金户
	 * @param socialCreateMonth 生成月份
	 * @param socialPayMonth    缴纳月份
	 * @return
	 **/
	R<Boolean> removeBatchByInfo(String empIdCard, String socialHouseId, String fundHouseId,
						String socialCreateMonth, String socialPayMonth);

	/**
	 * 薪资获取缴费库
	 * @Author hgw
	 * @Date 2022-8-10 18:06:13
	 **/
	TPaymentVo selectTPaymentBySalaryVo(TPaymentBySalaryVo tPaymentBySalaryVo);

	// 以下4个方法，薪资变更缴费库预估库结算状态专用
	int updatePaymentSocialStatusToSettle(List<String> idList);
	int updatePaymentSocialStatusToNoSettle(List<String> idList);
	int updatePaymentFundStatusToSettle(List<String> idList);
	int updatePaymentFundStatusToNoSettle(List<String> idList);

	void updatePaymentSocialAndFound(UpdateSocialFoundVo list);

	void createPaymentSocialInfo();
	void createPaymentFundInfo();

	void createPaymentInfoIncome();
	void createPaymentFundIncome();

	void signPaymentNoIncomeFlag();

	TPaymentVo getPaymentSocialAndFound(TPaymentInfo info);

	R<Boolean> pushPaymentSocialFundInfo(TPaymentInfoSearchVo searchVo);

	/**
	 * 批量标识可以推送的数据
	 * @Author huyc
	 * @Date 2022-11-16 10:06:13
	 **/
	R<Boolean> batchUpdatePaymentInfo(TPaymentInfoSearchVo searchVo);

	/**
	 * @param changeDeptVo
	 * @Description: 费用划转-ekp同步hro
	 * @Author: hgw
	 * @Date: 2022/11/16 10:38
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> changeDeptByEkp(ChangeDeptVo changeDeptVo);

	Boolean updateSocialSettleStatus(List<EkpSocialViewVo> viewVo);

	// hgw2023-1-6 10:42:06:以下：B端相关接口：
	/**
	 * hgwB端相关接口-按年查询指定人的缴费库数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param year
	 * @param empId
	 * @return
	 **/
	List<PaymentBusinessPageVo> getPaymentByYearAndEmpId(String year, String empId);
	/**
	 * hgwB端相关接口-按年月查询指定人的缴费库数据：年月格式 yyyyMM
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param month
	 * @param empId
	 * @return
	 **/
	PaymentBusinessPageVo getPaymentByMonthAndEmpId(String month, String empId);

	/**
	 * hgwB端相关接口-B端社保公积金列表查询
	 * @Author fxj
	 * @Date 2020-08-28
	 * @param page
	 * @param socialAndFundBusinessPageVo
	 * @param settleDomainIds
	 * @return
	 **/
	List<SocialAndFundBusinessPageVo> getSocialAndFundBusinessPage(Page<SocialAndFundBusinessPageVo> page, SocialAndFundBusinessPageVo socialAndFundBusinessPageVo, List<String> settleDomainIds);
	/**
	 * hgwB端相关接口-按月查询对应权限的缴费库数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param paymentBusinessPageVo
	 * @param settleDomainIds
	 * @param type
	 * @return
	 **/
	IPage<PaymentBusinessPageVo> getPaymentByMonthAndAuth(Page<PaymentBusinessPageVo> page,PaymentBusinessPageVo paymentBusinessPageVo, List<String> settleDomainIds, String type);
	/**
	 * hgwB端相关接口-按年月查询指定结算主体或权限内的缴费库数据统计
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param month
	 * @param settleDomainId
	 * @return
	 **/
	PaymentBusinessPageDetail getPaymentBusinessPageDetailByMonthAndAuth(String month, String settleDomainId, List<String> settleDomainIds);
	/**
	 * hgwB端相关接口-查询派减的社保和公积金的分页数据
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param page
	 * @param month
	 * @param settleDomainId
	 * @return
	 **/
	IPage<SocialAndFundReduceBusinessVo> getSocialAndFundReduceInfo(Page<SocialAndFundReduceBusinessVo> page, String month, String settleDomainId, List<String> settleDomainIds);
	// hgw2023-1-6 10:42:06:以上：B端相关接口

}
