package com.yifu.cloud.plus.v1.yifu.social.service.impl;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysArea;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainListVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ResultConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.ErrorCodes;
import com.yifu.cloud.plus.v1.yifu.common.core.redis.RedisDistributedLock;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.ErrorDetailVO;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.ArchivesDaprUtil;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.InsuranceDaprUtil;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.UpmsDaprUtils;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpSocialViewVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentBySalaryVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TPaymentVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.UpdateSocialFoundVo;
import com.yifu.cloud.plus.v1.yifu.social.concurrent.threadpool.YFSocialImportThreadPoolExecutor;
import com.yifu.cloud.plus.v1.yifu.social.constants.PaymentConstants;
import com.yifu.cloud.plus.v1.yifu.social.constants.SocialConstants;
import com.yifu.cloud.plus.v1.yifu.social.entity.*;
import com.yifu.cloud.plus.v1.yifu.social.mapper.*;
import com.yifu.cloud.plus.v1.yifu.social.service.TEkpChangeDeptLogService;
import com.yifu.cloud.plus.v1.yifu.social.service.TIncomeService;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentInfoService;
import com.yifu.cloud.plus.v1.yifu.social.util.DoJointSocialTask;
import com.yifu.cloud.plus.v1.yifu.social.util.ServiceUtil;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-22 17:01:22
 */
@Log4j2
@Service
public class TPaymentInfoServiceImpl extends ServiceImpl<TPaymentInfoMapper, TPaymentInfo> implements TPaymentInfoService {

	@Autowired
	private RedisUtil redisUtil;

	@Autowired
	private YFSocialImportThreadPoolExecutor yfSocialImportThreadPoolExecutor;

	@Autowired
	private UpmsDaprUtils upmsDaprUtils;

	@Autowired
	private TSocialFundInfoMapper socialFundInfoMapper;

	@Autowired
	private TSocialInfoMapper socialInfoMapper;

	@Autowired
	private TProvidentFundMapper providentFundMapper;

	private final int partSize = 30;

	@Autowired
	private SysHouseHoldInfoMapper sysHouseHoldInfoMapper;

	@Autowired
	private TIncomeDetailMapper detailMapper;

	@Autowired
	private TIncomeService incomeService;

	@Autowired
	private ArchivesDaprUtil archivesDaprUtil;

	@Autowired
	private TForecastLibraryMapper tForecastLibraryMapper;

	@Autowired
	private InsuranceDaprUtil insuranceDaprUtil;

	@Autowired
	private TEkpChangeDeptLogService tEkpChangeDeptLogService;

	@Autowired
	private DoJointSocialTask doJointSocialTask;

	@Autowired
	private TPaymentSocialPushMapper pushMapper;

	/**
	 * 缴费库简单分页查询
	 *
	 * @param tPaymentInfo 缴费库
	 * @return
	 */
	@Override
	public IPage<TPaymentInfo> getTPaymentInfoPage(Page<TPaymentInfo> page, TPaymentInfoSearchVo tPaymentInfo) {
		return baseMapper.getTPaymentInfoPage(page, tPaymentInfo);
	}

	/**
	 * 缴费库批量导出
	 *
	 * @param searchVo 缴费库
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, TPaymentInfoSearchVo searchVo) {
		String fileName = "缴费库批量导出" + DateUtil.getThisTime() + CommonConstants.XLSX;
		//获取要导出的列表
		List<TPaymentInfoBatchVo> list = new ArrayList<>();
		Integer count = baseMapper.selectCountTPaymentInfo(searchVo);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, "UTF-8"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TPaymentInfoBatchVo.class).includeColumnFieldNames(searchVo.getExportFields()).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				WriteSheet writeSheet;
				for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.getTPaymentInfoNoPage(searchVo);
					if (Common.isNotNull(list)) {
						writeSheet = EasyExcel.writerSheet("缴费库" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcel.writerSheet("缴费库" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			if (excelWriter!= null){
				excelWriter.finish();
			}
		} catch (Exception e) {
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
			} catch (IOException e) {
				log.error("执行异常", e);
			}
		}
	}

	/**
	 * 缴费库批量导出
	 *
	 * @param searchVo 缴费库
	 * @return
	 */
	@Override
	public void listSumExport(HttpServletResponse response, TPaymentInfoSearchVo searchVo) {
		String fileName = PaymentConstants.EXPORT + DateUtil.getThisTime() + CommonConstants.XLSX;
		//获取要导出的列表
		List<TPaymentInfoExportVo> list = new ArrayList<>();
		Integer count = baseMapper.selectCountSumPaymentInfo(searchVo);
		ServletOutputStream out = null;
		try {
			out = response.getOutputStream();
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, "UTF-8"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, TPaymentInfoExportVo.class).includeColumnFieldNames(searchVo.getExportFields()).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				WriteSheet writeSheet;
				for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.getTPaymentInfoSumNoPage(searchVo);
					if (Common.isNotNull(list)) {
						writeSheet = EasyExcel.writerSheet(PaymentConstants.EXPORT + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcel.writerSheet(PaymentConstants.EXPORT + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			out.flush();
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		} finally {
			try {
				if (null != out) {
					out.close();
				}
			} catch (IOException e) {
				log.error("执行异常", e);
			}
		}
	}

	@Override
	public R<Boolean> removeInFoById(String id) {
		YifuUser user = SecurityUtils.getUser();
		String key = CacheConstants.PAYMENT_SOCIAL_PUSH + CommonConstants.DOWN_LINE_STRING +user.getId() ;
		if (Common.isNotNull(redisUtil.get(key))) {
			return R.failed("用户正在推送实缴数据中禁止删除！");
		}
		TPaymentInfo paymentInfo = baseMapper.selectById(id);
		if (!user.getId().equals(paymentInfo.getCreateBy()) && !CommonConstants.ONE_STRING.equals(user.getId())) {
			return R.failed("非本人创建的数据禁止删除！");
		}

		if (CommonConstants.ZERO_STRING.equals(paymentInfo.getPushStatus())) {
			return R.failed("已推送至结算平台禁止删除！");
		}

		if (CommonConstants.ONE_STRING.equals(paymentInfo.getSalaryFundFlag()) ||
				CommonConstants.ONE_STRING.equals(paymentInfo.getSalarySocialFlag())) {
			return R.failed("该数据已与薪资结算，禁止删除");
		}
		baseMapper.deleteById(id);
		return R.ok();
	}

	@Override
	public R<Boolean> removeAllInfoById(String ids) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(ids)) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}

		String key = CacheConstants.PAYMENT_SOCIAL_PUSH + CommonConstants.DOWN_LINE_STRING +user.getId() ;
		if (Common.isNotNull(redisUtil.get(key))) {
			return R.failed("用户正在推送实缴数据中禁止删除！");
		}
		List<String> idList = Common.initStrToList(ids, CommonConstants.COMMA_STRING);
		TPaymentInfo paymentInfo;

		if (idList != null) {
			for (String id : idList) {
				paymentInfo = baseMapper.selectById(id);
				if ((!user.getId().equals(paymentInfo.getCreateBy()) &&
						!CommonConstants.ONE_STRING.equals(user.getId())) ||
						CommonConstants.ZERO_STRING.equals(paymentInfo.getPushStatus())) {
					return R.failed("存在不符合条件的数据(已推送至结算平台或非本人创建),禁止删除！");
				}
				if (CommonConstants.ONE_STRING.equals(paymentInfo.getSalaryFundFlag()) ||
						CommonConstants.ONE_STRING.equals(paymentInfo.getSalarySocialFlag())) {
					return R.failed("存在不符合条件的数据(已与薪资结算)，禁止删除");
				}
				baseMapper.deleteById(id);
			}
		}
		return R.ok();
	}
	/**
	 * 通过ID获取缴费库 及社保、公积金明细
	 *
	 * @param id
	 * @Author huyc
	 * @Date 2022-07-24
	 **/
	@Override
	public R<TPaymentInfoVo> getAllInfoById(String id) {
		TPaymentInfoVo vo = baseMapper.getAllInfoById(id);
		return R.ok(vo, "查询成功！");
	}

	@Override
	public R<Boolean> removeBatchByInfo(String empIdCard, String socialHouseId, String fundHouseId,
										String socialCreateMonth, String socialPayMonth) {
		YifuUser user = SecurityUtils.getUser();

		String key = CacheConstants.PAYMENT_SOCIAL_PUSH + CommonConstants.DOWN_LINE_STRING +user.getId() ;
		if (Common.isNotNull(redisUtil.get(key))) {
			return R.failed("用户正在推送实缴数据中禁止删除！");
		}
		LambdaQueryWrapper<TPaymentInfo> wrapper = buildQueryWrapper(empIdCard, socialHouseId, fundHouseId,
				socialCreateMonth, socialPayMonth);

		List<TPaymentInfo> list;
		boolean delFlag = false;
		if (CommonConstants.ONE_STRING.equals(user.getId())) {
			list = baseMapper.selectList(wrapper.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
					.eq(TPaymentInfo::getSalarySocialFlag, CommonConstants.ZERO_STRING)
					.eq(TPaymentInfo::getSalaryFundFlag, CommonConstants.ZERO_STRING)
			);
		} else {
			list = baseMapper.selectList(wrapper.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
					.eq(TPaymentInfo::getSalarySocialFlag, CommonConstants.ZERO_STRING)
					.eq(TPaymentInfo::getSalaryFundFlag, CommonConstants.ZERO_STRING)
					.eq(TPaymentInfo::getCreateBy, user.getId())
			);
			long count = baseMapper.selectCount(wrapper.and(obj->obj.eq(TPaymentInfo::getPushStatus,CommonConstants.ZERO_STRING)
					.or().eq(TPaymentInfo::getSalarySocialFlag, CommonConstants.ONE_STRING)
					.or().eq(TPaymentInfo::getSalaryFundFlag, CommonConstants.ONE_STRING)
					.or().ne(TPaymentInfo::getCreateBy, user.getId())
					)
			);
			if (count > 0) {
				delFlag = true;
			}
		}
		if (Common.isNotNull(list)) {
			baseMapper.deleteBatchIds(list);
		} else if (!delFlag) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		if (delFlag) {
			return R.ok(null, "存在不符合条件的数据(已推送至结算平台或非本人创建),禁止删除！");
		}
		return R.ok(null, "批量删除成功");
	}

	private LambdaQueryWrapper buildQueryWrapper(String empIdCard, String socialHouseId, String fundHouseId,
												 String socialCreateMonth, String socialPayMonth) {
		LambdaQueryWrapper<TPaymentInfo> wrapper = Wrappers.lambdaQuery();
		if (Common.isNotNull(empIdCard)) {
			wrapper.eq(TPaymentInfo::getEmpIdcard, empIdCard);
		}
		if (Common.isNotNull(socialHouseId)) {
			SysHouseHoldInfo info = sysHouseHoldInfoMapper.selectById(socialHouseId);
			if (Common.isNotNull(info)) {
				wrapper.eq(TPaymentInfo::getSocialHousehold, info.getName());
			}
		}
		if (Common.isNotNull(fundHouseId)) {
			SysHouseHoldInfo infoFund = sysHouseHoldInfoMapper.selectById(fundHouseId);
			if (Common.isNotNull(infoFund)) {
				wrapper.eq(TPaymentInfo::getProvidentHousehold, infoFund.getName());
			}
		}
		if (Common.isNotNull(socialCreateMonth)) {
			wrapper.and(wrapper2 -> wrapper2.eq(TPaymentInfo::getSocialCreateMonth, socialCreateMonth)
					.or(wrapper1 -> wrapper1.eq(TPaymentInfo::getProvidentCreateMonth, socialCreateMonth)
					));
		}
		if (Common.isNotNull(socialPayMonth)) {
			wrapper.and(wrapper2 -> wrapper2.eq(TPaymentInfo::getSocialPayMonth, socialPayMonth)
					.or(wrapper1 -> wrapper1.eq(TPaymentInfo::getProvidentPayMonth, socialPayMonth)
					));
		}
		return wrapper;
	}

	@Override
	public R<List<ErrorDetailVO>> importSocialDiy(InputStream inputStream) {
		YifuUser user = SecurityUtils.getUser();
		String sumNumKey = user.getId() + CommonConstants.DOWN_LINE_STRING + "sum_key";
		if (Common.isNotNull(redisUtil.get(sumNumKey))) {
			redisUtil.remove(sumNumKey);
		}
		String importSuccessKey = user.getId() + CommonConstants.DOWN_LINE_STRING + CommonConstants.PAYMENT_SOCIAL_WAIT_EXPORT;
		if (Common.isNotNull(redisUtil.get(importSuccessKey))) {
			redisUtil.remove(importSuccessKey);
		}
		ConcurrentHashMap<String, ErrorDetailVO> errorMessageMap = new ConcurrentHashMap<>();
		//养老
		ConcurrentHashMap<String, BigDecimal> pensionMoneyMap = new ConcurrentHashMap<>();
		//大病救助金
		ConcurrentHashMap<String, BigDecimal> bigMoneyMap = new ConcurrentHashMap<>();
		//失业
		ConcurrentHashMap<String, BigDecimal> unEmpMoneyMap = new ConcurrentHashMap<>();
		//生育
		ConcurrentHashMap<String, BigDecimal> birMoneyMap = new ConcurrentHashMap<>();
		//工伤
		ConcurrentHashMap<String, BigDecimal> injuryMoneyMap = new ConcurrentHashMap<>();
		//医保
		ConcurrentHashMap<String, BigDecimal> medicalMoneyMap = new ConcurrentHashMap<>();
		//补缴利息
		ConcurrentHashMap<String, BigDecimal> accrualMoneyMap = new ConcurrentHashMap<>();
		//获取所有项目信息
		Map<String, TSettleDomainSelectVo> domainMap = this.getSelectVoMap();
		ExcelUtil<TPaymentInfoVo> util1 = new ExcelUtil<>(TPaymentInfoVo.class);
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, TPaymentInfoVo.class, new ReadListener<TPaymentInfoVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				//所有行数
				Integer rowNumber;
				/**
				 *临时存储
				 */
				private List<TPaymentInfoVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(TPaymentInfoVo data, AnalysisContext context) {
					ReadRowHolder readRowHolder = context.readRowHolder();
					// 获取总行数（含表头）
					rowNumber = context.readSheetHolder().getApproximateTotalRowNumber();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(errorMessage.getLineNum(), errorMessage.getMessage()));
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					importTPaymentSocialInfo(cachedDataList, sumNumKey, importSuccessKey, errorMessageMap, user,
							rowNumber, pensionMoneyMap, bigMoneyMap, unEmpMoneyMap, birMoneyMap, injuryMoneyMap,
							medicalMoneyMap, accrualMoneyMap ,domainMap);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		domainMap.clear();
		pensionMoneyMap.clear();
		bigMoneyMap.clear();
		unEmpMoneyMap.clear();
		birMoneyMap.clear();
		injuryMoneyMap.clear();
		medicalMoneyMap.clear();
		accrualMoneyMap.clear();
		List<ErrorDetailVO> errorMessageList = new ArrayList<>(errorMessageMap.values());
		errorMessageMap.clear();
		return this.judgeAllMessage(errorMessageList);
	}

	/**
	 * @param errorMessageList
	 * @Description: 判断所有返回数据，是否全部为正确的
	 * @Author: hgw
	 * @Date: 2022/11/24 18:03
	 * @return: void
	 **/
	private R<List<ErrorDetailVO>> judgeAllMessage(List<ErrorDetailVO> errorMessageList) {
		if (!errorMessageList.isEmpty()) {
			boolean isAllTrue = true;
			for (ErrorDetailVO d : errorMessageList) {
				try {
					if (Common.isEmpty(d) || (Common.isEmpty(d.getResult()) || 0 == d.getResult())) {
						isAllTrue = false;
						break;
					}
				} catch (Exception e) {
					log.error("缴费库导入异常：" + e);
				}
			}
			if (isAllTrue) {
				errorMessageList.clear();
				return R.ok();
			} else {
				return R.ok(errorMessageList);
			}
		}
		return R.ok();
	}

	private void importTPaymentSocialInfo(List<TPaymentInfoVo> list, String sumNumKey, String importSuccessKey,
										  ConcurrentHashMap<String, ErrorDetailVO> errorMessageMap,
										  YifuUser user, Integer rowNumber,
										  ConcurrentHashMap<String, BigDecimal> pensionMoneyMap,
										  ConcurrentHashMap<String, BigDecimal> bigMoneyMap,
										  ConcurrentHashMap<String, BigDecimal> unEmpMoneyMap,
										  ConcurrentHashMap<String, BigDecimal> birMoneyMap,
										  ConcurrentHashMap<String, BigDecimal> injuryMoneyMap,
										  ConcurrentHashMap<String, BigDecimal> medicalMoneyMap,
										  ConcurrentHashMap<String, BigDecimal> accrualMoneyMap,
										  Map<String,TSettleDomainSelectVo> domainMap) {
		HashMap<String, String> areaMap = new HashMap<>();
		HashMap<String, String> areaMap2 = new HashMap<>();
		R<AreaVo> areaListR = upmsDaprUtils.getAreaListR();
		if (Common.isNotNull(areaListR)) {
			AreaVo areaList = areaListR.getData();
			if (null != areaList && !areaList.getSysAreaList().isEmpty()) {
				for (SysArea area : areaList.getSysAreaList()) {
					areaMap.put(Integer.toString(area.getId()), area.getAreaName());
					areaMap2.put(area.getAreaName() + CommonConstants.DOWN_LINE_STRING + (
							null == area.getParentId() ? "null" : (0 == area.getParentId() ? "null" : Integer.toString(
									area.getParentId()))), Integer.toString(area.getId()));
				}
			}
		}

		// 判断是否有相同的用户在导入社保费用 存在提示稍后重试
		String key = user.getId() + CommonConstants.DOWN_LINE_STRING + CommonConstants.PAYMENT_SOCIAL_IMPORT;
		if (redisUtil.exists(key)) {
			errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(-1, "当前用户数据导入中，请稍后重试！"));
			redisUtil.remove(key);
		} else {
			redisUtil.set(key, user.getId(), 360L);

			// 导入前做队列空闲判断，防止队列不足出现数据丢失的场景
			if (CollUtil.isNotEmpty(list)) {
				int taskSize = list.size() / partSize + CommonConstants.ONE_INT;
				int residualCapacity = yfSocialImportThreadPoolExecutor.getResidualCapacity();
				if (taskSize > residualCapacity) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(-1, MsgUtils.getMessage(ErrorCodes.SOCIALINFO_LIST_NUM_LARGE)));
				} else {
					// -----------------------------生成paymentInfoMap本段开始--------------------------------
					//已存在的档案数据
					List<String> monthList = Common.listObjectToStrList(list, ExcelAttributeConstants.SOCIAL_PAY_MONTH).stream().distinct().collect(Collectors.toList());
					//已存在社保缴费库数据  非删除状态
					List<TPaymentInfo> paymentInfos = baseMapper.selectListForPaymentImport(monthList, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD));
					//养老
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap = new ConcurrentHashMap<>();
					//大病救助金
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap = new ConcurrentHashMap<>();
					//失业
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap = new ConcurrentHashMap<>();
					//生育
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoBirMap = new ConcurrentHashMap<>();
					//工伤
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap = new ConcurrentHashMap<>();
					//医保
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap = new ConcurrentHashMap<>();
					//补缴利息
					ConcurrentHashMap<String, TPaymentInfo> paymentInfoaccrualMap = new ConcurrentHashMap<>();
					if (Common.isNotNull(paymentInfos)) {
						for (TPaymentInfo info : paymentInfos) {
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitPensionMoney()),
									BigDecimalUtils.isNullToZero(info.getPersonalPensionMoney())).compareTo(BigDecimal.ZERO) != 0) {
								if (null != paymentInfoPensionMap.get(info.getSocialPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ SocialConstants.YL)) {
									info.setYlSameFlg("1");
								}
								paymentInfoPensionMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.YL
										, info);
							}
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getCompanyAccrual()),
									BigDecimalUtils.isNullToZero(info.getPersonalAccrual())).compareTo(BigDecimal.ZERO) != 0) {
								if (null != paymentInfoaccrualMap.get(info.getSocialPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ SocialConstants.BJ)) {
									info.setBjSameFlg("1");
								}
								paymentInfoaccrualMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.BJ
										, info);
							}
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getPersonalBigmailmentMoney()),
									BigDecimalUtils.isNullToZero(info.getUnitBigmailmentMoney())).compareTo(BigDecimal.ZERO) != 0) {
								if (null != paymentInfoBigMap.get(info.getSocialPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ SocialConstants.DB)) {
									info.setDbSameFlg("1");
								}
								paymentInfoBigMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.DB
										, info);
							}
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitUnemploymentMoney()),
									BigDecimalUtils.isNullToZero(info.getPersonalUnemploymentMoney())).compareTo(BigDecimal.ZERO) != 0) {
								if (null != paymentInfoUnEmpMap.get(info.getSocialPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ SocialConstants.SY)) {
									info.setSySameFlg("1");
								}
								paymentInfoUnEmpMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.SY
										, info);
							}
							if (BigDecimalUtils.isNullToZero(info.getUnitBirthMoney()).compareTo(BigDecimal.ZERO) != 0) {
								if (null != paymentInfoBirMap.get(info.getSocialPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ SocialConstants.BIR)) {
									info.setBrSameFlg("1");
								}
								paymentInfoBirMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.BIR
										, info);
							}
							if (BigDecimalUtils.isNullToZero(info.getUnitInjuryMoney()).compareTo(BigDecimal.ZERO) != 0) {
								if (null != paymentInfoInjuryMap.get(info.getSocialPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ SocialConstants.GS)) {
									info.setGsSameFlg("1");
								}
								paymentInfoInjuryMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.GS
										, info);
							}
							if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitMedicalMoney()),
									BigDecimalUtils.isNullToZero(info.getPersonalMedicalMoney())).compareTo(BigDecimal.ZERO) != 0) {
								if (null != paymentInfoMedicalMap.get(info.getSocialPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getSocialCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ SocialConstants.YB)) {
									info.setYbSameFlg("1");
								}
								paymentInfoMedicalMap.put(info.getSocialPayAddr()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getEmpIdcard()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialPayMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ info.getSocialCreateMonth()
												+ CommonConstants.DOWN_LINE_STRING
												+ SocialConstants.YB
										, info);
							}
						}
					}
					// -----------------------------生成paymentInfoMap本段结束--------------------------------

					// -----------------------------线程池处理list，批量保存社保信息开始--------------------------------
					List<CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>>> completableFutureList = new ArrayList<>();

					// 创建一个数值格式化对象
					NumberFormat numberFormat = NumberFormat.getInstance();
					// 设置精确到小数点后2位
					numberFormat.setMaximumFractionDigits(2);
					String maerialRatio = "";
					Integer bfInt = (Integer) redisUtil.get(sumNumKey);
					if (Common.isNotNull(bfInt)) {
						if (rowNumber > bfInt + 1) {
							maerialRatio = numberFormat.format(((float) bfInt / (float) rowNumber) * 100);
							bfInt = bfInt + 100;
							redisUtil.set(sumNumKey, bfInt, 360L);
						} else {
							maerialRatio = "100";
						}
					} else {
						if (rowNumber >= 100) {
							maerialRatio = numberFormat.format(((float) 100 / (float) rowNumber) * 100);
							bfInt = 100;
							redisUtil.set(sumNumKey, bfInt, 360L);
						} else {
							maerialRatio = "100";
						}
					}
					redisUtil.set(importSuccessKey, maerialRatio, 360L);

					try {
						// 1.list.size()不足100时直接执行
						if (list.size() < 100) {
							CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>> listCompletableFuture = CompletableFuture.supplyAsync(() ->
									executeImportSocialList(user, list, areaMap, areaMap2,domainMap,
											paymentInfoPensionMap, paymentInfoBigMap, paymentInfoBirMap,
											paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
											errorMessageMap, pensionMoneyMap, bigMoneyMap, unEmpMoneyMap, birMoneyMap,
											injuryMoneyMap, medicalMoneyMap, accrualMoneyMap, paymentInfoaccrualMap
									), yfSocialImportThreadPoolExecutor);
							completableFutureList.add(listCompletableFuture);
						} else {
							int j = 25;
							for (int i = 0; i < 100; i = i + 25) {
								// 单个线程每次执行25条
								final List<TPaymentInfoVo> finalList = list.subList(i,i+j);
								CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>> listCompletableFuture = CompletableFuture.supplyAsync(() ->
										executeImportSocialList(user, finalList, areaMap, areaMap2,domainMap,
												paymentInfoPensionMap, paymentInfoBigMap, paymentInfoBirMap,
												paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
												errorMessageMap, pensionMoneyMap, bigMoneyMap, unEmpMoneyMap, birMoneyMap,
												injuryMoneyMap, medicalMoneyMap, accrualMoneyMap, paymentInfoaccrualMap
										), yfSocialImportThreadPoolExecutor);
								completableFutureList.add(listCompletableFuture);
							}
						}
						// 阻塞当前线程，等待所有的线程执行完毕
						boolean computeFlag;
						do {
							computeFlag = false;
							for (CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>> listCompletableFuture : completableFutureList) {
								if (!listCompletableFuture.isDone()) {
									computeFlag = true;
								}
							}
						} while (computeFlag);

					} catch (Exception e) {
						log.error("社保缴费库数据批量导入异常：" + e);
						redisUtil.remove(key);
					}
				}
			}
			redisUtil.remove(key);
		}
	}

	/**
	 * 转换缴纳地址为省市县ID
	 **/
	private TPaymentInfoVo initAddress(String[] areaArray, HashMap<String, String> areaMap2, TPaymentInfoVo s) {
		if (null == areaArray || null == areaMap2 || null == s) {
			return s;
		}
		String temp;
		if (areaArray.length >= CommonConstants.TWO_INT) {
			temp = areaMap2.get(areaArray[0] + CommonConstants.DOWN_LINE_STRING + "null");
			if (Common.isNotNull(temp)) {
				s.setSocialProvince(temp);
			}
			temp = areaMap2.get(areaArray[1] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialProvince()
					? "null" : s.getSocialProvince()));
			if (Common.isNotNull(temp)) {
				s.setSocialCity(temp);
			}
			if (areaArray.length >= CommonConstants.THREE_INT) {
				temp = areaMap2.get(areaArray[2] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialCity()
						? "null" : s.getSocialCity()));
				if (Common.isNotNull(temp)) {
					s.setSocialTown(temp);
				}
			}
		}
		return s;
	}

	/**
	 * @param user
	 * @param list
	 * @param areaMap
	 * @param areaMap2
	 * @param paymentInfoPensionMap
	 * @description:
	 * @author: huyc
	 * @date: 2022/7/25
	 * @return:
	 */
	private ConcurrentHashMap<String, ErrorDetailVO> executeImportSocialList(YifuUser user,
														List<TPaymentInfoVo> list,
														HashMap<String, String> areaMap,
														HashMap<String, String> areaMap2,
														Map<String,TSettleDomainSelectVo> domainMap,
														ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap,
														ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap,
														ConcurrentHashMap<String, TPaymentInfo> paymentInfoBirMap,
														ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap,
														ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap,
														ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap,
														ConcurrentHashMap<String, ErrorDetailVO> errorMessageMap,
														ConcurrentHashMap<String, BigDecimal> pensionMoneyMap,
														ConcurrentHashMap<String, BigDecimal> bigMoneyMap,
														ConcurrentHashMap<String, BigDecimal> unEmpMoneyMap,
														ConcurrentHashMap<String, BigDecimal> birMoneyMap,
														ConcurrentHashMap<String, BigDecimal> injuryMoneyMap,
														ConcurrentHashMap<String, BigDecimal> medicalMoneyMap,
														ConcurrentHashMap<String, BigDecimal> accrualMoneyMap,
														ConcurrentHashMap<String, TPaymentInfo> paymentInfoaccrualMap) {
		if (Common.isNotNull(list)) {
			TPaymentInfo paymentInfo;
			TSocialFundInfo socialInfo;
			TSocialInfo tSocialInfo = null;
			String temp;
			List<TSocialInfo> socialist;
			TSettleDomain domain;

			List<TSocialFundInfo> socialInfoList = socialFundInfoMapper.selectList(Wrappers.<TSocialFundInfo>query().lambda()
					.in(TSocialFundInfo::getEmpIdcard, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD)));

			//已存在的社保数据
			HashMap<String, TSocialFundInfo> socialMap = new HashMap<>();
			if (Common.isNotNull(socialInfoList)) {
				for (TSocialFundInfo tSocialInfo1 : socialInfoList) {
					socialMap.put(tSocialInfo1.getEmpIdcard()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialProvince()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialCity()
							+ CommonConstants.DOWN_LINE_STRING + (null == tSocialInfo1.getSocialTown()
							? "null" : tSocialInfo1.getSocialTown()), tSocialInfo1);
				}
			}

			String[] areaArray;
			String exitMoney;
			String errorInfo;
			for (TPaymentInfoVo infoVo : list) {
				if (Common.isNotNull(infoVo.getEmpIdcard())) {
					infoVo.setEmpIdcard(infoVo.getEmpIdcard().replace("x", "X"));
				}
				//导入校验
				if (!Common.isNotNull(infoVo.getSocialPayMonth())) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), "社保缴纳月份不可为空！"));
					continue;
				}
				if (!Common.isNotNull(infoVo.getSocialCreateMonth())) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), "社保生成月份不可为空！"));
					continue;
				}
				if (!Common.isNotNull(infoVo.getSocialPayAddr())) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), "社保缴纳地不可为空！"));
					continue;
				}
				//无对应员工的社保数据
				//采用客服导入的地址
				areaArray = infoVo.getSocialPayAddr().split(CommonConstants.CENTER_SPLIT_LINE_STRING);
				infoVo = initAddress(areaArray, areaMap2, infoVo);
				socialInfo = socialMap.get(infoVo.getEmpIdcard()
						+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialProvince()
						+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialCity()
						+ CommonConstants.DOWN_LINE_STRING + (null == infoVo.getSocialTown()
						? "null" : infoVo.getSocialTown()));
				//对身份证与人员姓名的对应关系进行校验
				if (socialInfo != null && !socialInfo.getEmpName().equals(infoVo.getEmpName())) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), "姓名与身份证信息不一致，请核实后再次尝试！"));
					continue;
				}
				if (socialInfo != null && socialInfo.getSocialStartDate() == null) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpIdcard(), SocialConstants.ERROR_TEMPLATE + "的社保起缴日期为空！"));
					continue;
				}

				if (null == socialInfo) {
					boolean isTrueAdder = false;
					socialist = socialInfoMapper.selectList(Wrappers.<TSocialInfo>query().lambda()
							.eq(TSocialInfo::getEmpIdcard, infoVo.getEmpIdcard())
							.eq(TSocialInfo::getSocialProvince, infoVo.getSocialProvince())
							.eq(TSocialInfo::getSocialCity, infoVo.getSocialCity()));
					if (!socialist.isEmpty()) {
						for (TSocialInfo socialInfo1 : socialist) {
							if ((Common.isEmpty(infoVo.getSocialTown()) || (Common.isNotNull(infoVo.getSocialTown()) &&
									infoVo.getSocialTown().equals(socialInfo1.getSocialTown()))) &&
									DateUtil.dateToString(socialInfo1.getSocialStartDate(), "yyyyMM").compareTo(infoVo.getSocialPayMonth()) <= 0 &&
									(Common.isEmpty(socialInfo1.getSocialReduceDate()) || (Common.isNotNull(socialInfo1.getSocialReduceDate()) &&
											DateUtil.dateToString(socialInfo1.getSocialReduceDate(), "yyyyMM").compareTo(infoVo.getSocialPayMonth()) >= 0))) {
								isTrueAdder = true;
								tSocialInfo = socialInfo1;
								break;
							}
						}
					}
					if (!isTrueAdder) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), "无对应员工" +
								infoVo.getEmpIdcard() + "的社保数据(请查验社保缴纳地)"));
						continue;
					}
				} else {
					tSocialInfo = null;
				}

				//导入模板判重 养老
				exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.YL));
				if (pensionMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
						BigDecimalUtils.isNullToZero(infoVo.getUnitPensionMoney()), BigDecimalUtils.isNullToZero(
								infoVo.getPersonalPensionMoney())), pensionMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的养老缴费数据"));
					continue;
				} else {
					pensionMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitPensionMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalPensionMoney())));
				}
				//补缴
				exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.BJ));
				if (accrualMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
						BigDecimalUtils.isNullToZero(infoVo.getPersonalAccrual()), BigDecimalUtils.isNullToZero(
								infoVo.getCompanyAccrual())), accrualMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的补缴缴费数据"));
					continue;
				} else {
					accrualMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getPersonalAccrual()),
							BigDecimalUtils.isNullToZero(infoVo.getCompanyAccrual())));
				}
				//医疗
				exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.YB));
				if (medicalMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
						BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()), BigDecimalUtils.isNullToZero(
								infoVo.getPersonalMedicalMoney())), medicalMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的医保缴费数据"));
					continue;
				} else {
					medicalMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())));
				}
				//失业
				exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.SY));
				if (unEmpMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
						BigDecimalUtils.isNullToZero(infoVo.getUnitUnemploymentMoney()), BigDecimalUtils.isNullToZero(
								infoVo.getPersonalUnemploymentMoney())), unEmpMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的失业缴费数据"));
					continue;
				} else {
					unEmpMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitUnemploymentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalUnemploymentMoney())));
				}
				//工伤
				exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.GS));
				if (injuryMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.isNullToZero(infoVo.getUnitInjuryMoney()),
						injuryMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的工伤缴费数据"));
					continue;
				} else {
					injuryMoneyMap.put(exitMoney, BigDecimalUtils.isNullToZero(infoVo.getUnitInjuryMoney()));
				}
				//生育
				exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.BIR));
				if (birMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.isNullToZero(infoVo.getUnitBirthMoney()),
						birMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的生育缴费数据"));
					continue;
				} else {
					birMoneyMap.put(exitMoney, BigDecimalUtils.isNullToZero(infoVo.getUnitBirthMoney()));
				}
				//医疗救助金
				exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.DB));
				if (bigMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
								BigDecimalUtils.isNullToZero(infoVo.getUnitBigmailmentMoney()),
								BigDecimalUtils.isNullToZero(infoVo.getPersonalBigmailmentMoney())),
						bigMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的医疗救助金缴费数据"));
					continue;
				} else {
					bigMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitBigmailmentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalBigmailmentMoney())));
				}

				//判断是否存在养老缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitPensionMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getPersonalPensionMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoPensionMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.YL);

					//存在社保缴费数据
					if (null != paymentInfo && ((null != paymentInfo.getYlSameFlg() && CommonConstants.ONE_STRING.equals(paymentInfo.getYlSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitPensionMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalPensionMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitPensionMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalPensionMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的养老缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在补缴缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getPersonalAccrual()),
						BigDecimalUtils.isNullToZero(infoVo.getCompanyAccrual())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoaccrualMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.BJ);

					//存在社保缴费数据
					if (null != paymentInfo && ((null != paymentInfo.getBjSameFlg() && CommonConstants.ONE_STRING.equals(paymentInfo.getBjSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getPersonalAccrual()),
							BigDecimalUtils.isNullToZero(infoVo.getCompanyAccrual())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalAccrual()),
							BigDecimalUtils.isNullToZero(paymentInfo.getCompanyAccrual()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的补缴缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在失业缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitUnemploymentMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getPersonalUnemploymentMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoUnEmpMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.SY);
					//存在社保缴费数据
					if (null != paymentInfo && ((null != paymentInfo.getSySameFlg() && CommonConstants.ONE_STRING.equals(paymentInfo.getSySameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitUnemploymentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalUnemploymentMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitUnemploymentMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalUnemploymentMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的失业缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医保缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoMedicalMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.YB);

					//存在社保缴费数据
					if (null != paymentInfo && ((null != paymentInfo.getYbSameFlg() && CommonConstants.ONE_STRING.equals(paymentInfo.getYbSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalMedicalMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医保缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医疗救助金缴费数据
				if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getPersonalBigmailmentMoney()),
						BigDecimalUtils.isNullToZero(infoVo.getUnitBigmailmentMoney())).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoBigMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.DB);
					//存在社保缴费数据
					if (null != paymentInfo && ((null != paymentInfo.getDbSameFlg() && CommonConstants.ONE_STRING.equals(paymentInfo.getDbSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitBigmailmentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalBigmailmentMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitBigmailmentMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getPersonalBigmailmentMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医疗救助金缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在工伤缴费数据
				if (BigDecimalUtils.isNullToZero(infoVo.getUnitInjuryMoney()).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoInjuryMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.GS);
					//存在社保缴费数据
					if (null != paymentInfo && ((null != paymentInfo.getGsSameFlg() && CommonConstants.ONE_STRING.equals(paymentInfo.getGsSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.isNullToZero(infoVo.getUnitInjuryMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitInjuryMoney())).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的单位工伤缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在生育缴费数据
				if (BigDecimalUtils.isNullToZero(infoVo.getUnitBirthMoney()).compareTo(BigDecimal.ZERO) != 0) {
					paymentInfo = paymentInfoBirMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.BIR);
					//存在社保缴费数据
					if (null != paymentInfo && ((null != paymentInfo.getBrSameFlg() && CommonConstants.ONE_STRING.equals(paymentInfo.getBrSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.isNullToZero(infoVo.getUnitBirthMoney()),
							BigDecimalUtils.isNullToZero(paymentInfo.getUnitBirthMoney())).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的单位生育缴费数据,请勿重复导入！"));
						continue;
					}
				}
				if (Common.isEmpty(tSocialInfo)) {
					tSocialInfo = socialInfoMapper.selectOne(Wrappers.<TSocialInfo>query().lambda()
							.eq(TSocialInfo::getEmpIdcard, infoVo.getEmpIdcard()).groupBy(TSocialInfo::getCreateTime)
							.last(CommonConstants.LAST_ONE_SQL));
				}

				paymentInfo = new TPaymentInfo();
				paymentInfo.setLockStatus(CommonConstants.ZERO_STRING);
				if (Common.isNotNull(socialInfo)) {
					paymentInfo.setEmpId(socialInfo.getEmpId());
					paymentInfo.setEmpIdcard(socialInfo.getEmpIdcard());
					paymentInfo.setEmpName(socialInfo.getEmpName());
					//获取项目信息
					if (Common.isNotNull(domainMap)) {
						domain = domainMap.get(socialInfo.getSettleDomainCode());
					} else {
						domain = null;
					}
					if (Common.isEmpty(domain)) {
						errorMessageMap.put(UUID.randomUUID().toString(), new ErrorDetailVO(infoVo.getRowIndex(),
								CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(),
								paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.NOT_EXIT_SETTLEiNFO));
						continue;
					}
					paymentInfo.setBpoFlag(domain.getBpoFlag());
					paymentInfo.setSettleDomainId(socialInfo.getSettleDomain());
					paymentInfo.setSettleDomainName(socialInfo.getSettleDomainName());
					paymentInfo.setSettleDomainCode(socialInfo.getSettleDomainCode());
					paymentInfo.setUnitId(socialInfo.getUnitId());
					paymentInfo.setUnitName(socialInfo.getUnitName());
					paymentInfo.setSocialProvince(socialInfo.getSocialProvince());
					paymentInfo.setSocialCity(socialInfo.getSocialCity());
					paymentInfo.setSocialTown(socialInfo.getSocialTown());
					paymentInfo.setSocialHousehold(socialInfo.getSocialHouseholdName());
				} else if (Common.isNotNull(tSocialInfo)) {
					paymentInfo.setEmpId(tSocialInfo.getEmpId());
					paymentInfo.setEmpIdcard(tSocialInfo.getEmpIdcard());
					paymentInfo.setEmpName(tSocialInfo.getEmpName());
					//获取项目信息
					if (Common.isNotNull(domainMap)) {
						domain = domainMap.get(tSocialInfo.getSettleDomainCode());
					} else {
						domain = null;
					}
					if (Common.isEmpty(domain)) {
						errorMessageMap.put(UUID.randomUUID().toString(), new ErrorDetailVO(infoVo.getRowIndex(),
								CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(),
								paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.NOT_EXIT_SETTLEiNFO));
						continue;
					}
					paymentInfo.setSettleDomainName(domain.getDepartName());
					paymentInfo.setUnitId(domain.getCustomerId());
					paymentInfo.setUnitName(domain.getCustomerName());
					paymentInfo.setBpoFlag(domain.getBpoFlag());
					paymentInfo.setSettleDomainId(tSocialInfo.getSettleDomain());
					paymentInfo.setSettleDomainCode(tSocialInfo.getSettleDomainCode());
					paymentInfo.setSocialProvince(tSocialInfo.getSocialProvince());
					paymentInfo.setSocialCity(tSocialInfo.getSocialCity());
					paymentInfo.setSocialTown(tSocialInfo.getSocialTown());
					paymentInfo.setSocialHousehold(tSocialInfo.getSocialHouseholdName());
				}
				// 项目信息校验
				errorInfo = settleInfoCheck(paymentInfo);
				if (!Common.isEmpty(errorInfo)){
					errorMessageMap.put(UUID.randomUUID().toString(), new ErrorDetailVO(infoVo.getRowIndex(),
							CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(),
							paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_PRI
							+ errorInfo + SocialConstants.ERROR_END));
					continue;
				}
				if (Common.isNotNull(tSocialInfo)) {
					paymentInfo.setInauguralTeam(tSocialInfo.getInauguralTeam());
					paymentInfo.setEmpNo(tSocialInfo.getEmpNo());
				}
				paymentInfo.setSocialPayMonth(infoVo.getSocialPayMonth());

				if (null != paymentInfo.getSocialProvince()) {
					temp = areaMap.get(paymentInfo.getSocialProvince());
					if (Common.isNotNull(temp)) {
						paymentInfo.setSocialPayAddr(temp);
					}
				}
				if (null != paymentInfo.getSocialCity()) {
					temp = areaMap.get(paymentInfo.getSocialCity());
					if (Common.isNotNull(temp)) {
						paymentInfo.setSocialPayAddr(paymentInfo.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				}
				if (null != paymentInfo.getSocialTown()) {
					temp = areaMap.get(paymentInfo.getSocialTown());
					if (Common.isNotNull(temp)) {
						paymentInfo.setSocialPayAddr(paymentInfo.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				}
				paymentInfo.setSocialSecurityNo(infoVo.getSocialSecurityNo());
				paymentInfo.setSocialCreateMonth(infoVo.getSocialCreateMonth());
				paymentInfo.setUnitPensionMoney(infoVo.getUnitPensionMoney());
				paymentInfo.setUnitMedicalMoney(infoVo.getUnitMedicalMoney());
				paymentInfo.setUnitBirthMoney(null == infoVo.getUnitBirthMoney() ? BigDecimal.ZERO : infoVo.getUnitBirthMoney());
				paymentInfo.setUnitBigmailmentMoney(infoVo.getUnitBigmailmentMoney());
				paymentInfo.setUnitInjuryMoney(infoVo.getUnitInjuryMoney());
				paymentInfo.setUnitUnemploymentMoney(infoVo.getUnitUnemploymentMoney());
				paymentInfo.setPersonalBigmailmentMoney(infoVo.getPersonalBigmailmentMoney());
				paymentInfo.setPersonalUnemploymentMoney(infoVo.getPersonalUnemploymentMoney());
				paymentInfo.setPersonalPensionMoney(infoVo.getPersonalPensionMoney());
				paymentInfo.setPersonalMedicalMoney(null == infoVo.getPersonalMedicalMoney()
						? BigDecimal.ZERO : infoVo.getPersonalMedicalMoney());
				paymentInfo.setUnitPensionSet(infoVo.getUnitPensionSet());
				paymentInfo.setUnitPensionPer(infoVo.getUnitPensionPer());
				paymentInfo.setUnitMedicalSet(infoVo.getUnitMedicalSet());
				paymentInfo.setUnitMedicalPer(infoVo.getUnitMedicalPer());
				paymentInfo.setUnitBirthSet(null == infoVo.getUnitBirthSet() ? BigDecimal.ZERO : infoVo.getUnitBirthSet());
				paymentInfo.setUnitBirthPer(infoVo.getUnitBirthPer());
				paymentInfo.setUnitInjurySet(infoVo.getUnitInjurySet());
				paymentInfo.setUnitInjuryPer(infoVo.getUnitInjuryPer());
				paymentInfo.setUnitUnemploymentSet(infoVo.getUnitUnemploymentSet());
				paymentInfo.setUnitUnemploymentPer(infoVo.getUnitUnemploymentPer());
				paymentInfo.setUnitBigailmentPer(infoVo.getUnitBigailmentPer());
				paymentInfo.setPersonalPensionPer(infoVo.getPersonalPensionPer());
				paymentInfo.setPersonalMedicalPer(infoVo.getPersonalMedicalPer());
				paymentInfo.setPersonalUnemploymentPer(infoVo.getPersonalUnemploymentPer());
				paymentInfo.setPersonalBigailmentPer(infoVo.getPersonalBigailmentPer());
				paymentInfo.setCompanyAccrual(infoVo.getCompanyAccrual());
				paymentInfo.setPersonalAccrual(infoVo.getPersonalAccrual());
				paymentInfo.setUnitSocialSum(BigDecimalUtils.safeAdd(paymentInfo.getUnitPensionMoney()
						, paymentInfo.getUnitMedicalMoney(), paymentInfo.getUnitBirthMoney()
						, paymentInfo.getUnitInjuryMoney()
						, paymentInfo.getUnitUnemploymentMoney()
						, paymentInfo.getUnitBigmailmentMoney()
						, paymentInfo.getCompanyAccrual()));
				paymentInfo.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(paymentInfo.getPersonalBigmailmentMoney()
						, paymentInfo.getPersonalPensionMoney()
						, paymentInfo.getPersonalMedicalMoney()
						, paymentInfo.getPersonalUnemploymentMoney()
						, paymentInfo.getPersonalAccrual()));
				paymentInfo.setSocialSum(BigDecimalUtils.safeAdd(
						paymentInfo.getUnitSocialSum(), paymentInfo.getSocialSecurityPersonalSum()));
				paymentInfo.setSumAll(paymentInfo.getSocialSum());
				paymentInfo.setCreateBy(user.getId());
				paymentInfo.setCreateName(user.getNickname());
				paymentInfo.setSocialId(UUID.randomUUID().toString());
				int res = baseMapper.insert(paymentInfo);
				if (res < 0) {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.SAVE_FAILED));
				} else {
					errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ONE_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.SAVE_SUCCESS));
				}
			}
		}
		return errorMessageMap;
	}

	@Override
	public R<List<ErrorDetailVO>> importSocialHeFeiDiy(InputStream inputStream, String random, String type) {
		YifuUser user = SecurityUtils.getUser();
		String sumNumKey = user.getId() + CommonConstants.DOWN_LINE_STRING + "sum_key";
		if (Common.isNotNull(redisUtil.get(sumNumKey))) {
			redisUtil.remove(sumNumKey);
		}
		String importSuccessKey = user.getId() + CommonConstants.DOWN_LINE_STRING + CommonConstants.PAYMENT_SOCIAL_WAIT_EXPORT;
		if (Common.isNotNull(redisUtil.get(importSuccessKey))) {
			redisUtil.remove(importSuccessKey);
		}
		//养老插入的集合
		ConcurrentHashMap<String,TPaymentInfo> batchYlInsertList = new ConcurrentHashMap<>();
		//工伤插入的集合
		ConcurrentHashMap<String,TPaymentInfo> batchGsInsertList = new ConcurrentHashMap<>();
		//失业插入的集合
		ConcurrentHashMap<String,TPaymentInfo> batchSyInsertList = new ConcurrentHashMap<>();
		//医疗插入的集合
		ConcurrentHashMap<String,TPaymentInfo> batchYyInsertList = new ConcurrentHashMap<>();
		//获取所有项目信息
		Map<String, TSettleDomainSelectVo> domainMap = this.getSelectVoMap();
		//地区数据
		HashMap<String, String> areaMap = new HashMap<>();
		HashMap<String, String> areaMap2 = new HashMap<>();
		R<AreaVo> areaListR = upmsDaprUtils.getAreaListR();
		if (Common.isNotNull(areaListR)) {
			AreaVo areaList = areaListR.getData();
			if (null != areaList && !areaList.getSysAreaList().isEmpty()) {
				for (SysArea area : areaList.getSysAreaList()) {
					areaMap.put(Integer.toString(area.getId()), area.getAreaName());
					areaMap2.put(area.getAreaName() + CommonConstants.DOWN_LINE_STRING + (
							null == area.getParentId() ? "null" : (0 == area.getParentId() ? "null" : Integer.toString(
									area.getParentId()))), Integer.toString(area.getId()));
				}
			}
		}
		ConcurrentHashMap<String, ErrorDetailVO> errorMessageMap = new ConcurrentHashMap<>();
		ExcelUtil<TPaymentHeFeiVo> util1 = new ExcelUtil<>(TPaymentHeFeiVo.class);
		ConcurrentHashMap<String, BigDecimal> pensionMoneyMap = new ConcurrentHashMap<>();
		ConcurrentHashMap<String, BigDecimal> bigMoneyMap = new ConcurrentHashMap<>();
		ConcurrentHashMap<String, BigDecimal> unEmpMoneyMap = new ConcurrentHashMap<>();
		ConcurrentHashMap<String, BigDecimal> injuryMoneyMap = new ConcurrentHashMap<>();
		ConcurrentHashMap<String, BigDecimal> medicalMoneyMap = new ConcurrentHashMap<>();
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, TPaymentHeFeiVo.class, new ReadListener<TPaymentHeFeiVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				Integer rowNumber;
				/**
				 *临时存储
				 */
				private List<TPaymentHeFeiVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(TPaymentHeFeiVo data, AnalysisContext context) {
					// 获取总行数（含表头）
					rowNumber = context.readSheetHolder().getApproximateTotalRowNumber();

					ReadRowHolder readRowHolder = context.readRowHolder();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessageMap.put(UUID.randomUUID().toString(),new ErrorDetailVO(errorMessage.getLineNum(), errorMessage.getMessage()));
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					importTPaymentSocialHeFei(cachedDataList, errorMessageMap, type, rowNumber, pensionMoneyMap,
							bigMoneyMap, unEmpMoneyMap, injuryMoneyMap, medicalMoneyMap, sumNumKey, importSuccessKey
							, batchGsInsertList,batchSyInsertList,batchYlInsertList,batchYyInsertList, areaMap,
							areaMap2,domainMap);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
			pensionMoneyMap.clear();
			bigMoneyMap.clear();
			unEmpMoneyMap.clear();
			injuryMoneyMap.clear();
			medicalMoneyMap.clear();
			areaMap.clear();
			areaMap2.clear();
			domainMap.clear();
			//批量插入数据
			//养老
			List<TPaymentInfo> list;
			if (!batchYlInsertList.isEmpty()) {
				list = new ArrayList<>(batchYlInsertList.values());
				this.saveBatch(list);
				batchYlInsertList.clear();
				list.clear();
			}
			//工伤
			if (!batchGsInsertList.isEmpty()) {
				list = new ArrayList<>(batchGsInsertList.values());
				this.saveBatch(list);
				batchGsInsertList.clear();
				list.clear();
			}
			//医疗
			if (!batchYyInsertList.isEmpty()) {
				list = new ArrayList<>(batchYyInsertList.values());
				this.saveBatch(list);
				batchYyInsertList.clear();
				list.clear();
			}
			//失业
			if (!batchSyInsertList.isEmpty()) {
				list = new ArrayList<>(batchSyInsertList.values());
				this.saveBatch(list);
				batchSyInsertList.clear();
				list.clear();
			}
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		List<ErrorDetailVO> errorMessageList = new ArrayList<>(errorMessageMap.values());
		errorMessageMap.clear();
		return this.judgeAllMessage(errorMessageList);
	}

	@Override
	public R<List<ErrorDetailVO>> batchImportPaymentFundInfo(InputStream inputStream) {
		List<ErrorDetailVO> errorMessageList = new ArrayList<>();
		ExcelUtil<TPaymentInfoVo> util1 = new ExcelUtil<>(TPaymentInfoVo.class);
		//批量插入的集合
		List<TPaymentInfo> batchInsertList = new ArrayList<>();
		//获取所有项目信息
		Map<String, TSettleDomainSelectVo> domainMap = this.getSelectVoMap();
		//地区数据
		HashMap<String, String> areaMap = new HashMap<>();
		HashMap<String, String> areaMap2 = new HashMap<>();
		R<AreaVo> areaListR = upmsDaprUtils.getAreaListR();
		if (Common.isNotNull(areaListR)) {
			AreaVo areaList = areaListR.getData();
			if (null != areaList && !areaList.getSysAreaList().isEmpty()) {
				for (SysArea area : areaList.getSysAreaList()) {
					areaMap.put(Integer.toString(area.getId()), area.getAreaName());
					areaMap2.put(area.getAreaName() + CommonConstants.DOWN_LINE_STRING + (
							null == area.getParentId() ? "null" : (0 == area.getParentId() ? "null" : Integer.toString(
									area.getParentId()))), Integer.toString(area.getId()));
				}
			}
		}
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, TPaymentInfoVo.class, new ReadListener<TPaymentInfoVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				/**
				 *临时存储
				 */
				private List<TPaymentInfoVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(TPaymentInfoVo data, AnalysisContext context) {
					ReadRowHolder readRowHolder = context.readRowHolder();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessageList.add(new ErrorDetailVO(errorMessage.getLineNum(), errorMessage.getMessage()));
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					batchSavePaymentFundInfo(cachedDataList, errorMessageList, batchInsertList, areaMap, areaMap2,domainMap);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
			//批量插入数据
			if (!batchInsertList.isEmpty()) {
				this.saveBatch(batchInsertList);
				batchInsertList.clear();
			}
			areaMap.clear();
			areaMap2.clear();
			domainMap.clear();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		return this.judgeAllMessage(errorMessageList);
	}

	private void batchSavePaymentFundInfo(List<TPaymentInfoVo> list, List<ErrorDetailVO> errorMessageList,
										  List<TPaymentInfo> batchInsertList,HashMap<String, String> areaMap,
										  HashMap<String, String> areaMap2,Map<String,TSettleDomainSelectVo> domainMap) {
		try {
			if (Common.isNotNull(list)) {
				TPaymentInfo paymentInfo = null;
				TSocialFundInfo fund;
				String temp;
				List<TProvidentFund> fundlist;
				TProvidentFund tProvidentFund = null;

				//获取身份证列表
				List<String> idcards = list.stream().map(TPaymentInfoVo::getEmpIdcard).collect(Collectors.toList());
				//已存在档案数据
				//已存在派增公积金数据
				List<TSocialFundInfo> fundList = socialFundInfoMapper.selectList(Wrappers.<TSocialFundInfo>query().lambda()
						.in(TSocialFundInfo::getEmpIdcard, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD)));
				HashMap<String, Object> fundMap = fundList.stream().collect(HashMap::new, (m, v) ->
						m.put(v.getEmpIdcard(), v), HashMap::putAll);

				List<String> monthList = list.stream().map(TPaymentInfoVo::getProvidentPayMonth).collect(Collectors.toList());

				//已存在社保缴费库数据  非删除状态
				List<TPaymentInfo> paymentInfos = baseMapper.selectListForPaymentImport1(monthList, idcards);
				//公积金唯一性检验条件：身份证编码+公积金缴纳月份
				HashMap<String, Object> paymentInfoMap = new HashMap<>();
				if (Common.isNotNull(paymentInfos)) {
					for (TPaymentInfo info : paymentInfos) {
						paymentInfoMap.put(info.getProvidentPayAddr()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getEmpIdcard()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getProvidentPayMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ info.getProvidentCreateMonth()
										+ CommonConstants.DOWN_LINE_STRING
										+ BigDecimalUtils.safeAdd(info.getProvidentSum()).doubleValue()
								, info);
					}
				}
				String[] areaArray;
				TSettleDomain domain;
				String errorInfo;
				for (TPaymentInfoVo infoVo : list) {
					if (Common.isNotNull(infoVo.getEmpIdcard())) {
						infoVo.setEmpIdcard(infoVo.getEmpIdcard().replace("x", "X"));
					}
					//检查数据规范性
					if (!Common.isNotNull(infoVo.getEmpIdcard())) {
						errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.DOWN_LINE_STRING + "员工身份证不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentPayMonth())) {
						errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.DOWN_LINE_STRING + "公积金缴纳月份不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentCreateMonth())) {
						errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.DOWN_LINE_STRING + "公积金生成月份不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentPercent())) {
						errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.DOWN_LINE_STRING + "公积金单边比例不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getUnitProvidentSet())) {
						errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.DOWN_LINE_STRING + "公积金单边基数不可为空！"));
						continue;
					}
					if (!Common.isNotNull(infoVo.getProvidentPayAddr())) {
						errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), CommonConstants.DOWN_LINE_STRING + "公积金缴纳地不可为空！"));
						continue;
					}
					if (fundMap.size() > CommonConstants.ZERO_INT) {
						fund = (TSocialFundInfo) fundMap.get(infoVo.getEmpIdcard());
						//对身份证与人员姓名的对应关系进行校验
						if (null != fund && !fund.getEmpName().equals(infoVo.getEmpName())) {
							errorMessageList.add
									(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), fund.getSocialHousehold(), fund.getProvidentHousehold(), infoVo.getEmpName(), "姓名与身份证信息不一致，请核实后再次尝试！"));
							continue;
						}
						areaArray = infoVo.getProvidentPayAddr().split(CommonConstants.CENTER_SPLIT_LINE_STRING);
						fund = checkAddress(areaArray, areaMap, fund, areaMap2, infoVo);
						//无对应员工公积金数据
						if (null == fund) {
							boolean isTrueAdder = false;
							fundlist = providentFundMapper.selectList(Wrappers.<TProvidentFund>query().lambda()
									.eq(TProvidentFund::getEmpIdcard, infoVo.getEmpIdcard())
									.eq(TProvidentFund::getFundProvince, infoVo.getSocialProvince())
									.eq(TProvidentFund::getFundCity, infoVo.getSocialCity()));
							if (!fundlist.isEmpty()) {
								for (TProvidentFund providentFund : fundlist) {
									if ((Common.isEmpty(infoVo.getFundTown()) || (Common.isNotNull(infoVo.getFundTown()) &&
											infoVo.getFundTown().equals(providentFund.getFundTown()))) &&
											DateUtil.dateToString(providentFund.getProvidentStart(), "yyyyMM").compareTo(infoVo.getProvidentPayMonth()) <= 0 &&
											(Common.isEmpty(providentFund.getFundReduceDate()) || (Common.isNotNull(providentFund.getFundReduceDate()) &&
													DateUtil.dateToString(providentFund.getFundReduceDate(), "yyyyMM").compareTo(infoVo.getProvidentPayMonth()) >= 0))) {
										isTrueAdder = true;
										tProvidentFund = providentFund;
										break;
									}
								}
							}
							if (!isTrueAdder) {
								errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(), infoVo.getEmpName(), "无对应员工" + infoVo.getEmpName() +
										CommonConstants.DOWN_LINE_STRING + infoVo.getEmpIdcard()
										+ "的公积金数据(请查验公积金缴纳地)！"));
								continue;
							}
						} else {
							tProvidentFund = null;
						}
						//计算公积金合计，个人金额和单位金额一致
						infoVo.setProvidentSum(BigDecimalUtils.safeAdd(infoVo.getUnitProvidentSum(), infoVo.getUnitProvidentSum()));
						// 判重
						if (paymentInfoMap.size() > CommonConstants.ZERO_INT) {
							paymentInfo = (TPaymentInfo) paymentInfoMap.get(infoVo.getProvidentPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ infoVo.getEmpIdcard().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ infoVo.getProvidentPayMonth().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ infoVo.getProvidentCreateMonth().trim()
									+ CommonConstants.DOWN_LINE_STRING
									+ Math.round(BigDecimalUtils.safeAdd(infoVo.getProvidentSum()).doubleValue() * 100) / 100.0);
						}
						//存在公积金缴费数据
						if (null != paymentInfo && BigDecimalUtils.isNullToZero(paymentInfo.getProvidentSum()).compareTo(BigDecimal.ZERO) != 0) {

							//允许覆盖，但已核准表或工资结算或已锁定不允许覆盖
							errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(), paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" +
									infoVo.getEmpName() + CommonConstants.DOWN_LINE_STRING + infoVo.getEmpIdcard()
									+ "公积金缴费数据，禁止覆盖！"));
							continue;
						}

						if (Common.isEmpty(tProvidentFund)) {
							tProvidentFund = providentFundMapper.selectOne(Wrappers.<TProvidentFund>query().lambda()
									.eq(TProvidentFund::getEmpIdcard, infoVo.getEmpIdcard()).groupBy(TProvidentFund::getCreateTime)
									.last(CommonConstants.LAST_ONE_SQL));
						}
						paymentInfo = new TPaymentInfo();
						paymentInfo.setLockStatus(CommonConstants.ZERO_STRING);
						if (Common.isNotNull(fund)) {
							paymentInfo.setEmpId(fund.getEmpId());
							paymentInfo.setEmpIdcard(fund.getEmpIdcard());
							paymentInfo.setEmpName(fund.getEmpName());
							if (Common.isNotNull(domainMap)) {
								domain = domainMap.get(fund.getSettleDomainCodeFund());
							} else {
								domain = null;
							}
							if (Common.isEmpty(domain)) {
								errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(),
										CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(),
										paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.NOT_EXIT_SETTLEiNFO));
								continue;
							}
							paymentInfo.setBpoFlag(domain.getBpoFlag());
							paymentInfo.setSettleDomainId(fund.getSettleDomainFund());
							paymentInfo.setSettleDomainName(fund.getSettleDomainNameFund());
							paymentInfo.setSettleDomainCode(fund.getSettleDomainCodeFund());
							paymentInfo.setUnitId(fund.getUnitIdFund());
							paymentInfo.setUnitName(fund.getUnitNameFund());
							paymentInfo.setFundProvince(fund.getFundProvince());
							paymentInfo.setFundCity(fund.getFundCity());
							paymentInfo.setFundTown(Common.isNotNull(fund.getFundTown()) ? fund.getFundTown(): "");
							paymentInfo.setProvidentHousehold(fund.getProvidentHouseholdName());
						} else if (Common.isNotNull(tProvidentFund)) {
							paymentInfo.setEmpId(tProvidentFund.getEmpId());
							paymentInfo.setEmpIdcard(tProvidentFund.getEmpIdcard());
							paymentInfo.setEmpName(tProvidentFund.getEmpName());
							//获取项目信息
							if (Common.isNotNull(domainMap)) {
								domain = domainMap.get(tProvidentFund.getSettleDomainCode());
							} else {
								domain = null;
							}
							if (Common.isEmpty(domain)) {
								errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(),
										CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(),
										paymentInfo.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.NOT_EXIT_SETTLEiNFO));
								continue;
							}
							paymentInfo.setSettleDomainName(domain.getDepartName());
							paymentInfo.setUnitId(domain.getCustomerId());
							paymentInfo.setUnitName(domain.getCustomerName());
							paymentInfo.setBpoFlag(domain.getBpoFlag());
							paymentInfo.setSettleDomainId(tProvidentFund.getSettleDomain());
							paymentInfo.setSettleDomainCode(tProvidentFund.getSettleDomainCode());
							paymentInfo.setFundProvince(tProvidentFund.getFundProvince());
							paymentInfo.setFundCity(tProvidentFund.getFundCity());
							paymentInfo.setFundTown(Common.isNotNull(tProvidentFund.getFundTown()) ? tProvidentFund.getFundTown(): "");
							paymentInfo.setProvidentHousehold(tProvidentFund.getProvidentHouseholdName());
						}
						// 项目信息校验
						errorInfo = settleInfoCheck(paymentInfo);
						if (!Common.isEmpty(errorInfo)){
							errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(),
									CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), paymentInfo.getSocialHousehold(),
									paymentInfo.getProvidentHousehold(), infoVo.getEmpName(),
									SocialConstants.ERROR_PRI + errorInfo + SocialConstants.ERROR_END));
							continue;
						}
						if (Common.isNotNull(tProvidentFund)) {
							paymentInfo.setInauguralTeam(Common.isNotNull(tProvidentFund.getInauguralTeam()) ? tProvidentFund.getInauguralTeam(): "");
							paymentInfo.setEmpNo(Common.isNotNull(tProvidentFund.getEmpNo()) ? tProvidentFund.getEmpNo(): "");
						} else {
							paymentInfo.setInauguralTeam("");
							paymentInfo.setEmpNo("");
						}
						paymentInfo.setProvidentPayMonth(infoVo.getProvidentPayMonth());
						if (null != paymentInfo.getFundProvince()) {
							temp = areaMap.get(paymentInfo.getFundProvince());
							if (Common.isNotNull(temp)) {
								paymentInfo.setProvidentPayAddr(temp);
							}
						}
						if (null != paymentInfo.getFundCity()) {
							temp = areaMap.get(paymentInfo.getFundCity());
							if (Common.isNotNull(temp)) {
								paymentInfo.setProvidentPayAddr(paymentInfo.getProvidentPayAddr()
										+ CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
							}
						}
						if (null != paymentInfo.getFundTown()) {
							temp = areaMap.get(paymentInfo.getFundTown());
							if (Common.isNotNull(temp)) {
								paymentInfo.setProvidentPayAddr(paymentInfo.getProvidentPayAddr()
										+ CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
							}
						} else {
							paymentInfo.setFundTown("");
						}

						paymentInfo.setProvidentCreateMonth(infoVo.getProvidentCreateMonth());
						paymentInfo.setUnitProvidentSet(null == infoVo.getUnitProvidentSet() ? BigDecimal.ZERO : infoVo.getUnitProvidentSet());
						paymentInfo.setPersonalProidentSet(null == infoVo.getUnitProvidentSet() ? BigDecimal.ZERO : infoVo.getUnitProvidentSet());
						paymentInfo.setProvidentPercent(null == infoVo.getProvidentPercent() ? BigDecimal.ZERO : infoVo.getProvidentPercent());
						paymentInfo.setProvidentNo(infoVo.getProvidentNo());
						paymentInfo.setPersonalProvidentSum(null == infoVo.getUnitProvidentSum() ? BigDecimal.ZERO : infoVo.getUnitProvidentSum());
						paymentInfo.setUnitProvidentSum(null == infoVo.getUnitProvidentSum() ? BigDecimal.ZERO : infoVo.getUnitProvidentSum());
						paymentInfo.setProvidentSum(null == infoVo.getProvidentSum() ? BigDecimal.ZERO : infoVo.getProvidentSum());
						paymentInfo.setSumAll(paymentInfo.getProvidentSum());
						paymentInfo.setFundId(UUID.randomUUID().toString());
						batchInsertList.add(paymentInfo);
						errorMessageList.add(new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ONE_INT,
								infoVo.getEmpIdcard(), infoVo.getSocialHousehold(), infoVo.getProvidentHousehold(),
								infoVo.getEmpName(), CommonConstants.SAVE_SUCCESS,CommonConstants.GREEN));
						paymentInfoMap.put(paymentInfo.getProvidentPayAddr()
								+ CommonConstants.DOWN_LINE_STRING
								+ paymentInfo.getEmpIdcard().trim()
								+ CommonConstants.DOWN_LINE_STRING
								+ paymentInfo.getProvidentPayMonth().trim()
								+ CommonConstants.DOWN_LINE_STRING
								+ paymentInfo.getProvidentCreateMonth().trim()
								+ CommonConstants.DOWN_LINE_STRING
								+ BigDecimalUtils.safeAdd(paymentInfo.getProvidentSum()).doubleValue(), paymentInfo);
					}
				}
			}
		} catch (Exception e) {
			log.error("数据批量导入异常：" + e);
		}
	}

	private void importTPaymentSocialHeFei(List<TPaymentHeFeiVo> list,
										   ConcurrentHashMap<String, ErrorDetailVO> errorMessageList,
										   String type, Integer rowNumber,
										   ConcurrentHashMap<String, BigDecimal> pensionMoneyMap,
										   ConcurrentHashMap<String, BigDecimal> bigMoneyMap,
										   ConcurrentHashMap<String, BigDecimal> unEmpMoneyMap,
										   ConcurrentHashMap<String, BigDecimal> injuryMoneyMap,
										   ConcurrentHashMap<String, BigDecimal> medicalMoneyMap,
										   String sumNumKey, String importSuccessKey,
										   ConcurrentHashMap<String,TPaymentInfo> batchGsInsertList,
										   ConcurrentHashMap<String,TPaymentInfo> batchSyInsertList,
										   ConcurrentHashMap<String,TPaymentInfo> batchYlInsertList,
										   ConcurrentHashMap<String,TPaymentInfo> batchYyInsertList,
										   HashMap<String, String> areaMap,
										   HashMap<String, String> areaMap2,Map<String,TSettleDomainSelectVo> domainMap) {

		// 将以下代码提取出来，使用paymentInfoMap提升性能，避免list多次循环查询数据库浪费性能
		// 导入前做队列空闲判断，防止队列不足出现数据丢失的场景
		if (CollUtil.isNotEmpty(list)) {
			int taskSize = list.size() / partSize + CommonConstants.ONE_INT;
			int residualCapacity = yfSocialImportThreadPoolExecutor.getResidualCapacity();
			if (taskSize > residualCapacity) {
				errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(-1, MsgUtils.getMessage(ErrorCodes.SOCIALINFO_LIST_NUM_LARGE)));
			} else {

				// -----------------------------生成paymentInfoMap本段开始--------------------------------
				//已存在的档案数据
				List<String> monthList = Common.listObjectToStrList(list, ExcelAttributeConstants.SOCIAL_PAY_MONTH).stream().distinct().collect(Collectors.toList());
				//已存在社保缴费库数据  非删除状态
				List<TPaymentInfo> paymentInfos = baseMapper.selectListForPaymentImport(monthList,
						Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD));
				//养老
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap = new ConcurrentHashMap<>();
				//大病救助金
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap = new ConcurrentHashMap<>();
				//失业
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap = new ConcurrentHashMap<>();
				//工伤
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap = new ConcurrentHashMap<>();
				//医保
				ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap = new ConcurrentHashMap<>();
				if (Common.isNotNull(paymentInfos)) {
					for (TPaymentInfo info : paymentInfos) {

						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitPensionMoney()),
								BigDecimalUtils.isNullToZero(info.getPersonalPensionMoney())).compareTo(BigDecimal.ZERO) != 0) {
							if (null != paymentInfoPensionMap.get(info.getSocialPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getEmpIdcard()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialPayMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialCreateMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ PaymentConstants.PENSION_RISK)) {
								info.setYbSameFlg("1");
							}
							paymentInfoPensionMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.PENSION_RISK
									, info);
						}
						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitUnemploymentMoney()),
								BigDecimalUtils.isNullToZero(info.getPersonalUnemploymentMoney())).compareTo(BigDecimal.ZERO) != 0) {
							if (null != paymentInfoUnEmpMap.get(info.getSocialPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getEmpIdcard()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialPayMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialCreateMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ PaymentConstants.UNEMPLOYEEMENT_RISK)) {
								info.setSySameFlg("1");
							}
							paymentInfoUnEmpMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.UNEMPLOYEEMENT_RISK
									, info);
						}
						if (BigDecimalUtils.isNullToZero(info.getUnitInjuryMoney()).compareTo(BigDecimal.ZERO) != 0) {
							if (null != paymentInfoInjuryMap.get(info.getSocialPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getEmpIdcard()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialPayMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialCreateMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ PaymentConstants.INJURY_RISK)) {
								info.setGsSameFlg("1");
							}
							paymentInfoInjuryMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.INJURY_RISK
									, info);
						}
						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getUnitMedicalMoney()),
								BigDecimalUtils.isNullToZero(info.getPersonalMedicalMoney())).compareTo(BigDecimal.ZERO) != 0) {
							if (null != paymentInfoMedicalMap.get(info.getSocialPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getEmpIdcard()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialPayMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialCreateMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ PaymentConstants.MEDICAL)) {
								info.setYlSameFlg("1");
							}
							paymentInfoMedicalMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ PaymentConstants.MEDICAL
									, info);
						}
						if (BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(info.getPersonalBigmailmentMoney()),
								BigDecimalUtils.isNullToZero(info.getUnitBigmailmentMoney())).compareTo(BigDecimal.ZERO) != 0) {
							if (null != paymentInfoBigMap.get(info.getSocialPayAddr()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getEmpIdcard()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialPayMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ info.getSocialCreateMonth()
									+ CommonConstants.DOWN_LINE_STRING
									+ SocialConstants.DB)) {
								info.setDbSameFlg("1");
							}
							paymentInfoBigMap.put(info.getSocialPayAddr()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getEmpIdcard()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialPayMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ info.getSocialCreateMonth()
											+ CommonConstants.DOWN_LINE_STRING
											+ SocialConstants.DB
									, info);
						}
					}
				}
				// -----------------------------生成paymentInfoMap本段结束--------------------------------

				// -----------------------------线程池处理list，批量保存社保信息开始--------------------------------
				List<CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>>> completableFutureList = new ArrayList<>();

				// 创建一个数值格式化对象
				NumberFormat numberFormat = NumberFormat.getInstance();
				// 设置精确到小数点后2位
				numberFormat.setMaximumFractionDigits(2);
				String maerialRatio = "";
				Integer bfInt = (Integer) redisUtil.get(sumNumKey);
				if (Common.isNotNull(bfInt)) {
					if (rowNumber > bfInt + 1) {
						maerialRatio = numberFormat.format(((float) bfInt / (float) rowNumber) * 100);
						bfInt = bfInt + 100;
						redisUtil.set(sumNumKey, bfInt, 360L);
					} else {
						maerialRatio = "100";
					}
				} else {
					if (rowNumber >= 100) {
						maerialRatio = numberFormat.format(((float) 100 / (float) rowNumber) * 100);
						bfInt = 100;
						redisUtil.set(sumNumKey, bfInt, 360L);
					} else {
						maerialRatio = "100";
					}
				}
				redisUtil.set(importSuccessKey, maerialRatio, 360L);

				try {
					// 1.list.size()不足100时直接执行
					if (list.size() < 100) {
						CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>> listCompletableFuture = CompletableFuture.supplyAsync(()
										-> executeImportSocialListThree(list, areaMap, areaMap2,
										paymentInfoPensionMap, paymentInfoMedicalMap, paymentInfoUnEmpMap, paymentInfoInjuryMap,
										paymentInfoBigMap, type, errorMessageList, pensionMoneyMap, bigMoneyMap,
										unEmpMoneyMap, injuryMoneyMap, medicalMoneyMap,	batchGsInsertList,
										batchSyInsertList, batchYlInsertList, batchYyInsertList,domainMap),
								yfSocialImportThreadPoolExecutor);
						completableFutureList.add(listCompletableFuture);
					} else {
						int j = 25;
						for (int i = 0; i < 100; i = i + 25) {
							// 单个线程每次执行25条
							List<TPaymentHeFeiVo> finalTempList1 = list.subList(i,i+j);
							CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>> listCompletableFuture = CompletableFuture.supplyAsync(()
											-> executeImportSocialListThree(finalTempList1
											, areaMap, areaMap2, paymentInfoPensionMap, paymentInfoMedicalMap,
											paymentInfoUnEmpMap, paymentInfoInjuryMap, paymentInfoBigMap, type,
											errorMessageList, pensionMoneyMap, bigMoneyMap, unEmpMoneyMap,
											injuryMoneyMap, medicalMoneyMap, batchGsInsertList, batchSyInsertList,
											batchYlInsertList, batchYyInsertList, domainMap),
									yfSocialImportThreadPoolExecutor);
							completableFutureList.add(listCompletableFuture);
						}
					}

					// 阻塞当前线程，等待所有的线程执行完毕
					boolean computeFlag;
					do {
						computeFlag = false;
						for (CompletableFuture<ConcurrentHashMap<String, ErrorDetailVO>> listCompletableFuture : completableFutureList) {
							if (!listCompletableFuture.isDone()) {
								computeFlag = true;
							}
						}
					} while (computeFlag);

					paymentInfoBigMap.clear();
					paymentInfoInjuryMap.clear();
					paymentInfoUnEmpMap.clear();
					paymentInfoPensionMap.clear();
					paymentInfoMedicalMap.clear();
				} catch (Exception e) {
					log.error("社保缴费库数据批量导入异常：" + e);
					paymentInfoBigMap.clear();
					paymentInfoInjuryMap.clear();
					paymentInfoUnEmpMap.clear();
					paymentInfoPensionMap.clear();
					paymentInfoMedicalMap.clear();
				}
			}
		}
	}

	private ConcurrentHashMap<String, ErrorDetailVO> executeImportSocialListThree(List<TPaymentHeFeiVo> list,
															 HashMap<String, String> areaMap,
															 HashMap<String, String> areaMap2,
															 ConcurrentHashMap<String, TPaymentInfo> paymentInfoPensionMap,
															 ConcurrentHashMap<String, TPaymentInfo> paymentInfoMedicalMap,
															 ConcurrentHashMap<String, TPaymentInfo> paymentInfoUnEmpMap,
															 ConcurrentHashMap<String, TPaymentInfo> paymentInfoInjuryMap,
															 ConcurrentHashMap<String, TPaymentInfo> paymentInfoBigMap,
															 String type, ConcurrentHashMap<String, ErrorDetailVO> errorMessageList,
															 ConcurrentHashMap<String, BigDecimal> pensionMoneyMap,
															 ConcurrentHashMap<String, BigDecimal> bigMoneyMap,
															 ConcurrentHashMap<String, BigDecimal> unEmpMoneyMap,
															 ConcurrentHashMap<String, BigDecimal> injuryMoneyMap,
															 ConcurrentHashMap<String, BigDecimal> medicalMoneyMap,
															 ConcurrentHashMap<String, TPaymentInfo> batchGsInsertList,
															 ConcurrentHashMap<String, TPaymentInfo> batchSyInsertList,
															 ConcurrentHashMap<String, TPaymentInfo> batchYlInsertList,
															 ConcurrentHashMap<String, TPaymentInfo> batchYyInsertList,
															 Map<String,TSettleDomainSelectVo> domainMap) {
		if (Common.isNotNull(list)) {
			TPaymentInfo payExists;
			TSocialFundInfo socialInfo = null;
			TSocialInfo tSocialInfo = null;
			String temp;
			List<TSocialInfo> socialist;
			TSettleDomain domain;

			List<TSocialFundInfo> socialInfoList = socialFundInfoMapper.selectList(Wrappers.<TSocialFundInfo>query().lambda()
					.in(TSocialFundInfo::getEmpIdcard, Common.listObjectToStrList(list, ExcelAttributeConstants.EMPIDCARD)));

			//已存在的社保数据
			HashMap<String, TSocialFundInfo> socialMap = new HashMap<>();
			if (Common.isNotNull(socialInfoList)) {
				for (TSocialFundInfo tSocialInfo1 : socialInfoList) {
					socialMap.put(tSocialInfo1.getEmpIdcard()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialProvince()
							+ CommonConstants.DOWN_LINE_STRING + tSocialInfo1.getSocialCity()
							+ CommonConstants.DOWN_LINE_STRING + (null == tSocialInfo1.getSocialTown()
							? "null" : tSocialInfo1.getSocialTown()), tSocialInfo1);
				}
			}

			String[] areaArray;
			String exitMoney;
			String errorInfo;
			for (TPaymentHeFeiVo infoVo : list) {
				if (Common.isNotNull(infoVo.getEmpIdcard())) {
					infoVo.setEmpIdcard(infoVo.getEmpIdcard().replace("x", "X"));
				}
				//导入校验
				if (socialThreeCheckBase(errorMessageList, infoVo, type)) {
					continue;
				}
				//无对应员工的社保数据
				if (socialMap.size() > CommonConstants.ZERO_INT) {
					//采用客服导入的地址
					areaArray = infoVo.getSocialPayAddr().split(CommonConstants.CENTER_SPLIT_LINE_STRING);
					infoVo = initAddressThree(areaArray, areaMap2, infoVo);
					if (null == infoVo.getSocialProvince() || null == infoVo.getSocialCity()) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), "社保缴纳地填写错误，请核实后再次尝试！"));
						continue;
					}
					socialInfo = socialMap.get(infoVo.getEmpIdcard()
							+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialProvince()
							+ CommonConstants.DOWN_LINE_STRING + infoVo.getSocialCity()
							+ CommonConstants.DOWN_LINE_STRING + (null == infoVo.getSocialTown() ? "null" : infoVo.getSocialTown()));

					//对身份证与人员姓名的对应关系进行校验
					if (socialInfo != null && !socialInfo.getEmpName().equals(infoVo.getEmpName())) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), "姓名与身份证信息不一致，请核实后再次尝试！"));
						continue;
					}
					if (socialInfo != null && socialInfo.getSocialStartDate() == null) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的社保起缴日期为空！"));
						continue;
					}
				}
				if (null == socialInfo) {
					boolean isTrueAdder = false;
					socialist = socialInfoMapper.selectList(Wrappers.<TSocialInfo>query().lambda()
							.eq(TSocialInfo::getEmpIdcard, infoVo.getEmpIdcard())
							.eq(TSocialInfo::getSocialProvince, infoVo.getSocialProvince().toString())
							.eq(TSocialInfo::getSocialCity, infoVo.getSocialCity().toString()));
					if (!socialist.isEmpty()) {
						for (TSocialInfo socialInfo1 : socialist) {
							if ((Common.isEmpty(infoVo.getSocialTown()) || (Common.isNotNull(infoVo.getSocialTown()) &&
									infoVo.getSocialTown().toString().equals(socialInfo1.getSocialTown()))) &&
									DateUtil.dateToString(socialInfo1.getSocialStartDate(), "yyyyMM").compareTo(infoVo.getSocialPayMonth()) <= 0 &&
									(Common.isEmpty(socialInfo1.getSocialReduceDate()) || (Common.isNotNull(socialInfo1.getSocialReduceDate()) &&
											DateUtil.dateToString(socialInfo1.getSocialReduceDate(), "yyyyMM").compareTo(infoVo.getSocialPayMonth()) >= 0))) {
								isTrueAdder = true;
								tSocialInfo = socialInfo1;
								break;
							}
						}
					}
					if (!isTrueAdder) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), "无对应员工" + infoVo.getEmpIdcard() +
								"的社保数据(请查验社保缴纳地)"));
						continue;
					}
				} else {
					tSocialInfo = null;
				}

				//判断是否存在养老缴费数据
				if (PaymentConstants.PENSION_RISK.equals(infoVo.getRiskType())) {
					//导入模板判重 养老
					exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(PaymentConstants.PENSION_RISK));
					if (pensionMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()), BigDecimalUtils.isNullToZero(
									infoVo.getUnitMoney())), pensionMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "",
								infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的养老缴费数据"));
						continue;
					} else {
						pensionMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
								BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())));
					}

					payExists = paymentInfoPensionMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.PENSION_RISK);
					//存在社保缴费数据
					if (null != payExists && ((null != payExists.getYbSameFlg() && CommonConstants.ONE_STRING.equals(payExists.getYbSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitPensionMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalPensionMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(), payExists.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的养老缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在失业缴费数据
				if (PaymentConstants.UNEMPLOYEEMENT_RISK.equals(infoVo.getRiskType())) {
					//导入模板判重 失业
					exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(PaymentConstants.UNEMPLOYEEMENT_RISK));
					if (unEmpMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitMoney()), BigDecimalUtils.isNullToZero(
									infoVo.getPersonalMoney())), unEmpMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "",
								infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的失业缴费数据"));
						continue;
					} else {
						unEmpMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
								BigDecimalUtils.isNullToZero(infoVo.getUnitMoney()),
								BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney())));
					}

					payExists = paymentInfoUnEmpMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.UNEMPLOYEEMENT_RISK);
					//存在社保缴费数据
					if (null != payExists && ((null != payExists.getSySameFlg() && CommonConstants.ONE_STRING.equals(payExists.getSySameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitUnemploymentMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalUnemploymentMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(), payExists.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的失业缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医保缴费数据
				if (CommonConstants.ONE_STRING.equals(type)) {
					//导入模板判重 医疗
					exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(PaymentConstants.MEDICAL));
					if (medicalMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()), BigDecimalUtils.isNullToZero(
									infoVo.getPersonalMedicalMoney())), medicalMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "",
								infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的医保缴费数据"));
						continue;
					} else {
						medicalMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
								BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
								BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())));
					}

					payExists = paymentInfoMedicalMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.MEDICAL);

					//存在社保缴费数据
					if (null != payExists && ((null != payExists.getYlSameFlg() && CommonConstants.ONE_STRING.equals(payExists.getYlSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalMedicalMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitMedicalMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalMedicalMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(), payExists.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医保缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在工伤缴费数据
				if (PaymentConstants.INJURY_RISK.equals(infoVo.getRiskType())) {
					//导入模板判重 工伤
					exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(PaymentConstants.INJURY_RISK));
					if (injuryMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
									BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
									BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())),
							injuryMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "",
								infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的工伤缴费数据"));
						continue;
					} else {
						injuryMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
								BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
								BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())));
					}

					payExists = paymentInfoInjuryMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ PaymentConstants.INJURY_RISK);

					//存在社保缴费数据
					if (null != payExists && ((null != payExists.getGsSameFlg() && CommonConstants.ONE_STRING.equals(payExists.getGsSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
									BigDecimalUtils.isNullToZero(infoVo.getPersonalMoney()),
									BigDecimalUtils.isNullToZero(infoVo.getUnitMoney())),
							BigDecimalUtils.isNullToZero(payExists.getUnitInjuryMoney())).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(), payExists.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的单位工伤缴费数据,请勿重复导入！"));
						continue;
					}
				}

				//判断是否存在医疗救助金缴费数据
				if (CommonConstants.ONE_STRING.equals(type)) {
					//导入模板判重 医疗救助金
					exitMoney = infoVo.getEmpIdcard().concat(infoVo.getSocialPayMonth().concat(infoVo.getSocialCreateMonth()).concat(SocialConstants.DB));
					if (bigMoneyMap.get(exitMoney) != null && BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
									BigDecimalUtils.isNullToZero(infoVo.getUnitBigailmentMoney()),
									BigDecimalUtils.isNullToZero(infoVo.getPersonalBigailmentMoney())),
							bigMoneyMap.get(exitMoney)).compareTo(BigDecimal.ZERO) > 0) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "",
								infoVo.getEmpName(), SocialConstants.ERROR_TEMPLATE + "的医疗救助金缴费数据"));
						continue;
					} else {
						bigMoneyMap.put(exitMoney, BigDecimalUtils.safeAdd(
								BigDecimalUtils.isNullToZero(infoVo.getUnitBigailmentMoney()),
								BigDecimalUtils.isNullToZero(infoVo.getPersonalBigailmentMoney())));
					}

					payExists = paymentInfoBigMap.get(infoVo.getSocialPayAddr()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getEmpIdcard().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialPayMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ infoVo.getSocialCreateMonth().trim()
							+ CommonConstants.DOWN_LINE_STRING
							+ SocialConstants.DB);

					//存在社保缴费数据
					if (null != payExists && ((null != payExists.getDbSameFlg() && CommonConstants.ONE_STRING.equals(payExists.getDbSameFlg()))
							|| (BigDecimalUtils.safeMultiply(BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(infoVo.getUnitBigailmentMoney()),
							BigDecimalUtils.isNullToZero(infoVo.getPersonalBigailmentMoney())), BigDecimalUtils.safeAdd(
							BigDecimalUtils.isNullToZero(payExists.getUnitBigmailmentMoney()),
							BigDecimalUtils.isNullToZero(payExists.getPersonalBigmailmentMoney()))).compareTo(BigDecimal.ZERO) > 0))) {
						errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(), payExists.getProvidentHousehold(), infoVo.getEmpName(), "已存在对应员工身份证" + infoVo.getEmpIdcard()
								+ "的医疗救助金缴费数据,请勿重复导入！"));
						continue;
					}
				}

				if (Common.isEmpty(tSocialInfo)) {
					tSocialInfo = socialInfoMapper.selectOne(Wrappers.<TSocialInfo>query().lambda()
							.eq(TSocialInfo::getEmpIdcard, infoVo.getEmpIdcard()).groupBy(TSocialInfo::getCreateTime)
							.last(CommonConstants.LAST_ONE_SQL));
				}

				payExists = new TPaymentInfo();
				payExists.setLockStatus(CommonConstants.ZERO_STRING);
				if (Common.isNotNull(socialInfo)) {
					payExists.setEmpId(socialInfo.getEmpId());
					payExists.setEmpIdcard(socialInfo.getEmpIdcard());
					payExists.setEmpName(socialInfo.getEmpName());
					if (Common.isNotNull(domainMap)) {
						domain = domainMap.get(socialInfo.getSettleDomainCode());
					} else {
						domain = null;
					}
					if (Common.isEmpty(domain)) {
						errorMessageList.put(UUID.randomUUID().toString(), new ErrorDetailVO(infoVo.getRowIndex(),
								CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(),
								payExists.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.NOT_EXIT_SETTLEiNFO));
						continue;
					}
					payExists.setBpoFlag(domain.getBpoFlag());
					payExists.setSettleDomainId(socialInfo.getSettleDomain());
					payExists.setSettleDomainCode(Common.isNotNull(socialInfo.getSettleDomainCode()) ? socialInfo.getSettleDomainCode(): "");
					payExists.setUnitId(Common.isNotNull(socialInfo.getUnitId()) ? socialInfo.getUnitId(): "");
					payExists.setSettleDomainName(Common.isNotNull(socialInfo.getSettleDomainName()) ? socialInfo.getSettleDomainName(): "");
					payExists.setUnitName(Common.isNotNull(socialInfo.getUnitName()) ? socialInfo.getUnitName(): "");
					payExists.setSocialProvince(socialInfo.getSocialProvince());
					payExists.setSocialCity(socialInfo.getSocialCity());
					payExists.setSocialTown(Common.isNotNull(socialInfo.getSocialTown()) ? socialInfo.getSocialTown(): "");
					payExists.setSocialHousehold(socialInfo.getSocialHouseholdName());
				} else if (Common.isNotNull(tSocialInfo)) {
					payExists.setEmpId(tSocialInfo.getEmpId());
					payExists.setEmpIdcard(tSocialInfo.getEmpIdcard());
					payExists.setEmpName(tSocialInfo.getEmpName());
					if (Common.isNotNull(domainMap)) {
						domain = domainMap.get(tSocialInfo.getSettleDomainCode());
					} else {
						domain = null;
					}
					if (Common.isEmpty(domain)) {
						errorMessageList.put(UUID.randomUUID().toString(), new ErrorDetailVO(infoVo.getRowIndex(),
								CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(),
								payExists.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.NOT_EXIT_SETTLEiNFO));
						continue;
					}
					payExists.setSettleDomainId(tSocialInfo.getSettleDomain());
					payExists.setSettleDomainCode(tSocialInfo.getSettleDomainCode());
					payExists.setSettleDomainName(domain.getDepartName());
					payExists.setUnitId(domain.getCustomerId());
					payExists.setUnitName(domain.getCustomerName());
					payExists.setBpoFlag(domain.getBpoFlag());
					payExists.setSocialProvince(tSocialInfo.getSocialProvince());
					payExists.setSocialCity(tSocialInfo.getSocialCity());
					payExists.setSocialTown(Common.isNotNull(tSocialInfo.getSocialTown()) ? tSocialInfo.getSocialTown(): "");
					payExists.setSocialHousehold(tSocialInfo.getSocialHouseholdName());
				}
				// 项目信息校验
				errorInfo = settleInfoCheck(payExists);
				if (!Common.isEmpty(errorInfo)){
					errorMessageList.put(UUID.randomUUID().toString(), new ErrorDetailVO(infoVo.getRowIndex(),
							CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), payExists.getSocialHousehold(),
							payExists.getProvidentHousehold(), infoVo.getEmpName(), SocialConstants.ERROR_PRI
							+ errorInfo + SocialConstants.ERROR_END));
					continue;
				}
				if (Common.isNotNull(tSocialInfo)) {
					payExists.setInauguralTeam(Common.isNotNull(tSocialInfo.getInauguralTeam()) ? tSocialInfo.getInauguralTeam(): "");
					payExists.setEmpNo(Common.isNotNull(tSocialInfo.getEmpNo()) ? tSocialInfo.getEmpNo(): "");
				} else {
					payExists.setInauguralTeam("");
					payExists.setEmpNo("");
				}
				payExists.setSocialPayMonth(infoVo.getSocialPayMonth());

				if (null != payExists.getSocialProvince()) {
					temp = areaMap.get(payExists.getSocialProvince());
					if (Common.isNotNull(temp)) {
						payExists.setSocialPayAddr(temp);
					}
				}
				if (null != payExists.getSocialCity()) {
					temp = areaMap.get(payExists.getSocialCity());
					if (Common.isNotNull(temp)) {
						payExists.setSocialPayAddr(payExists.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				}
				if (null != payExists.getSocialTown()) {
					temp = areaMap.get(payExists.getSocialTown());
					if (Common.isNotNull(temp)) {
						payExists.setSocialPayAddr(payExists.getSocialPayAddr() + CommonConstants.CENTER_SPLIT_LINE_STRING + temp);
					}
				} else {
					payExists.setSocialTown("");
				}
				payExists.setSocialSecurityNo(infoVo.getSocialSecurityNo());
				payExists.setSocialCreateMonth(infoVo.getSocialCreateMonth());
				payExists.setCreateTime(LocalDateTime.now());
				payExists.setSocialId(UUID.randomUUID().toString());
				if (PaymentConstants.PENSION_RISK.equals(infoVo.getRiskType())) {
					payExists.setUnitPensionMoney(infoVo.getUnitMoney());
					payExists.setUnitPensionSet(infoVo.getUnitSet());
					payExists.setPersonalPensionMoney(infoVo.getPersonalMoney());
					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitPensionMoney()
							, payExists.getUnitSocialSum()));
					payExists.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(payExists.getPersonalPensionMoney()
							, payExists.getSocialSecurityPersonalSum()));
					payExists.setSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitSocialSum(), payExists.getSocialSecurityPersonalSum()));
					payExists.setSumAll(payExists.getSocialSum());
					batchYlInsertList.put(UUID.randomUUID().toString(),payExists);
				}
				if (PaymentConstants.UNEMPLOYEEMENT_RISK.equals(infoVo.getRiskType())) {
					payExists.setUnitUnemploymentMoney(infoVo.getUnitMoney());
					payExists.setPersonalUnemploymentMoney(infoVo.getPersonalMoney());
					payExists.setUnitUnemploymentSet(infoVo.getUnitSet());
					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitUnemploymentMoney()
							, payExists.getUnitSocialSum()));
					payExists.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(payExists.getPersonalUnemploymentMoney()
							, payExists.getSocialSecurityPersonalSum()));
					payExists.setSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitSocialSum(), payExists.getSocialSecurityPersonalSum()));
					payExists.setSumAll(payExists.getSocialSum());
					batchSyInsertList.put(UUID.randomUUID().toString(),payExists);
				}
				if (PaymentConstants.INJURY_RISK.equals(infoVo.getRiskType())) {
					payExists.setUnitInjuryMoney(infoVo.getUnitMoney());
					payExists.setUnitInjurySet(infoVo.getUnitSet());
					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitInjuryMoney()
							, payExists.getUnitSocialSum()));
					payExists.setSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitSocialSum(), payExists.getSocialSecurityPersonalSum()));
					payExists.setSumAll(payExists.getSocialSum());
					batchGsInsertList.put(UUID.randomUUID().toString(),payExists);
				}
				if (CommonConstants.ONE_STRING.equals(type)) {
					payExists.setUnitMedicalMoney(null == infoVo.getUnitMedicalMoney() ? BigDecimal.ZERO : infoVo.getUnitMedicalMoney());
					payExists.setPersonalMedicalMoney(null == infoVo.getPersonalMedicalMoney() ? BigDecimal.ZERO : infoVo.getPersonalMedicalMoney());
					payExists.setUnitBigmailmentMoney(null == infoVo.getUnitBigailmentMoney() ? BigDecimal.ZERO : infoVo.getUnitBigailmentMoney());
					payExists.setUnitMedicalSet(null == infoVo.getMedicalSet() ? BigDecimal.ZERO : infoVo.getMedicalSet());
					payExists.setPersonalBigmailmentMoney(null == infoVo.getPersonalBigailmentMoney() ? BigDecimal.ZERO : infoVo.getPersonalBigailmentMoney());
					payExists.setSocialSecurityNo(null == infoVo.getSocialSecurityNo() ? "" : infoVo.getSocialSecurityNo());
					payExists.setUnitSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitMedicalMoney()
							, payExists.getUnitBigmailmentMoney()
							, payExists.getUnitSocialSum()));
					payExists.setSocialSecurityPersonalSum(BigDecimalUtils.safeAdd(payExists.getPersonalMedicalMoney()
							, payExists.getPersonalBigmailmentMoney()
							, payExists.getSocialSecurityPersonalSum()));
					payExists.setSocialSum(BigDecimalUtils.safeAdd(payExists.getUnitSocialSum(), payExists.getSocialSecurityPersonalSum()));
					payExists.setSumAll(payExists.getSocialSum());
					batchYyInsertList.put(UUID.randomUUID().toString(),payExists);
				}
				errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ONE_INT,
						infoVo.getEmpIdcard(),
						payExists.getSocialHousehold(),
						payExists.getProvidentHousehold(), infoVo.getEmpName(),
						"对应员工身份证" + infoVo.getEmpIdcard() + CommonConstants.SAVE_SUCCESS,CommonConstants.GREEN));
			}
		}
		return errorMessageList;
	}

	/**
	 * 导入校验
	 **/
	private boolean socialThreeCheckBase(ConcurrentHashMap<String, ErrorDetailVO> errorMessageList,
										 TPaymentHeFeiVo infoVo, String type) {
		if (!Common.isNotNull(infoVo.getSocialPayMonth())) {
			errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), "社保缴纳月份不可为空！"));
			return true;
		}
		if (!Common.isNotNull(infoVo.getSocialCreateMonth())) {
			errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), "社保生成月份不可为空！"));
			return true;
		}
		if (!Common.isNotNull(infoVo.getSocialPayAddr())) {
			errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), "社保缴纳地不可为空！"));
			return true;
		}
		if (CommonConstants.ZERO_STRING.equals(type) && !PaymentConstants.PENSION_RISK.equals(infoVo.getRiskType())
				&& !PaymentConstants.UNEMPLOYEEMENT_RISK.equals(infoVo.getRiskType())
				&& !PaymentConstants.INJURY_RISK.equals(infoVo.getRiskType())) {
			errorMessageList.put(UUID.randomUUID().toString(),new ErrorDetailVO(infoVo.getRowIndex(), CommonConstants.ZERO_INT, infoVo.getEmpIdcard(), "", "", infoVo.getEmpName(), "无相关险种！"));
			return true;
		}
		return false;
	}

	/**
	 * 转换缴纳地址为省市县ID
	 **/
	private TPaymentHeFeiVo initAddressThree(String[] areaArray, HashMap<String, String> areaMap2, TPaymentHeFeiVo s) {
		if (null == areaArray || null == areaMap2 || null == s) {
			return s;
		}
		String temp;
		if (areaArray.length >= CommonConstants.TWO_INT) {
			temp = areaMap2.get(areaArray[0] + CommonConstants.DOWN_LINE_STRING + "null");
			if (Common.isNotNull(temp)) {
				s.setSocialProvince(Integer.valueOf(temp));
			}
			temp = areaMap2.get(areaArray[1] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialProvince()
					? "null" : Integer.toString(s.getSocialProvince())));
			if (Common.isNotNull(temp)) {
				s.setSocialCity(Integer.valueOf(temp));
			}
			if (areaArray.length >= CommonConstants.THREE_INT) {
				temp = areaMap2.get(areaArray[2] + CommonConstants.DOWN_LINE_STRING + (null == s.getSocialCity()
						? "null" : Integer.toString(s.getSocialCity())));
				if (Common.isNotNull(temp)) {
					s.setSocialTown(Integer.valueOf(temp));
				}
			}
		}
		return s;
	}

	//比对缴纳地是否一致
	private TSocialFundInfo checkAddress(String[] areaArray, HashMap<String, String> areaMap, TSocialFundInfo s,
										 HashMap<String, String> areaMap2, TPaymentInfoVo infoVo) {
		if (null == areaArray || null == areaMap || null == s) {
			return null;
		}
		String temp;
		if (areaArray.length >= CommonConstants.TWO_INT) {
			temp = areaMap2.get(areaArray[0] + CommonConstants.DOWN_LINE_STRING + "null");
			if (Common.isNotNull(temp)) {
				infoVo.setFundProvince(temp);
			}
			temp = areaMap2.get(areaArray[1] + CommonConstants.DOWN_LINE_STRING + (null == infoVo.getFundProvince()
					? "null" : infoVo.getFundProvince()));
			if (Common.isNotNull(temp)) {
				infoVo.setFundCity(temp);
			}
			if (areaArray.length >= CommonConstants.THREE_INT) {
				temp = areaMap2.get(areaArray[2] + CommonConstants.DOWN_LINE_STRING + (null == infoVo.getFundCity()
						? "null" : infoVo.getFundCity()));
				if (Common.isNotNull(temp)) {
					infoVo.setFundTown(temp);
				}
			}
			if (null != s.getFundProvince()) {
				if (areaArray[0].equals(areaMap.get(s.getFundProvince()))) {
					if (null != s.getFundCity()) {
						if (areaArray[1].equals(areaMap.get(s.getFundCity()))) {
							if (areaArray.length >= CommonConstants.THREE_INT) {
								if (null != s.getFundTown() && areaArray[CommonConstants.TWO_INT].equals(
										areaMap.get(s.getFundTown()))) {
									return s;
								}
							} else {
								if (null == s.getFundTown()) {
									return s;
								}
							}
						}
					} else {
						return null;
					}
				}

			} else {
				return null;
			}

		} else if (areaArray.length == 1) {
			if (null != s.getFundProvince() && null == s.getFundCity()) {
				if (areaArray[0].equals(areaMap.get(s.getFundProvince()))) {
					return s;
				}
			} else {
				return null;
			}
		}
		return null;
	}

	/**
	 * 薪资获取缴费库
	 *
	 * @Author hgw
	 * @Date 2022-8-10 18:06:13
	 **/
	@Override
	public TPaymentVo selectTPaymentBySalaryVo(TPaymentBySalaryVo tPaymentBySalaryVo) {
		List<TPaymentBySalaryVo> list = baseMapper.selectTPaymentBySalaryVo(tPaymentBySalaryVo);
		TPaymentVo vo = new TPaymentVo();
		vo.setPaymentList(list);
		return vo;
	}

	@Override
	public int updatePaymentSocialStatusToSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentSocialStatusByIdList(idList, CommonConstants.ONE_STRING);
		}
		return 0;
	}

	@Override
	public int updatePaymentSocialStatusToNoSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentSocialStatusByIdList(idList, CommonConstants.ZERO_STRING);
		}
		return 0;
	}

	@Override
	public int updatePaymentFundStatusToSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentFundStatusByIdList(idList, CommonConstants.ONE_STRING);
		}
		return 0;
	}

	@Override
	public int updatePaymentFundStatusToNoSettle(List<String> idList) {
		if (idList != null && !idList.isEmpty()) {
			return baseMapper.updatePaymentFundStatusByIdList(idList, CommonConstants.ZERO_STRING);
		}
		return 0;
	}

	@Override
	public void updatePaymentSocialAndFound(UpdateSocialFoundVo infoVo) {
		if (Common.isNotNull(infoVo)) {
			baseMapper.updatePaymentSocialAndFound(infoVo);
		}
	}

	@Override
	public void createPaymentSocialInfo() {
		//获取所有未推送的社保实缴明细数据
		long count = baseMapper.getTPaymentInfoSumPushCount(null);
		if (count > 0) {
			List<TPaymentInfoPushVo> unPushs;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			Map<String, TSettleDomainSelectVo> mapSelectVo = this.getSelectVoMap();
			for (int j = 0; j < i; j++) {
				unPushs = baseMapper.getTPaymentInfoSumPushList(null);
				synchronized (this) {
					if (Common.isNotNull(unPushs)) {
						//推送数据封装并推送
						doJointSocialTask.asynchronousEkpPaymentSocial(unPushs, mapSelectVo);
					}
				}
			}
		}
	}

	@Override
	public void createPaymentFundInfo() {
		long count = baseMapper.selectCount(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
				.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING)
				.isNotNull(TPaymentInfo::getFundId));
		if (count > 0) {
			List<TPaymentInfo> unPushInfo;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			Map<String, TSettleDomainSelectVo> mapSelectVo = this.getSelectVoMap();
			for (int j = 0; j < i; j++) {
				//获取所有未推送的公积金实缴明细数据
				unPushInfo = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
						.eq(TPaymentInfo::getPushStatus, CommonConstants.ONE_STRING)
						.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING)
						.isNotNull(TPaymentInfo::getFundId).last(" limit 0,10000"));
				synchronized (this) {
					if (Common.isNotNull(unPushInfo)) {
						//推送数据封装并推送
						doJointSocialTask.asynchronousEkpPaymentFund(unPushInfo, mapSelectVo);
					}
				}
			}
		}
	}

	@Override
	public R<Boolean> pushPaymentSocialFundInfo(TPaymentInfoSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		String key = CacheConstants.PAYMENT_SOCIAL_PUSH + CommonConstants.DOWN_LINE_STRING +user.getId() ;
		if (Common.isNotNull(redisUtil.get(key))) {
			return R.failed("用户正在推送实缴数据中，禁止重复推送！");
		} else {
			redisUtil.set(key, user.getId(), 1200L);
		}
		// 获取redis分布式事务锁
		String requestId;
		try {
			requestId = RedisDistributedLock.getLock(key,"10");
		} catch (Exception e) {
			throw new RuntimeException(ResultConstants.NO_GETLOCK_DATA+CommonConstants.DOWN_LINE_STRING+e.getMessage());
		}
		if (Common.isNotNull(requestId)) {
			Map<String, TSettleDomainSelectVo> mapSelectVo = this.getSelectVoMap();
			//手动推送未推送的社保公积金明细数据
			createPaymentSocialInfoReal(user, searchVo, mapSelectVo);
			createPaymentFundInfoReal(user, searchVo, mapSelectVo);
			//推送社保公积金收入数据
			String redisKey = String.valueOf(UUID.randomUUID()).replaceAll("-", "") + "_incomePush";
			createPaymentInfoIncomeReal(user, searchVo, mapSelectVo, redisKey);
			createPaymentFundIncomeReal(user, searchVo, mapSelectVo, redisKey);
			//推送失败的数据重新推送
			if (Common.isNotNull(redisUtil.get(redisKey))) {
				List<TIncome> list = (List<TIncome>) redisUtil.get(redisKey);
				for (TIncome income : list) {
					doJointSocialTask.asynchronousEkpIncomePaymentT(income);
				}
				redisUtil.remove(redisKey);
			}
			redisUtil.remove(key);
			//主动释放锁
			RedisDistributedLock.unlock(key, requestId);
			return R.ok();
		}else {
			return R.failed(ResultConstants.NO_GETLOCK_DATA);
		}
	}

	@Override
	public R<Boolean> batchUpdatePaymentInfo(TPaymentInfoSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(user)) {
			return R.failed("获取登录用户信息失败！");
		}
		searchVo.setCreateBy(user.getId());
		List<String> list = baseMapper.getTPaymentInfoList(searchVo);
		if (Common.isEmpty(list)) {
			return R.failed("未找到本人创建的未标识确认无误的数据");
		} else {
			LambdaUpdateWrapper<TPaymentInfo> updateWrapper = new UpdateWrapper<TPaymentInfo>().lambda();
			updateWrapper.set(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING).in(TPaymentInfo::getId, list);
			return R.ok(this.update(updateWrapper));
		}
	}

	@Override
	public void createPaymentInfoIncome() {
		long count = baseMapper.selectCount(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
				.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING)
				.eq(TPaymentInfo::getIsIncomeStatus, CommonConstants.ZERO_STRING)
				.isNotNull(TPaymentInfo::getSocialId));
		if (count > 0) {
			List<TPaymentInfo> sumList;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			Map<String, TSettleDomainSelectVo> mapSelectVo = this.getSelectVoMap();
			String redisKey = String.valueOf(UUID.randomUUID()).replaceAll("-", "") + "_incomePush";
			for (int j = 0; j < i; j++) {
				//判断缴费库中社保合计和本次导入合计相加是否为0，为0则不生成收入
				sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
						.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
						.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING)
						.eq(TPaymentInfo::getIsIncomeStatus, CommonConstants.ZERO_STRING)
						.isNotNull(TPaymentInfo::getSocialId).last(" limit 0,10000"));
				synchronized (this) {
					if (Common.isNotNull(sumList)) {
						//生成收入
						createIncomeInfo(sumList, CommonConstants.ONE_STRING, mapSelectVo, redisKey);
					}
				}
			}
			//推送失败的数据重新推送
			if (Common.isNotNull(redisUtil.get(redisKey))) {
				List<TIncome> list = (List<TIncome>) redisUtil.get(redisKey);
				for (TIncome income : list) {
					doJointSocialTask.asynchronousEkpIncomePaymentT(income);
				}
				redisUtil.remove(redisKey);
			}
		}
	}

	@Override
	public void createPaymentFundIncome() {
		long count = baseMapper.selectCount(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
				.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING)
				.eq(TPaymentInfo::getIsIncomeStatus, CommonConstants.ZERO_STRING)
				.isNotNull(TPaymentInfo::getFundId));
		if (count > 0) {
			List<TPaymentInfo> sumList;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			Map<String, TSettleDomainSelectVo> mapSelectVo = this.getSelectVoMap();
			String redisKey = String.valueOf(UUID.randomUUID()).replaceAll("-", "") + "_incomePush";
			for (int j = 0; j < i; j++) {
				sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
						.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
						.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING)
						.eq(TPaymentInfo::getIsIncomeStatus, CommonConstants.ZERO_STRING)
						.isNotNull(TPaymentInfo::getFundId).last(" limit 0,10000"));
				synchronized (this) {
					if (Common.isNotNull(sumList)) {
						//生成公积金收入
						createIncomeInfo(sumList, CommonConstants.TWO_STRING, mapSelectVo, redisKey);
					}
				}
			}
			//推送失败的数据重新推送
			if (Common.isNotNull(redisUtil.get(redisKey))) {
				List<TIncome> list = (List<TIncome>) redisUtil.get(redisKey);
				for (TIncome income : list) {
					doJointSocialTask.asynchronousEkpIncomePaymentT(income);
				}
				redisUtil.remove(redisKey);
			}
		}
	}

	@Override
	public void signPaymentNoIncomeFlag() {
		//标识根据项目不需要生成收入的数据
		long count = baseMapper.selectCount(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
				.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING));
		if (count > 0) {
			List<TPaymentInfo> unPushInfo;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			for (int j = 0; j < i; j++) {
				unPushInfo = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
						.eq(TPaymentInfo::getIncomeStatus, CommonConstants.ONE_STRING)
						.eq(TPaymentInfo::getLockStatus, CommonConstants.ONE_STRING)
						.last(" limit 0,10000"));
				synchronized (this) {
					if (Common.isNotNull(unPushInfo)) {
						//判断是否需要生成收入并标识
						signIncomeFlag(unPushInfo);
					}
				}
			}
		}
	}

	public void createPaymentSocialInfoReal(YifuUser user, TPaymentInfoSearchVo searchVo,
											Map<String, TSettleDomainSelectVo> mapSelectVo) {
		//获取所有未推送的社保实缴明细数据
		searchVo.setCreateBy(user.getId());
		long count = baseMapper.getTPaymentInfoSumPushCount(searchVo);
		if (count > 0) {
			List<TPaymentInfoPushVo> unPushInfo;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			for (int j = 0; j < i; j++) {
				unPushInfo = baseMapper.getTPaymentInfoSumPushList(searchVo);
				synchronized (this) {
					if (Common.isNotNull(unPushInfo)) {
						//推送数据封装并推送
						doJointSocialTask.asynchronousEkpPaymentSocial(unPushInfo, mapSelectVo);
					}
				}
			}
		}
	}

	public void createPaymentFundInfoReal(YifuUser user, TPaymentInfoSearchVo searchVo,
										  Map<String, TSettleDomainSelectVo> mapSelectVo) {
		//获取所有未推送的公积金实缴明细数据
		searchVo.setLockStatus(CommonConstants.ONE_STRING);
		long count = baseMapper.getTPaymentFundPushCount(searchVo, user.getId());
		if (count > 0) {
			List<TPaymentInfo> unPushInfo;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			for (int j = 0; j < i; j++) {
				unPushInfo = baseMapper.getTPaymentFundPushInfo(searchVo, user.getId());
				synchronized (this) {
					if (Common.isNotNull(unPushInfo)) {
						//推送数据封装并推送
						doJointSocialTask.asynchronousEkpPaymentFund(unPushInfo, mapSelectVo);
					}
				}
			}
		}
	}

	public void createPaymentInfoIncomeReal(YifuUser user, TPaymentInfoSearchVo searchVo,
											Map<String, TSettleDomainSelectVo> mapSelectVo, String redisKey) {
		searchVo.setLockStatus(CommonConstants.ONE_STRING);
		long count = baseMapper.getTPaymentSocialIncomeCount(searchVo, user.getId());
		if (count > 0) {
			List<TPaymentInfo> sumList;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			for (int j = 0; j < i; j++) {
				sumList = baseMapper.getTPaymentSocialIncomeInfo(searchVo, user.getId());
				synchronized (this) {
					if (Common.isNotNull(sumList)) {
						//生成收入
						createIncomeInfo(sumList, CommonConstants.ONE_STRING, mapSelectVo, redisKey);
					}
				}
			}
		}
	}

	public void createPaymentFundIncomeReal(YifuUser user, TPaymentInfoSearchVo searchVo,
											Map<String, TSettleDomainSelectVo> mapSelectVo, String redisKey) {
		searchVo.setLockStatus(CommonConstants.ONE_STRING);
		long count = baseMapper.getTPaymentFundIncomeCount(searchVo, user.getId());
		if (count > 0) {
			List<TPaymentInfo> sumList;
			int i = (int) Math.ceil((double) count / CommonConstants.TEN_THOUSAND_INT);
			for (int j = 0; j < i; j++) {
				sumList = baseMapper.getTPaymentFundIncomeInfo(searchVo, user.getId());
				synchronized (this) {
					if (Common.isNotNull(sumList)) {
						//生成公积金收入
						createIncomeInfo(sumList, CommonConstants.TWO_STRING, mapSelectVo, redisKey);
					}
				}
			}
		}
	}

	@Override
	public TPaymentVo getPaymentSocialAndFound(TPaymentInfo info) {
		List<TPaymentInfo> sumList = baseMapper.selectList(Wrappers.<TPaymentInfo>query().lambda()
				.eq(TPaymentInfo::getEmpIdcard, info.getEmpIdcard())
				.eq(TPaymentInfo::getSettleDomainId, info.getSettleDomainId())
				.eq(TPaymentInfo::getSocialCreateMonth, "202212"));
		TPaymentVo paymentVo = new TPaymentVo();
		paymentVo.setPaymentInfoList(sumList);
		return paymentVo;
	}

	public void signIncomeFlag(List<TPaymentInfo> updateList) {
		//获取所有的项目编码
		List<String> deptNoList = updateList.stream().map(TPaymentInfo::getSettleDomainCode).collect(Collectors.toList());
		//获取对应项目信息
		Map<String, TSettleDomain> data = new HashMap<>();
		TSettleDomain settleDomain;
		try {
			R<TSettleDomainListVo> infoByCodes = archivesDaprUtil.getSettleInfoByCodes(deptNoList);
			if (null != infoByCodes && Common.isNotNull(infoByCodes.getData()) && Common.isNotNull(infoByCodes.getData().getMapVO())) {
				data = infoByCodes.getData().getMapVO();
			}
			if (Common.isNotNull(data)) {
				for (TPaymentInfo paymentInfo : updateList) {
					settleDomain = data.get(paymentInfo.getSettleDomainCode());
					boolean isIncomeFlag = false;
					if (Common.isNotNull(settleDomain)) {
						if (Common.isNotNull(settleDomain.getManageServerItem()) && ((settleDomain.getManageServerItem().contains(CommonConstants.ONE_STRING)
								&& Common.isNotNull(paymentInfo.getSocialId())) || (settleDomain.getManageServerItem().contains(CommonConstants.TWO_STRING)
								&& Common.isNotNull(paymentInfo.getFundId()))) && CommonConstants.ZERO_STRING.equals(settleDomain.getManagementTag()) &&
								CommonConstants.TWO_STRING.equals(settleDomain.getMrSettleType())) {
							//实缴模式
							isIncomeFlag = true;
						}
						if (Common.isNotNull(settleDomain.getRiskServerItem()) && ((settleDomain.getRiskServerItem().contains(CommonConstants.ONE_STRING)
								&& Common.isNotNull(paymentInfo.getSocialId())) || (settleDomain.getRiskServerItem().contains(CommonConstants.TWO_STRING)
								&& Common.isNotNull(paymentInfo.getFundId()))) && CommonConstants.ZERO_STRING.equals(settleDomain.getRiskFundTag()) &&
								CommonConstants.TWO_STRING.equals(settleDomain.getMrSettleType())) {
							//实缴模式
							isIncomeFlag = true;
						}
					}
					if (!isIncomeFlag) {
						baseMapper.updateBySocialIncomeFlag(paymentInfo.getId());
					}
				}
			}
		} catch (Exception e) {
			log.error("标识是否需要生成收入异常", e);
		}
	}

	public void createIncomeInfo(List<TPaymentInfo> updateList, String socialFundFlag,
								 Map<String, TSettleDomainSelectVo> mapSelectVo, String redisKey) {
		List<TIncomeDetail> exitIncome;
		TSettleDomain settleDomain;
		try {
			for (TPaymentInfo paymentInfo : updateList) {
				boolean exitFlag = false;
				if (CommonConstants.ONE_STRING.equals(socialFundFlag)) {
					exitIncome = detailMapper.selectList(Wrappers.<TIncomeDetail>query().lambda()
							.eq(TIncomeDetail::getEmpIdcard, paymentInfo.getEmpIdcard())
							.eq(TIncomeDetail::getPayMonth, paymentInfo.getSocialPayMonth())
							.eq(TIncomeDetail::getDeptId, paymentInfo.getSettleDomainId())
							.eq(TIncomeDetail::getSourceType, CommonConstants.ONE_STRING));
				} else {
					exitIncome = detailMapper.selectList(Wrappers.<TIncomeDetail>query().lambda()
							.eq(TIncomeDetail::getEmpIdcard, paymentInfo.getEmpIdcard())
							.eq(TIncomeDetail::getPayMonth, paymentInfo.getProvidentPayMonth())
							.eq(TIncomeDetail::getDeptId, paymentInfo.getSettleDomainId())
							.eq(TIncomeDetail::getSourceType, CommonConstants.TWO_STRING));
				}
				if (Common.isNotNull(exitIncome)) {
					BigDecimal sumMoney = BigDecimal.ZERO;
					for (TIncomeDetail income : exitIncome) {
						sumMoney = BigDecimalUtils.safeAdd(income.getMoney(), sumMoney);
						if (paymentInfo.getId().equals(income.getSourceId())) {
							exitFlag = true;
						}
					}
					if (exitFlag) {
						baseMapper.updateBySocialIncomeFlag(paymentInfo.getId());
						continue;
					}
					if (sumMoney.compareTo(BigDecimal.ZERO) > 0) {
						exitFlag = true;
					}
				}

				//获取项目信息
				if (Common.isNotNull(mapSelectVo)) {
					settleDomain = mapSelectVo.get(paymentInfo.getSettleDomainCode());
				} else {
					settleDomain = null;
				}

				int isSum = 0;
				if (Common.isNotNull(settleDomain)) {
					boolean isIncomeFlag = false;
					// 含有社保，则计算收入
					if (Common.isNotNull(settleDomain.getManageServerItem()) && ((settleDomain.getManageServerItem().contains(CommonConstants.ONE_STRING)
							&& CommonConstants.ONE_STRING.equals(socialFundFlag)) || (settleDomain.getManageServerItem().contains(CommonConstants.TWO_STRING)
							&& CommonConstants.TWO_STRING.equals(socialFundFlag))) && CommonConstants.ZERO_STRING.equals(settleDomain.getManagementTag())
							&& CommonConstants.TWO_STRING.equals(settleDomain.getMrSettleType())) {
						//实缴模式
						BigDecimal gMoney;
						if (CommonConstants.TWO_STRING.equals(settleDomain.getManagementType())) {
							gMoney = settleDomain.getManagementFee();
						} else if (CommonConstants.THREE_STRING.equals(settleDomain.getManagementType())) {
							gMoney = settleDomain.getManagementFee();
						} else {
							isSum = 1;
							if (CommonConstants.ONE_STRING.equals(socialFundFlag)) {
								gMoney = BigDecimalUtils.safeMultiply(paymentInfo.getSocialSum(),
										settleDomain.getManagementFee().divide(new BigDecimal("100"),
												CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
							} else {
								gMoney = BigDecimalUtils.safeMultiply(paymentInfo.getProvidentSum(),
										settleDomain.getManagementFee().divide(new BigDecimal("100"),
												CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
							}
						}
						if (!exitFlag || isSum == 1) {
							isIncomeFlag = true;
							createIncomeInsurance(paymentInfo, settleDomain, CommonConstants.ONE_STRING,
									settleDomain.getManagementFee().toString(), settleDomain.getManagementType(),
									gMoney, socialFundFlag, redisKey);
						}
					}
					if (Common.isNotNull(settleDomain.getRiskServerItem()) && ((settleDomain.getRiskServerItem().contains(CommonConstants.ONE_STRING)
							&& CommonConstants.ONE_STRING.equals(socialFundFlag)) || (settleDomain.getRiskServerItem().contains(CommonConstants.TWO_STRING)
							&& CommonConstants.TWO_STRING.equals(socialFundFlag))) && CommonConstants.ZERO_STRING.equals(settleDomain.getRiskFundTag())
							&& CommonConstants.TWO_STRING.equals(settleDomain.getMrSettleType())) {
						//实缴模式
						BigDecimal money;
						if (CommonConstants.TWO_STRING.equals(settleDomain.getRiskFundType())) {
							money = settleDomain.getRiskFundFee();
						} else if (CommonConstants.THREE_STRING.equals(settleDomain.getRiskFundType())) {
							money = settleDomain.getRiskFundFee();
						} else {
							isSum = 2;
							if (CommonConstants.ONE_STRING.equals(socialFundFlag)) {
								money = BigDecimalUtils.safeMultiply(paymentInfo.getSocialSum(),
										settleDomain.getRiskFundFee().divide(new BigDecimal("100"),
												CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
							} else {
								money = BigDecimalUtils.safeMultiply(paymentInfo.getProvidentSum(),
										settleDomain.getRiskFundFee().divide(new BigDecimal("100"),
												CommonConstants.FIVE_INT, RoundingMode.HALF_UP));
							}
						}
						if (!exitFlag || isSum == 2) {
							isIncomeFlag = true;
							createIncomeInsurance(paymentInfo, settleDomain, CommonConstants.TWO_STRING,
									settleDomain.getRiskFundFee().toString(), settleDomain.getRiskFundType(),
									money, socialFundFlag, redisKey);
						}
					}
					if (!isIncomeFlag) {
						baseMapper.updateBySocialIncomeFlag(paymentInfo.getId());
					}
				}
			}
		} catch (Exception e) {
			log.error("生成社保收入异常", e);
		}
	}

	public void createIncomeInsurance(TPaymentInfo library, TSettleDomain settleDomain, String feeType,
									  String charges, String feeMode, BigDecimal money, String sourceType,
									  String redisKey) {
		//生成收入数据
		TIncomeDetail detail = new TIncomeDetail();
		detail.setCreateTime(DateUtil.getCurrentDateTime());
		detail.setRedisKey(redisKey);
		detail.setDeptName(settleDomain.getDepartName());
		detail.setDeptNo(settleDomain.getDepartNo());
		detail.setDeptId(settleDomain.getId());
		detail.setEmpIdcard(library.getEmpIdcard());
		detail.setEmpName(library.getEmpName());
		detail.setUnitNo(settleDomain.getCustomerNo());
		detail.setUnitId(settleDomain.getCustomerId());
		detail.setUnitName(settleDomain.getCustomerName());
		detail.setDataCreateMonth(DateUtil.addMonth(0));
		detail.setSourceId(library.getId());
		detail.setSourceType(sourceType);
		if (CommonConstants.ONE_STRING.equals(sourceType)) {
			detail.setCreateMonth(library.getSocialCreateMonth());
			detail.setPayMonth(library.getSocialPayMonth());
		} else {
			detail.setCreateMonth(library.getProvidentCreateMonth());
			detail.setPayMonth(library.getProvidentPayMonth());
		}
		detail.setMoney(money);
		detail.setFeeType(feeType);
		detail.setFeeMode(feeMode);
		detail.setCharges(charges);
		detail.setMrSettleType(settleDomain.getMrSettleType());
		detail.setId(CommonConstants.NULL);
		detail.setRedData(CommonConstants.ZERO_STRING);
		incomeService.saveBathDetail(detail, library.getId());
	}

	/**
	 * @param changeDeptVo 变更主体数据
	 * @Description: 费用划转-ekp同步hro
	 * @Author: hgw
	 * @Date: 2022/11/16 10:39
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Override
	public R<String> changeDeptByEkp(ChangeDeptVo changeDeptVo) {
		// 获取项目信息：
		TSettleDomainSelectVo dept = archivesDaprUtil.selectDeptByNo(changeDeptVo.getNowProjectno());
		if (dept != null && dept.getId() != null) {
			changeDeptVo.setDept(dept);
			// 变更数据的主键id
			Set<String> idSet;

			// 存储日志使用的
			StringBuilder socialId = new StringBuilder();
			StringBuilder fundId = new StringBuilder();
			StringBuilder manageId = new StringBuilder();
			StringBuilder riskId = new StringBuilder();
			StringBuilder insuranceId = new StringBuilder();
			// 如果选择了社保公积金信息要划转，则校验。
			// 否则跳过这一步，直接划转
			if ((changeDeptVo.getShebao() != null && !changeDeptVo.getShebao().isEmpty())
					|| (changeDeptVo.getGongjijin() != null && !changeDeptVo.getGongjijin().isEmpty())) {
				idSet = new HashSet<>();
				TPaymentSocialPush socialPush;
				if (changeDeptVo.getShebao() != null && !changeDeptVo.getShebao().isEmpty()) {
					for (ChangeDeptDetailVo vo : changeDeptVo.getShebao()) {
						socialPush = pushMapper.selectById(vo.getId());
						//根据明细id更新结算状态
						if (null != socialPush) {
							List<String> idStr = Common.initStrToList(socialPush.getPaymentIds().replaceAll("'",""),",");
							if (null != idStr) {
								idSet.addAll(idStr);
								for (String s :idStr) {
									socialId.append(s).append(CommonConstants.DUNHAO_STRING);
								}
							}
						} else {
							idSet.add(vo.getId());
							socialId.append(vo.getId()).append(CommonConstants.DUNHAO_STRING);
						}
					}
				}
				if (changeDeptVo.getGongjijin() != null && !changeDeptVo.getGongjijin().isEmpty()) {
					for (ChangeDeptDetailVo vo : changeDeptVo.getGongjijin()) {
						idSet.add(vo.getId());
						fundId.append(vo.getId()).append(CommonConstants.DUNHAO_STRING);
					}
				}
				if (!idSet.isEmpty()) {
					// 查询是否允许划转缴费库、预估库 的 社保、公积金
					boolean flag = this.checkChange(idSet);
					if (!flag) {
						return R.failed("社保公积金已被结算，请先退回并删除工资表！");
					}

					// 1划转缴费率、预估库的项目（社保公积金）
					baseMapper.changePaymentDept(idSet, dept);
					tForecastLibraryMapper.changeForecastDept(idSet, dept);
				}
			}

			// 2划转管理费、风险金
			if ((changeDeptVo.getGuanlifei() != null && !changeDeptVo.getGuanlifei().isEmpty())
					|| (changeDeptVo.getFenxianjin() != null && !changeDeptVo.getFenxianjin().isEmpty())) {
				idSet = new HashSet<>();
				if (changeDeptVo.getGuanlifei() != null && !changeDeptVo.getGuanlifei().isEmpty()) {
					for (ChangeDeptDetailVo vo : changeDeptVo.getGuanlifei()) {
						idSet.add(vo.getId());
						manageId.append(vo.getId()).append(CommonConstants.DUNHAO_STRING);
					}
				}
				if (changeDeptVo.getFenxianjin() != null && !changeDeptVo.getFenxianjin().isEmpty()) {
					for (ChangeDeptDetailVo vo : changeDeptVo.getFenxianjin()) {
						idSet.add(vo.getId());
						riskId.append(vo.getId()).append(CommonConstants.DUNHAO_STRING);
					}
				}
				if (!idSet.isEmpty()) {
					incomeService.changeIncomeAndDetailDept(idSet, dept);
				}
			}
			// 3划转商险
			if (changeDeptVo.getShangxian() != null && !changeDeptVo.getShangxian().isEmpty()) {
				idSet = new HashSet<>();
				for (ChangeDeptDetailVo vo : changeDeptVo.getShangxian()) {
					idSet.add(vo.getId());
					insuranceId.append(vo.getId()).append(CommonConstants.DUNHAO_STRING);
				}
				if (!idSet.isEmpty()) {
					insuranceDaprUtil.ekpUpdateInsuranceDept(changeDeptVo);
				}
			}

			// 4 记录日志
			TEkpChangeDeptLog log = new TEkpChangeDeptLog();
			log.setCreateName(changeDeptVo.getCreator());
			log.setCreateTime(new Date());
			log.setPreDeptName(changeDeptVo.getPreProjectname());
			log.setPreDeptNo(changeDeptVo.getPreProjectno());
			log.setNewDeptName(changeDeptVo.getNowProjectname());
			log.setNewDeptNo(changeDeptVo.getNowProjectno());
			log.setTransferType(changeDeptVo.getTransferType());
			log.setSocialId(socialId.toString());
			log.setFundId(fundId.toString());
			log.setManageId(manageId.toString());
			log.setRiskId(riskId.toString());
			log.setInsuranceId(insuranceId.toString());
			// 4记录费用划转日志
			tEkpChangeDeptLogService.save(log);
			return R.ok();
		} else {
			return R.failed("根据新编码未获取到项目信息");
		}
	}

	@Override
	public Boolean updateSocialSettleStatus(List<EkpSocialViewVo> viewVoList) {
		if (!viewVoList.isEmpty()) {
			TForecastLibrary library;
			TPaymentSocialPush socialPush;
			TPaymentInfo paymentInfo;
			try {
				for (EkpSocialViewVo viewVo : viewVoList) {
					//判断预估还是实缴
					if (viewVo.getSettleFlag().contains(SocialConstants.DIFF_TYPE_THR)) {
						socialPush = pushMapper.selectById(viewVo.getId());
						//根据明细id更新结算状态
						if (null != socialPush) {
							List<TPaymentInfo> paymentList = baseMapper.getAllPushInfoById(socialPush.getPaymentIds());
							if (!paymentList.isEmpty()) {
								for (TPaymentInfo tPaymentInfo : paymentList) {
									//判断是收入还是支出结算单号
									if (CommonConstants.ZERO_STRING.equals(viewVo.getPayFlag())) {
										tPaymentInfo.setIncomeSettleFlag(viewVo.getIncomeSettleFlag());
										tPaymentInfo.setIncomeCollectFlag(viewVo.getIncomeCollectFlag());
										baseMapper.updateStatusById(tPaymentInfo);
									} else {
										tPaymentInfo.setPaySettleFlag(viewVo.getPaySettleFlag());
										tPaymentInfo.setPayCollectFlag(viewVo.getPayCollectFlag());
										baseMapper.updateStatusById(tPaymentInfo);

									}
									log.info("缴费库实缴费用状态更新");
								}
							}
						} else {
							//根据明细id更新结算状态
							paymentInfo = baseMapper.selectById(viewVo.getId());
							if (Common.isNotNull(paymentInfo)) {
								//判断是收入还是支出结算单号
								if (CommonConstants.ZERO_STRING.equals(viewVo.getPayFlag())) {
									paymentInfo.setIncomeSettleFlag(viewVo.getIncomeSettleFlag());
									paymentInfo.setIncomeCollectFlag(viewVo.getIncomeCollectFlag());
								} else {
									paymentInfo.setPaySettleFlag(viewVo.getPaySettleFlag());
									paymentInfo.setPayCollectFlag(viewVo.getPayCollectFlag());
								}
								baseMapper.updateStatusById(paymentInfo);
								log.info("缴费库实缴费用状态更新");
							}
						}
					} else if (viewVo.getSettleFlag().contains(SocialConstants.DIFF_TYPE_ONE)) {
						//根据明细id更新结算状态
						library = tForecastLibraryMapper.selectById(viewVo.getId());
						if (Common.isNotNull(library)) {
							//判断是收入还是支出结算单号
							if (CommonConstants.ZERO_STRING.equals(viewVo.getPayFlag())) {
								library.setIncomeSettleFlag(viewVo.getIncomeSettleFlag());
								library.setIncomeCollectFlag(viewVo.getIncomeCollectFlag());
							} else {
								library.setPaySettleFlag(viewVo.getPaySettleFlag());
								library.setPayCollectFlag(viewVo.getPayCollectFlag());
							}
							tForecastLibraryMapper.updateForecastStatusById(library);
						}
					}
				}
			} catch (Exception e) {
				log.error("更新社保结算状态失败", e);
				return false;
			}
		}
		return true;
	}

	/**
	 * @param idSet
	 * @Description: 校验是否存在已结算薪资的数据
	 * @Author: hgw
	 * @Date: 2022/11/16 17:30
	 * @return: boolean
	 **/
	private boolean checkChange(Set<String> idSet) {
		int settleCount = baseMapper.checkPaymentChange(idSet);
		if (settleCount == 0) {
			settleCount = tForecastLibraryMapper.checkForecastChange(idSet);
			return settleCount == 0;
		} else {
			return false;
		}
	}

	private Map<String, TSettleDomainSelectVo> getSelectVoMap() {
		R<TSettleDomainListVo> settleDomainR = archivesDaprUtil.selectAllSettleDomainSelectVos();
		Map<String,TSettleDomainSelectVo> mapSelectVo = null;
		if (Common.isNotNull(settleDomainR) && Common.isNotNull(settleDomainR.getData())){
			mapSelectVo = settleDomainR.getData().getMapSelectVo();
		}
		if (Common.isEmpty(mapSelectVo)){
			ServiceUtil.runTimeExceptionDiy(CommonConstants.SETTLE_DOMAIN_GET_ERROR);
		}
		return mapSelectVo;
	}

	// hgw2023-1-6 10:44:00以下：B端相关接口
	/**
	 * 按年查询指定人的缴费库数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param year
	 * @param empId
	 **/
	@Override
	public List<PaymentBusinessPageVo> getPaymentByYearAndEmpId(String year, String empId) {
		List<PaymentBusinessPageVo> voList =  new ArrayList<>();
		TPaymentInfo paymentInfo = new TPaymentInfo();
		paymentInfo.setEmpId(empId);
		paymentInfo.setLikeYear(year);
		getPaymentBusinessPagesVoList(voList, paymentInfo,null, null);
		//排序
		paymentBusinessVosortByMonth(voList);
		return voList;
	}
	/**
	 * 缴费月份倒序
	 * @Author pwang
	 * @Date 2020-09-18 10:41
	 * @param list
	 * @return
	 **/
	private void paymentBusinessVosortByMonth(List<PaymentBusinessPageVo> list){
		Collections.sort(list, new Comparator<PaymentBusinessPageVo>() {
			@Override
			public int compare(PaymentBusinessPageVo o1, PaymentBusinessPageVo o2) {
				return o2.getMonth().compareTo(o1.getMonth());
			}
		});
	}

	private void getPaymentBusinessPagesVoList(List<PaymentBusinessPageVo> voList, TPaymentInfo paymentInfo
			, List<String> settleDomainIds, List<String> empIds) {
		List<TPaymentInfoVo> paymentAllInfoVoList =  baseMapper.getPaymentAllInfoList(paymentInfo, settleDomainIds
				, null,empIds);
		HashMap<String,PaymentBusinessPageVo> pageVoHashMap = new HashMap<>();
		if (Common.isNotNull(paymentAllInfoVoList)){
			PaymentBusinessPageVo pageVo;
			String payMonth;
			for (TPaymentInfoVo infoVo:paymentAllInfoVoList){
				payMonth = infoVo.getSocialPayMonth();
				if (Common.isEmpty(payMonth)) {
					payMonth = infoVo.getProvidentPayMonth();
				}
				if (Common.isNotNull(payMonth)){
					pageVo = pageVoHashMap.get(payMonth);
					if (null == pageVo){
						pageVo = new PaymentBusinessPageVo();
					}
					pageVo.setMonth(payMonth);
					// 处理合计
					initPaymentSum(pageVo,false, infoVo);
					pageVoHashMap.put(payMonth,pageVo);
				}
			}
		}
		if (Common.isNotNull(pageVoHashMap)){
			voList.addAll(sortValues(pageVoHashMap));
		}
	}

	private Collection sortValues(HashMap<String,PaymentBusinessPageVo> pageVoHashMap){
		List<PaymentBusinessPageVo>  temp  = new ArrayList<>();
		if (!pageVoHashMap.isEmpty()){
			Set set = pageVoHashMap.keySet();
			Object[] arr = set.toArray();
			Arrays.sort(arr);
			for (int i=arr.length-1;i>=0;i--) {
				temp.add(pageVoHashMap.get(arr[i]));
			}
		}
		return  temp;
	}

	/**
	 * 按年月查询指定人的缴费库数据：年月格式 YYYYMM
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param month
	 * @param empId
	 **/
	@Override
	public PaymentBusinessPageVo getPaymentByMonthAndEmpId(String month, String empId) {
		TPaymentInfo paymentInfo = new TPaymentInfo();
		paymentInfo.setEmpId(empId);
		paymentInfo.setSocialPayMonth(month);
		PaymentBusinessPageVo pageVo = getPaymentBusinessPageVo(paymentInfo);
		return pageVo;
	}

	private PaymentBusinessPageVo getPaymentBusinessPageVo(TPaymentInfo paymentInfo) {
		List<TPaymentInfoVo> paymentAllInfoVoList =  baseMapper.getPaymentAllInfoList(paymentInfo, null, null, null);
		PaymentBusinessPageVo pageVo = new PaymentBusinessPageVo();
		if (Common.isNotNull(paymentAllInfoVoList)){
			boolean isRefund;
			boolean isSocial;
			boolean  isInjury;
			for (TPaymentInfoVo infoVo:paymentAllInfoVoList){
				if (Common.isNotNull(infoVo.getSocialPayMonth())){
					pageVo.setMonth(infoVo.getSocialPayMonth());
				} else {
					pageVo.setMonth(infoVo.getProvidentPayMonth());
				}
				pageVo.setEmpId(infoVo.getEmpId());
				// 处理退费
				isRefund = null != infoVo.getSumAll() && infoVo.getSumAll().compareTo(BigDecimal.ZERO)  < CommonConstants.ZERO_INT;
				handleRefundMoney(pageVo, isRefund, infoVo);
				// 处理合计
				initPaymentSum(pageVo, isRefund, infoVo);
				// 处理各种金额比例数据  单位养老大于零默认为派单基数
				isSocial = (null != infoVo.getUnitPensionMoney() && infoVo.getUnitPensionMoney().compareTo(BigDecimal.ZERO) > CommonConstants.ZERO_INT)
						|| (null != infoVo.getUnitMedicalMoney() && infoVo.getUnitMedicalMoney().compareTo(BigDecimal.ZERO) > CommonConstants.ZERO_INT)
						|| (null != infoVo.getUnitUnemploymentMoney() && infoVo.getUnitUnemploymentMoney().compareTo(BigDecimal.ZERO) > CommonConstants.ZERO_INT)
						|| (null != infoVo.getUnitBirthMoney() && infoVo.getUnitBirthMoney().compareTo(BigDecimal.ZERO) > CommonConstants.ZERO_INT);
				// 非兼职工伤 非退费 处理
				handleSocialAndRefundMoney(pageVo, isRefund, isSocial, infoVo);
				// 处理兼职工伤数据
				isInjury = BigDecimalUtils.safeAdd(infoVo.getUnitPensionMoney(),infoVo.getUnitMedicalMoney(),infoVo.getUnitUnemploymentMoney(),infoVo.getUnitBirthMoney()).compareTo(BigDecimal.ZERO) == 0
						&& null != infoVo.getUnitInjuryMoney()
						&& infoVo.getUnitInjuryMoney().compareTo(BigDecimal.ZERO) > 0;
				// 处理 公积金和 非兼职工伤的退费数据
				handleSocialAndInjuryMoney(pageVo, isRefund, isInjury, infoVo);
			}
		}
		return pageVo;
	}
	/**
	 * 处理社保和退费金额
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param pageVo
	 * @param isRefund
	 * @param isSocial
	 * @param infoVo
	 * @return
	 **/
	private void handleSocialAndRefundMoney(PaymentBusinessPageVo pageVo, boolean isRefund, boolean isSocial, TPaymentInfoVo infoVo) {
		if (isSocial && !isRefund){
			pageVo.setPersonalPensionSet(infoVo.getUnitPensionSet());
			pageVo.setPersonalMedicalSet(infoVo.getUnitMedicalSet());
			pageVo.setPersonalUnemploymentSet(infoVo.getUnitUnemploymentSet());
			pageVo.setUnitPensionSet(infoVo.getUnitPensionSet());
			pageVo.setUnitMedicalSet(infoVo.getUnitMedicalSet());
			pageVo.setUnitInjurySet(infoVo.getUnitInjurySet());
			pageVo.setUnitUnemploymentSet(infoVo.getUnitUnemploymentSet());
			pageVo.setUnitBirthSet(infoVo.getUnitBirthSet());
			pageVo.setPersonalPensionPer(infoVo.getPersonalPensionPer());
			pageVo.setPersonalMedicalPer(infoVo.getPersonalMedicalPer());
			pageVo.setPersonalUnemploymentPer(infoVo.getPersonalUnemploymentPer());
			pageVo.setUnitPensionPer(infoVo.getUnitPensionPer());
			pageVo.setUnitMedicalPer(infoVo.getUnitMedicalPer());
			pageVo.setUnitInjuryPer(infoVo.getUnitInjuryPer());
			pageVo.setUnitUnemploymentPer(infoVo.getUnitUnemploymentPer());
			pageVo.setUnitBirthPer(infoVo.getUnitBirthPer());
		}
	}
	/**
	 * 处理退费金额
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param pageVo
	 * @param isRefund
	 * @param infoVo
	 * @return
	 **/
	private void handleRefundMoney(PaymentBusinessPageVo pageVo, boolean isRefund, TPaymentInfoVo infoVo) {
		if (isRefund){
			pageVo.setPersonalRefund(BigDecimalUtils.safeAdd(pageVo.getPersonalRefund(),
					infoVo.getPersonalPensionMoney(),
					infoVo.getPersonalMedicalMoney(),
					infoVo.getPersonalUnemploymentMoney(),
					infoVo.getPersonalBigmailmentMoney(),
					infoVo.getPersonalProvidentSum()));
			pageVo.setUnitRefund(BigDecimalUtils.safeAdd(pageVo.getUnitRefund(),
					infoVo.getUnitPensionMoney(),
					infoVo.getUnitMedicalMoney(),
					infoVo.getUnitInjuryMoney(),
					infoVo.getUnitBirthMoney(),
					infoVo.getUnitUnemploymentMoney(),
					infoVo.getUnitBigmailmentMoney(),
					infoVo.getUnitProvidentSum()));
		}
	}

	/**
	 * 处理兼职工伤金额
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param pageVo
	 * @param isRefund
	 * @param isInjury
	 * @param infoVo
	 * @return
	 **/
	private void handleSocialAndInjuryMoney(PaymentBusinessPageVo pageVo, boolean isRefund, boolean isInjury, TPaymentInfoVo infoVo) {
		if (isInjury){
			pageVo.setInjuryAloneSet(infoVo.getUnitInjurySet());
			pageVo.setInjuryAloneMoney(BigDecimalUtils.safeAdd(pageVo.getInjuryAloneMoney(),infoVo.getUnitInjuryMoney()));
			pageVo.setInjuryAlonePer(infoVo.getUnitInjuryPer());
		}
		// 处理公积金
		if (null != infoVo.getProvidentPercent()){
			pageVo.setProvidentPercent(infoVo.getProvidentPercent());
		}
		if (null != infoVo.getUnitProvidentSet()){
			pageVo.setPersonalProidentSet(infoVo.getUnitProvidentSet());
			pageVo.setUnitProvidentSet(infoVo.getUnitProvidentSet());
		}
		// 处理非兼职工伤非退费数据
		if (!isInjury && !isRefund){
			pageVo.setPersonalPensionMoney(BigDecimalUtils.safeAdd(pageVo.getPersonalPensionMoney(),infoVo.getPersonalPensionMoney()));
			pageVo.setPersonalMedicalMoney(BigDecimalUtils.safeAdd(pageVo.getPersonalMedicalMoney(),infoVo.getPersonalMedicalMoney()));
			pageVo.setPersonalUnemploymentMoney(BigDecimalUtils.safeAdd(pageVo.getPersonalUnemploymentMoney(),infoVo.getPersonalUnemploymentMoney()));
			pageVo.setPersonalBigmailmentMoney(BigDecimalUtils.safeAdd(pageVo.getPersonalBigmailmentMoney(),infoVo.getPersonalBigmailmentMoney()));
			pageVo.setUnitPensionMoney(BigDecimalUtils.safeAdd(pageVo.getUnitPensionMoney(),infoVo.getUnitPensionMoney()));
			pageVo.setUnitMedicalMoney(BigDecimalUtils.safeAdd(pageVo.getUnitMedicalMoney(),infoVo.getUnitMedicalMoney()));
			pageVo.setUnitInjuryMoney(BigDecimalUtils.safeAdd(pageVo.getUnitInjuryMoney(),infoVo.getUnitInjuryMoney()));
			pageVo.setUnitBirthMoney(BigDecimalUtils.safeAdd(pageVo.getUnitBirthMoney(),infoVo.getUnitBirthMoney()));
			pageVo.setUnitUnemploymentMoney(BigDecimalUtils.safeAdd(pageVo.getUnitUnemploymentMoney(),infoVo.getUnitUnemploymentMoney()));
			pageVo.setUnitBigmailmentMoney(BigDecimalUtils.safeAdd(pageVo.getUnitBigmailmentMoney(),infoVo.getUnitBigmailmentMoney()));

		}
	}

	/**
	 * 合计缴费库对应数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param pageVo
	 * @param infoVo
	 * @return
	 **/
	private void initPaymentSum(PaymentBusinessPageVo pageVo,boolean isRefund, TPaymentInfoVo infoVo) {
		if (!isRefund){
			pageVo.setFundPersonalSum(BigDecimalUtils.safeAdd(pageVo.getFundPersonalSum(), infoVo.getPersonalProvidentSum()));
			pageVo.setFundUnitSum(BigDecimalUtils.safeAdd(pageVo.getFundUnitSum(), infoVo.getUnitProvidentSum()));
		}
		pageVo.setCompanyAccrual(BigDecimalUtils.safeAdd(pageVo.getCompanyAccrual(), infoVo.getCompanyAccrual()));
		pageVo.setPersonalAccrual(BigDecimalUtils.safeAdd(pageVo.getPersonalAccrual(), infoVo.getPersonalAccrual()));
		pageVo.setSocialUnitSum(BigDecimalUtils.safeAdd(pageVo.getSocialUnitSum(),
				infoVo.getUnitPensionMoney(),
				infoVo.getUnitMedicalMoney(),
				infoVo.getUnitInjuryMoney(),
				infoVo.getUnitBirthMoney(),
				infoVo.getUnitUnemploymentMoney(),
				infoVo.getUnitBigmailmentMoney()));
		pageVo.setSocialPersonalSum(BigDecimalUtils.safeAdd(pageVo.getSocialPersonalSum(),
				infoVo.getPersonalPensionMoney(),
				infoVo.getPersonalMedicalMoney(),
				infoVo.getPersonalUnemploymentMoney(),
				infoVo.getPersonalBigmailmentMoney()));
		pageVo.setSum(BigDecimalUtils.safeAdd(pageVo.getSum(),infoVo.getCompanyAccrual(),
				infoVo.getPersonalAccrual(),
				infoVo.getPersonalProvidentSum(),
				infoVo.getUnitProvidentSum(),
				infoVo.getSocialSecurityPersonalSum(),
				infoVo.getUnitSocialSum()));
	}

	/**
	 * B端社保公积金列表查询
	 * @Author fxj
	 * @Date 2020-08-28
	 * @param page
	 * @param socialAndFundBusinessPageVo
	 * @param settleDomainIds
	 * @return
	 **/
	@Override
	public List<SocialAndFundBusinessPageVo> getSocialAndFundBusinessPage(Page<SocialAndFundBusinessPageVo> page, SocialAndFundBusinessPageVo socialAndFundBusinessPageVo, List<String> settleDomainIds) {
		List<SocialAndFundBusinessPageVo> pageVo = baseMapper.getSocialAndFundBusinessDataPage(socialAndFundBusinessPageVo, settleDomainIds);
		List<SocialAndFundBusinessPageVo> pageVosEmpCount = baseMapper.getSocialAndFundBusinessDataCount(socialAndFundBusinessPageVo, settleDomainIds);
		if (Common.isNotNull(pageVo) && Common.isNotNull(pageVosEmpCount)){
			HashMap<String ,Integer> monthPeopleCount = new HashMap<>();
			for (SocialAndFundBusinessPageVo vo:pageVosEmpCount){
				monthPeopleCount.put(vo.getMonth(),vo.getPeopleCount());
			}
			for (SocialAndFundBusinessPageVo vo:pageVo){
				vo.setPeopleCount(monthPeopleCount.get(vo.getMonth()));
			}
		}
		return pageVo;
	}
	/**
	 * 按月查询对应权限的缴费库数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param page
	 * @param paymentBusinessPageVo
	 * @param type
	 * @return
	 **/
	@Override
	public IPage<PaymentBusinessPageVo> getPaymentByMonthAndAuth(Page<PaymentBusinessPageVo> page, PaymentBusinessPageVo paymentBusinessPageVo, List<String> settleDomainIds, String type) {
		List<String>  empIds = null;
		if (CommonConstants.ONE_STRING.equals(type)) {
			empIds = baseMapper.getSocialOrFundAddEmpIds(paymentBusinessPageVo.getMonth(),paymentBusinessPageVo.getSettleDomainId(),settleDomainIds);
			if (empIds.isEmpty()) {
				return page;
			}
		}
		IPage<PaymentBusinessPageVo> pageVo = baseMapper.getPaymentBusinessPageVo(page,paymentBusinessPageVo,settleDomainIds,empIds);
		List<PaymentBusinessPageVo> pageVos = pageVo.getRecords();
		if (Common.isNotNull(pageVos)){
			for (PaymentBusinessPageVo vo:pageVos){
				vo.setSum(BigDecimalUtils.safeAdd(vo.getUnitSum(),vo.getPersonalSum()));
			}
		}
		page.setRecords(pageVos);
		return page;
	}
	/**
	 * 按年月查询指定结算主体或权限内的缴费库数据统计
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param month
	 * @param settleDomainId
	 * @return
	 **/
	@Override
	public PaymentBusinessPageDetail getPaymentBusinessPageDetailByMonthAndAuth(String month, String settleDomainId, List<String> settleDomainIds) {
		PaymentBusinessPageDetail detail = new PaymentBusinessPageDetail();
		// 1.派增办理成功的社保和公积金人数
		detail.setPersonalCount(baseMapper.getSocialOrFundAddCount(month,settleDomainId,settleDomainIds,CommonConstants.ZERO_INT));
		// 2.当月派增办理成功的社保和公积金人数
		detail.setPersonalAdd(baseMapper.getSocialOrFundAddCount(month,settleDomainId,settleDomainIds, CommonConstants.ONE_INT));
		// 3.当月派减办理成功的社保和公积金人数
		detail.setPersonalReduce(baseMapper.getSocialOrFundReduceCount(month,settleDomainId,settleDomainIds));
		return detail;
	}

	/**
	 * 查询派减的社保和公积金的分页数据
	 * @Author fxj
	 * @Date 2020-08-31
	 * @param page
	 * @param month
	 * @param settleDomainId
	 * @return
	 **/
	@Override
	public IPage<SocialAndFundReduceBusinessVo> getSocialAndFundReduceInfo(Page<SocialAndFundReduceBusinessVo> page, String month, String settleDomainId, List<String> settleDomainIds) {
		IPage<SocialAndFundReduceBusinessVo> pageVos = baseMapper.getSocialAndFundReduceInfo(page,month,settleDomainId,settleDomainIds);
		if (null != pageVos && Common.isNotNull(pageVos.getRecords())){
			for (SocialAndFundReduceBusinessVo vo:pageVos.getRecords()){
				initReduceBusinessData(vo);
			}
		}
		return pageVos;
	}

	private void initReduceBusinessData(SocialAndFundReduceBusinessVo vo) {
		int index;
		if (Common.isNotNull(vo.getLeaveDate())){
			index = vo.getLeaveDate().indexOf(CommonConstants.COMMA_CHAR);
			if (index > 0){
				vo.setLeaveDate(vo.getLeaveDate().substring(CommonConstants.ZERO_INT,index));
			}
		}
		if (Common.isNotNull(vo.getSocialReduceDate())){
			index = vo.getSocialReduceDate().indexOf(CommonConstants.COMMA_CHAR);
			if (index > 0){
				vo.setSocialReduceDate(vo.getSocialReduceDate().substring(CommonConstants.ZERO_INT,index));
			}
		}
		if (Common.isNotNull(vo.getFundReduceDate())){
			index = vo.getFundReduceDate().indexOf(CommonConstants.COMMA_CHAR);
			if (index > 0){
				vo.setFundReduceDate(vo.getFundReduceDate().substring(CommonConstants.ZERO_INT,index));
			}
		}
	}
	// hgw2023-1-6 10:44:31以上，B端相关

	//项目信息校验
	private String settleInfoCheck(TPaymentInfo payExists) {
		StringBuilder errorInfo = new StringBuilder();
		if (Common.isEmpty(payExists.getSettleDomainName())) {
			errorInfo.append("项目名称、");
		}
		if (Common.isEmpty(payExists.getSettleDomainCode())) {
			errorInfo.append("项目编码、");
		}
		if (Common.isEmpty(payExists.getBpoFlag())) {
			errorInfo.append("是否BPO、");
		}
		if (errorInfo.toString().isEmpty()) {
			return null;
		}else {
			return errorInfo.substring(0,errorInfo.length() - 1);
		}
	}
}
