/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * <p>
 * 用户表
 * </p>
 *
 * @author lengleng
 * @since 2019/2/1
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SysUser extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
	@TableId(value = "user_id", type = IdType.ASSIGN_ID)
	@Schema(description = "主键id")
	private String userId;

	/**
	 * 用户名    登录名称
	 */
	@Schema(title = "用户名")
	private String username;

	/**
	 * 用户名称
	 */
	@Schema(title = "用户名称")
	private String nickname;

	/**
	 * 密码
	 */
	@Schema(description = "密码")
	private String password;

	/**
	 * 随机盐
	 */
	@JsonIgnore
	@Schema(description = "随机盐")
	private String salt;

	/**
	 * 锁定标记
	 */
	@Schema(description = "锁定标记")
	private String lockFlag;

	/**
	 * 手机号
	 */
	@Schema(description = "手机号")
	private String phone;

	/**
	 * 头像
	 */
	@Schema(description = "头像地址")
	private String avatar;

	/**
	 * 部门ID
	 */
	@Schema(description = "用户所属部门id")
	private Long deptId;

	/**
	 * 部门名称
	 */
	@Schema(description = "部门名称")
	private String deptName;

	/**
	 * 用户分组
	 */
	@NotNull(message = "用户分组不能为空")
	@Schema(description = "用户分组")
	private String userGroup;

	/**
	 * 职务
	 */
	@Schema(description = "职务")
	private String post;

	/**
	 * 邮箱
	 */
	@NotNull(message = "邮箱不能为空")
	@Schema(description = "邮箱")
	private String email;

	@Schema(description = "是否是系统内置")
	private String systemFlag;

	/**
	 * 0-正常，1-删除
	 */
	@TableLogic
	private String delFlag;

	/**
	 * 微信公众号的openid(工资条使用）
	 */
	private String wxOpenid;

	/**
	 *  LDAP_DN
	 */
	@TableField(exist = false)
	@Schema(description = "LDAP_DN")
	private String ldapDn;

	/**
	 * @Author fxj
	 * @Description  0 系统用户 1 LDAP用户 2 B端用户 3.微信用户  默认系统用户
	 * @Date 14:56 2023/1/6
	**/
	private String type;

}
