/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 法大大专业版推送日志表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Data
@TableName("t_fasc_push_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大专业版推送日志表")
public class TFascPushLog extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 业务参考号
	 */
	@ExcelAttribute(name = "业务参考号", isNotEmpty = true, errorInfo = "业务参考号不能为空", maxLength = 32)
	@NotBlank(message = "业务参考号不能为空")
	@Length(max = 32, message = "业务参考号不能超过32个字符")
	@ExcelProperty("业务参考号")
	@Schema(description = "业务参考号")
	private String transReferenceId;
	/**
	 * 返回的任务ID
	 */
	@ExcelAttribute(name = "返回的任务ID", maxLength = 32)
	@Length(max = 32, message = "返回的任务ID不能超过32个字符")
	@ExcelProperty("返回的任务ID")
	@Schema(description = "返回的任务ID")
	private String signTaskId;
	/**
	 * 推送信息
	 */
	@ExcelAttribute(name = "推送信息")
	@ExcelProperty("推送信息")
	@Schema(description = "推送信息")
	private String pushData;
	/**
	 * 返回信息
	 */
	@ExcelAttribute(name = "返回信息")
	@ExcelProperty("返回信息")
	@Schema(description = "返回信息")
	private String returnData;
	/**
	 * 合同ID
	 */
	@ExcelAttribute(name = "合同ID", maxLength = 32)
	@Length(max = 32, message = "合同ID不能超过32个字符")
	@ExcelProperty("合同ID")
	@Schema(description = "合同ID")
	private String contractId;
	/**
	 * 任务状态0推送中1成功2失败
	 */
	@ExcelAttribute(name = "任务状态0推送中1成功2失败", maxLength = 2)
	@Length(max = 2, message = "任务状态0推送中1成功2失败不能超过2个字符")
	@ExcelProperty("任务状态0推送中1成功2失败")
	@Schema(description = "任务状态0推送中1成功2失败")
	private String taskStatus;
	/**
	 * 查询关键字
	 */
	@ExcelAttribute(name = "查询关键字", maxLength = 50)
	@Length(max = 50, message = "查询关键字不能超过50个字符")
	@ExcelProperty("查询关键字")
	@Schema(description = "查询关键字")
	private String typeKey;
	/**
	 * 类型
	 */
	@ExcelAttribute(name = "类型", maxLength = 20)
	@Length(max = 20, message = "类型不能超过20个字符")
	@ExcelProperty("类型")
	@Schema(description = "类型")
	private String typeName;

}
