/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.archives.entity.LGuaziOfferRecord;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 瓜子offer操作日志
 *
 * @author chenyx
 * @date 2025-06-11 15:59:04
 */
@Data
public class LGuaziOfferRecordVo extends LGuaziOfferRecord {

	/**
	 * offerId集合
	 */
	private List<Integer> offerIds;

	/**
	 * 发送短信结果：0成功，1失败
	 */
	private String sendSmsRes;

	/**
	 * offer信息变更：
	 * key：变更字段中文名
	 * value：变更前后的值(数组0：变更前，1：变更后)
	 */
	private Map<String,List<String>> changeInfoMap;

	/**
	 * 状态变更：
	 * 变更前后的名称(数组0：变更前，1：变更后)
	 */
	private List<String> changeStatusList;


}
