package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationUpdateVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprCspProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @Author fxj
 * @Description 客户服务平台 服务间调用工具类
 * @Date 11:57 2025/2/25
 * @Param
 * @return
**/
@Log4j2
@EnableConfigurationProperties(DaprCspProperties.class)
public class CspDaprUtils {

	@Autowired
	private DaprCspProperties daprCspProperties;

	/**
	 * @Author huyc
	 * @Description 更新入离职登记的状态和新增操作记录
	 * @Date 9:22 2025/3/17
	 * @Param
	 * @return
	 **/
	public R<Boolean> updateRegistByPreInfo(EmployeeRegistrationUpdateVo updateVo) {
		return HttpDaprUtil.invokeMethodPost(daprCspProperties.getAppUrl(),daprCspProperties.getAppId(),"/employeeregistration/inner/updateRegistByPreInfo", JSON.toJSONString(updateVo), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 更新入离职登记前端客服姓名
	 * @Date 10:15 2025/3/24
	 * @Param
	 * @return
	 **/
	public R<Boolean> updateRegistCustomerUserInfo(EmployeeRegistrationCustomerUserUpdateVo updateVo) {
		return HttpDaprUtil.invokeMethodPost(daprCspProperties.getAppUrl(),daprCspProperties.getAppId(),"/employeeregistration/inner/updateRegistCustomerUserInfo", JSON.toJSONString(updateVo), Boolean.class, SecurityConstants.FROM_IN);
	}
}
