package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractAreaResSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TMinSalary;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TMinSalaryExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TMinSalaryImportParam;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TMinSalaryImportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TMinSalarySearchVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Description 各地市最低工资标准
 * @Date 13:13 2022/8/6
 * @Param
 * @return
**/
public interface TMinSalaryService extends IService<TMinSalary> {

  /**
   * 各地市最低工资标准简单分页查询
   * @param tMinSalary 各地市最低工资标准
   * @return
   */
  IPage<TMinSalary> getTMinSalaryPage(Page<TMinSalary> page, TMinSalarySearchVo tMinSalary);


    R<Boolean> saveDiy(TMinSalary tMinSalary);

	R<Boolean> updateByIdDIy(TMinSalary tMinSalary);

	/**
	 * 最低工资批量更新
	 *
	 * @author wzb
	 * @param inputStream
	 * @return {@link R}
	 */
	R importList(InputStream inputStream);

	/**
	 * 最低工资导出
	 *
	 * @author wzb
	 * @param tMinSalary
	 * @return {@link List< TMinSalaryExportVo>}
	 */
	 List<TMinSalaryExportVo>  exportList( TMinSalarySearchVo tMinSalary);



}
