package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TAverageSalary;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TAverageSalaryMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TAverageSalaryService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TAverageSalaryVo;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author hgw
 * @Description 前12月平均工资（MVP-TDC接口）
 * @Date 2023-6-19 16:25:16
 **/
@Service("tAverageSalaryService")
public class TAverageSalaryServiceImpl extends ServiceImpl<TAverageSalaryMapper, TAverageSalary> implements TAverageSalaryService {

	/**
	 * @Description: 删除本月与上上月数据，生成本月数据
	 * @Author: hgw
	 * @Date: 2023/6/19 16:32
	 * @return: void
	 **/
	@Override
	public void createAverageSalary() {
		baseMapper.deleteByCreateMonth();
		baseMapper.insertAverageSalary();
	}

	/**
	 * @return
	 * @Author fxj
	 * @Description 获取-前12月平均工资数据
	 * @Date 10:25 2023/6/20
	 * @Param
	 **/
	@Override
	public R<List<TAverageSalaryVo>> getAverageSalary(String idNum) {
		return R.ok(baseMapper.getAverageSalary(Common.getList(idNum)), CommonConstants.RESULT_DATA_SUCESS);
	}

}




