package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysPayProportion;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author fxj
 * @Date 2025/11/14
 * @Description
 * @Version 1.0
 */
@Data
public class SysBaseSetFundInsertVo extends RowIndex implements Serializable {

	/**
	 * 公积金户
	 */
	@ExcelAttribute(name = "公积金户",isNotEmpty = true)
	@Schema(description = "公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String departName;

	/**
	 * 公积金缴纳地：安徽省-合肥市-肥东县
	 */
	@ExcelAttribute(name = "公积金缴纳地",isNotEmpty = true)
	@Schema(description = "公积金缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地")
	private String provinceStr;

	/**
	 * 公积金类型 0.市直  1. 省直
	 */
	@ExcelAttribute(name = "公积金类型",isNotEmpty = true,readConverterExp = "0=市直,1=省直")
	@Schema(description = "公积金类型 0.市直  1. 省直")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金类型")
	private String fundPayType;

	/**
	 * 适用起始月份
	 */
	@ExcelAttribute(name = "适用起始月份",isNotEmpty = true)
	@Schema(description = "适用起始月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("适用起始月份")
	private String applyStartDate;

	/**
	 * 执行月份
	 */
	@ExcelAttribute(name = "执行月份",isNotEmpty = true)
	@Schema(description = "执行月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("执行月份")
	private String doMonth;

	/**
	 * 基数上限
	 */
	@ExcelAttribute(name = "基数上限",isNotEmpty = true)
	@Schema(description = "基数上限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("基数上限")
	private BigDecimal upperLimit;

	/**
	 * 基数下限
	 */
	@ExcelAttribute(name = "基数下限",isNotEmpty = true)
	@Schema(description = "基数下限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("基数下限")
	private BigDecimal lowerLimit;

	/**
	 * 单边小数点：1：四舍五入取整 2：元以下舍去 3：见角进元 4：保留两位小数  5：保留一位小数 6:见分进元
	 */
	@ExcelAttribute(name = "单边小数点",isDataId = true,dataType = ExcelAttributeConstants.FUND_POINT_TYPE,isNotEmpty = true,readConverterExp = "1=四舍五入取整,2=元以下舍去,3=见角进元,4=保留两位小数,5=保留一位小数,6=见分进元")
	@Schema(description = "单边小数点")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单边小数点")
	private String fundPayPoint;

	/**
	 * 单位公积金比例，个人公积金比例:10,10;12,13
	 */
	@ExcelAttribute(name = "单位公积金比例，个人公积金比例",isNotEmpty = true)
	@Schema(description = "单位公积金比例，个人公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例，个人公积金比例")
	private String housingFundPro;

	/**
	 * 是否可以补缴： 0：是，1：否
	 */
	@ExcelAttribute(name = "是否可补缴",isNotEmpty = true,readConverterExp = "0=是,1=否")
	@Schema(description = "是否可补缴： 0：是，1：否")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否可补缴")
	private String canOverpay;

	/**
	 * 最大补缴期限:1:一月、2:二月 ...... 12:十二月
	 */
	@ExcelAttribute(name = "最大补缴期限",isDataId = true,dataType = ExcelAttributeConstants.SOCIAL_OVERPAY_MOTH,readConverterExp = "1=一个月,2=二个月,3=三个月,4=四个月,5=五个月,6=六个月,7=七个月,8=八个月,9=九个月,10=十个月,11=十一个月,12=十二个月")
	@Schema(description = "最大补缴期限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最大补缴期限")
	private String overpayNumber;

	/**
	 * 是否含起缴当月： 0：是，1：否
	 */
	@ExcelAttribute(name = "是否含起缴当月",readConverterExp = "0=是,1=否")
	@Schema(description = "是否含起缴当月： 0：是，1：否")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否含起缴当月")
	private String haveThisMonth;

	/**
	 * 补缴基数:0:最新基数、1：当期基数
	 */
	@ExcelAttribute(name = "补缴基数",readConverterExp = "0=最新基数,1=当期基数")
	@Schema(description = "补缴基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴基数")
	private String insuranceIsLatestCardinality;

	/**
	 * 补缴政策
	 */
	@ExcelAttribute(name = "补缴政策")
	@Schema(description = "补缴政策")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴政策")
	private String payPolicy;


}
