/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 瓜子紧急联系人
 *
 * @author chenyx
 * @date 2025-06-13 15:19:04
 */
@Data
@TableName("t_gz_emp_contact_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子紧急联系人")
public class TGzEmpContactInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 关联瓜子档案ID
	 */
	@ExcelAttribute(name = "关联瓜子档案ID", isNotEmpty = true, errorInfo = "关联瓜子档案ID不能为空", maxLength = 32)
	@NotBlank(message = "关联瓜子档案ID不能为空")
	@Length(max = 32, message = "关联瓜子档案ID不能超过32个字符")
	@ExcelProperty("关联瓜子档案ID")
	@Schema(description = "关联瓜子档案ID")
	private String empId;
	/**
	 * 紧急联系人姓名
	 */
	@ExcelAttribute(name = "紧急联系人姓名", maxLength = 20)
	@Length(max = 20, message = "紧急联系人姓名不能超过20个字符")
	@ExcelProperty("紧急联系人姓名")
	@Schema(description = "紧急联系人姓名")
	private String emergName;
	/**
	 * 与本人关系
	 */
	@ExcelAttribute(name = "与本人关系", maxLength = 50)
	@Length(max = 50, message = "与本人关系不能超过50个字符")
	@ExcelProperty("与本人关系")
	@Schema(description = "与本人关系")
	private String emergRelation;
	/**
	 * 联系人住址
	 */
	@ExcelAttribute(name = "联系人住址", maxLength = 200)
	@Length(max = 200, message = "联系人住址不能超过200个字符")
	@ExcelProperty("联系人住址")
	@Schema(description = "联系人住址")
	private String emergAddress;
	/**
	 * 联系电话
	 */
	@ExcelAttribute(name = "联系电话", maxLength = 20)
	@Length(max = 20, message = "联系电话不能超过20个字符")
	@ExcelProperty("联系电话")
	@Schema(description = "联系电话")
	private String emergPhone;
	/**
	 * 是否主要联系人: Y：是，N不是(系统自动推送默认值“是”)
	 */
	@ExcelAttribute(name = "是否主要联系人: Y：是，N不是(系统自动推送默认值“是”)", maxLength = 1)
	@Length(max = 1, message = "是否主要联系人: Y：是，N不是(系统自动推送默认值“是”)不能超过1个字符")
	@ExcelProperty("是否主要联系人: Y：是，N不是(系统自动推送默认值“是”)")
	@Schema(description = "是否主要联系人: Y：是，N不是(系统自动推送默认值“是”)")
	private String primaryNid;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

}
