package com.yifu.cloud.plus.v1.business.mapper.system;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarningEmployee;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * B端短信发送记录表
 *
 * @author hgw
 * @date 2021-08-23 16:27:34
 */
@Mapper
public interface TBusWarningEmployeeMapper extends BaseMapper<TBusWarningEmployee> {
     /**
      * B端短信发送记录表简单分页查询
      *
      * @param tBusWarningEmployee B端短信发送记录表
      * @return
      */
     IPage<TBusWarningEmployee> getTBusWarningEmployeePage(Page<TBusWarningEmployee> page, @Param("tBusWarningEmployee") TBusWarningEmployee tBusWarningEmployee);

     int saveNewEmployee(@Param("se") TBusWarningEmployee se);

     /**
      * 获取指定日期的发送的短信
      * @Author fxj
      * @Date 2021-05-11
      * @param dateStr
      * @return
      **/
     List<TBusWarningEmployee> getTBusWarningEmployeeListToday(@Param("dateStr") String dateStr);

     List<TBusWarningEmployee> getByBizId(@Param("bizId") String bizId);

     int updateSendStatusByBizId(@Param("sendStatus")String sendStatus,@Param("updateStatus")String updateStatus,@Param("bizId")String bizId);

     /**
      * @param newBizId
      * @param oldBizId
      * @Description: 更新
      * @Author: hgw
      * @Date: 2021/5/10 14:54
      * @return: int
      **/
     int updateBizIdByBizId(@Param("newBizId") String newBizId, @Param("oldBizId") String oldBizId);

     /**
      * @param warningId
      * @param userId
      * @param bizId
      * @Description: 复审到期日
      * @Author: hgw
      * @Date: 2021/8/24 17:51
      * @return: int
      **/
     int insertByReviewDate(@Param("warningId") String warningId, @Param("userId") Integer userId, @Param("bizId") String bizId, @Param("days") Integer days);

     /**
      * @param warningId
      * @param userId
      * @param bizId
      * @Description: 证件到期日
      * @Author: hgw
      * @Date: 2021/8/24 17:51
      * @return: int
      **/
     int insertByTermValidityEnd(@Param("warningId") String warningId, @Param("userId") Integer userId, @Param("bizId") String bizId, @Param("days") Integer days);

     /**
      * @param warningId
      * @param userId
      * @param bizId
      * @Description: 年假未休时长
      * @Author: hgw
      * @Date: 2021/8/24 17:51
      * @return: int
      **/
     int insertByYearVacation(@Param("warningId") String warningId, @Param("userId") Integer userId, @Param("bizId") String bizId);

     /**
      * @Description: 获取假期结束人员姓名
      * @Author: hgw
      * @Date: 2021/8/25 13:13
      * @return: java.lang.String
      **/
     String getVacationInfoEmpName();

	 String getVacationEmpName();

}
