/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 员工合同签订配置方案子表
 *
 * @author fxj
 * @date 2025-06-10 16:24:30
 */
@Data
@TableName("t_auto_contract_scheme")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工合同签订配置方案子表")
public class TAutoContractScheme extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 配置名称
	 */
	@ExcelAttribute(name = "配置名称", isNotEmpty = true, errorInfo = "配置名称不能为空", maxLength = 50)
	@NotBlank(message = "配置名称不能为空")
	@Length(max = 50, message = "配置名称不能超过50个字符")
	@ExcelProperty("配置名称")
	@Schema(description = "配置名称")
	private String configName;
	/**
	 * 是否允许修改 0是 1否
	 */
	@ExcelAttribute(name = "是否允许修改", isNotEmpty = true, errorInfo = "是否允许修改不能为空")
	@NotBlank(message = "是否允许修改不能为空")
	@ExcelProperty("是否允许修改")
	@Schema(description = "是否允许修改 0是 1否")
	private String updateFlag;
	/**
	 * 合同类型  线下签：同合同申请的合同类型
	 * // 电子签-合同类型（既有字典）
	 * export const contractTypeOpts = [
	 *     { label: '标准合同', value: '1'},
	 *     { label: '劳务协议', value: '3'},
	 *     { label: '实习协议', value: '5'},
	 *     { label: '劳务派遣合同', value: '20'},
	 *     { label: '非全日制', value: '8'},
	 * ];
	 */
	@ExcelAttribute(name = "合同类型", isNotEmpty = true, errorInfo = "合同类型不能为空", maxLength = 2, dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	@NotBlank(message = "合同类型不能为空")
	@Length(max = 1, message = "合同类型不能超过2个字符")
	@ExcelProperty("合同类型")
	@Schema(description = "合同类型  电子签：0标准合同/1劳务协议/2实习协议/3劳务派遣合同/4非全日制/5其他合同 线下签：同合同申请的合同类型")
	private String contractType;
	/**
	 * 签署甲方
	 */
	@ExcelAttribute(name = "签署甲方", isNotEmpty = true, errorInfo = "签署甲方不能为空",  maxLength = 50)
	@ExcelProperty("签署甲方")
	@Schema(description = "签署甲方")
	private String signatory;
	/**
	 * 发大大电子签模板
	 */
	@ExcelAttribute(name = "发大大电子签模板", maxLength = 50)
	@ExcelProperty("发大大电子签模板")
	@Schema(description = "发大大电子签模板")
	private String fadadaTemplate;
	/**
	 * 发大大电子签模板ID
	 */
	@ExcelAttribute(name = "发大大电子签模板ID", maxLength = 50)
	@ExcelProperty("发大大电子签模板ID")
	@Schema(description = "发大大电子签模板ID")
	private String fadadaTemplateId;
	/**
	 * 签订期限 0 固定期限 1 无固定期限 3.以完成一定工作任务为期限
	 * // 电子签-签订期限（既有字典）
	 * export const contractTermOpts = [
	 *     { label: '固定期限', value: '1'},
	 *     { label: '无固定期限', value: '2'},
	 *     { label: '以完成一定工作任务为期限', value: '0'},
	 * ]
	 */
	@ExcelAttribute(name = "签订期限")
	@ExcelProperty("签订期限")
	@Schema(description = "签订期限 0 固定期限 1 无固定期限 3.以完成一定工作任务为期限")
	private String contractTerm;
	/**
	 * 合同年限-年
	 * // 合同年限-年
	 * export const contractDurationYearOpts = [
	 *     { label: '1年', value: '1'},
	 *     { label: '2年', value: '2'},
	 *     { label: '3年', value: '3'},
	 *     { label: '4年', value: '4'},
	 *     { label: '5年', value: '5'},
	 *     { label: '6年', value: '6'},
	 *     { label: '7年', value: '7'},
	 *     { label: '8年', value: '8'},
	 *     { label: '9年', value: '9'},
	 *     { label: '10年', value: '10'},
	 * ];
	 */
	@ExcelAttribute(name = "合同年限-年", maxLength = 50)
	@Length(max = 50, message = "合同年限-年不能超过50个字符")
	@ExcelProperty("合同年限-年")
	@Schema(description = "合同年限-年")
	private String contractDurationYear;
	/**
	 * 合同年限-月
	 * // 合同年限-月
	 * export const contractDurationMonthOpts = [
	 *     { label: '1个月', value: '1'},
	 *     { label: '2个月', value: '2'},
	 *     { label: '3个月', value: '3'},
	 *     { label: '4个月', value: '4'},
	 *     { label: '5个月', value: '5'},
	 *     { label: '6个月', value: '6'},
	 *     { label: '7个月', value: '7'},
	 *     { label: '8个月', value: '8'},
	 *     { label: '9个月', value: '9'},
	 *     { label: '10个月', value: '10'},
	 *     { label: '11个月', value: '11'},
	 *     { label: '12个月', value: '12'}
	 *
	 * ];
	 */
	@ExcelAttribute(name = "合同年限-月", maxLength = 50)
	@Length(max = 50, message = "合同年限-月不能超过50个字符")
	@ExcelProperty("合同年限-月")
	@Schema(description = "合同年限-月")
	private String contractDurationMonth;
	/**
	 * 合同开始日期
	 *
	 * export const contractStartOpts = [
	 *     { label: '入职日期', value: '0'},
	 * ];
	 */
	@ExcelAttribute(name = "合同开始日期")
	@ExcelProperty("合同开始日期")
	@Schema(description = "合同开始日期")
	private String contractStart;
	/**
	 * 合同截止日期
	 *
	 * export const contractEndOpts = [
	 *     { label: '合同年限推算', value: '0'},
	 *     { label: '同商务合同一致', value: '1'},
	 *     { label: '工作任务完成时止', value: '1'}
	 * ];
	 */
	@ExcelAttribute(name = "合同截止日期")
	@ExcelProperty("合同截止日期")
	@Schema(description = "合同截止日期")
	private String contractEnd;
	/**
	 * 是否有试用期 0是1否
	 */
	@ExcelAttribute(name = "是否有试用期")
	@ExcelProperty("是否有试用期")
	@Schema(description = "是否有试用期 0是1否")
	private String tryPeriodType;
	/**
	 * 试用周期
	 * export const tryPeriodOpts = [
	 *     { label: '无', value: '0'},
	 *     { label: '1个月', value: '1'},
	 *     { label: '2个月', value: '2'},
	 *     { label: '3个月', value: '3'},
	 *     { label: '4个月', value: '4'},
	 *     { label: '5个月', value: '5'},
	 *     { label: '6个月', value: '6'},
	 *     { label: '7个月', value: '7'},
	 *     { label: '8个月', value: '8'},
	 *     { label: '9个月', value: '9'},
	 *     { label: '10个月', value: '10'},
	 *     { label: '11个月', value: '11'},
	 *     { label: '12个月', value: '12'}
	 * ];
	 */
	@ExcelAttribute(name = "试用周期")
	@ExcelProperty("试用周期")
	@Schema(description = "试用周期")
	private String tryPeriod;
	/**
	 * 试用开始日期
	 * export const tryPeriodStartOpts = [
	 *     { label: '入职日期', value: '0'},
	 * ];
	 */
	@ExcelAttribute(name = "试用开始日期")
	@ExcelProperty("试用开始日期")
	@Schema(description = "试用开始日期")
	private String tryPeriodStart;
	/**
	 * 试用截止日期
	 * export const tryPeriodEndOpts = [
	 *     { label: '根据试用周期自动计算', value: '0'}
	 * ];
	 */
	@ExcelAttribute(name = "试用截止日期")
	@ExcelProperty("试用截止日期")
	@Schema(description = "试用截止日期")
	private String tryPeriodEnd;
	/**
	 * 工作任务
	 */
	@ExcelAttribute(name = "工作任务", maxLength = 200)
	@Length(max = 200, message = "工作任务不能超过200个字符")
	@ExcelProperty("工作任务")
	@Schema(description = "工作任务")
	private String task;
	/**
	 * 任务类型： 0 不同员工不同任务自定义 1 所有员工任务相同
	 */
	@ExcelAttribute(name = "任务类型")
	@ExcelProperty("任务类型")
	@Schema(description = "任务类型： 0 不同员工不同任务自定义 1 所有员工任务相同")
	private String taskType;
	/**
	 * 结束任务标准
	 */
	@ExcelAttribute(name = "结束任务标准", maxLength = 200)
	@Length(max = 200, message = "结束任务标准不能超过200个字符")
	@ExcelProperty("结束任务标准")
	@Schema(description = "结束任务标准")
	private String taskEndStandard;
	/**
	 * 项目配置主表ID
	 */
	@ExcelAttribute(name = "项目配置主表ID",  errorInfo = "项目配置主表ID不能为空", maxLength = 32)
	@NotBlank(message = "项目配置主表ID不能为空")
	@Length(max = 32, message = "项目配置主表ID不能超过32个字符")
	@ExcelProperty("项目配置主表ID")
	@Schema(description = "项目配置主表ID")
	private String mainId;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码",  errorInfo = "项目编码不能为空", maxLength = 50)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@ExcelAttribute(name = "项目ID",  errorInfo = "项目ID不能为空", maxLength = 32)
	@NotBlank(message = "项目ID不能为空")
	@Length(max = 32, message = "项目ID不能超过32个字符")
	@ExcelProperty("项目ID")
	@Schema(description = "项目ID")
	private String deptId;
	/**
	 * 合同岗位 0 固定岗位 1 等于档案处维护 2 自定义
	 */
	@ExcelAttribute(name = "合同岗位", isNotEmpty = true, errorInfo = "合同岗位不能为空")
	@ExcelProperty("合同岗位")
	@Schema(description = "合同岗位 0 固定岗位 1 等于档案处维护 2 自定义")
	private String postType;
	/**
	 * 合同岗位名称
	 */
	@ExcelAttribute(name = "合同岗位名称", maxLength = 50)
	@Length(max = 50, message = "合同岗位名称不能超过50个字符")
	@ExcelProperty("合同岗位名称")
	@Schema(description = "合同岗位名称")
	private String post;
	/**
	 * 工作地点
	 */
	@ExcelAttribute(name = "工作地点", maxLength = 200)
	@Length(max = 200, message = "工作地点不能超过200个字符")
	@ExcelProperty("工作地点")
	@Schema(description = "工作地点")
	private String workAddress;
	/**
	 * 工时制
	 * export const workingHoursOpts = [
	 *     { label: '标准工时', value: '1'},
	 *     { label: '综合工时', value: '2'},
	 *     { label: '不定时工时制', value: '3'},
	 * ];
	 */
	@ExcelAttribute(name = "工时制")
	@ExcelProperty("工时制")
	@Schema(description = "工时制  0 标准工时 1综合工时 2 不定时工时制")
	private String workingHours;
	/**
	 * 试用期工资(元/月)
	 */
	@ExcelAttribute(name = "试用期工资(元/月)", maxLength = 50)
	@ExcelProperty("试用期工资(元/月)")
	@Schema(description = "试用期工资(元/月)")
	private String workingReward;
	/**
	 * 工作部门
	 */
	@ExcelAttribute(name = "工作部门", maxLength = 50)
	@Length(max = 50, message = "工作部门不能超过50个字符")
	@ExcelProperty("工作部门")
	@Schema(description = "工作部门")
	private String workingDept;
	/**
	 * 用工单位名称
	 */
	@ExcelAttribute(name = "用工单位名称", maxLength = 50)
	@Length(max = 50, message = "用工单位名称不能超过50个字符")
	@ExcelProperty("用工单位名称")
	@Schema(description = "用工单位名称")
	private String workingCompany;
	/**
	 * 工资形式 1.计时工资 2.计件工资 3.其他
	 */
	@ExcelAttribute(name = "工资形式")
	@ExcelProperty("工资形式")
	@Schema(description = "工资形式 1.计时工资 2.计件工资 3.其他")
	private String salaryType;
	/**
	 * 购买补充保险说明
	 */
	@ExcelAttribute(name = "购买补充保险说明", maxLength = 50)
	@Length(max = 50, message = "购买补充保险说明不能超过50个字符")
	@ExcelProperty("购买补充保险说明")
	@Schema(description = "购买补充保险说明")
	private String riskBuyDesc;
	/**
	 * 计时工资标准（元/月）
	 */
	@ExcelAttribute(name = "计时工资标准（元/月）", maxLength = 50)
	@ExcelProperty("计时工资标准（元/月）")
	@Schema(description = "计时工资标准（元/月）")
	private String hourlyWage;
	/**
	 * 计件工资单价（元）
	 */
	@ExcelAttribute(name = "计件工资单价（元）", maxLength = 50)
	@ExcelProperty("计件工资单价（元）")
	@Schema(description = "计件工资单价（元）")
	private String pieceworkWage;
	/**
	 * 其他  (工资形式其他时的工资)
	 * export const otherWageOpts = [
	 *     { label: '当地最低工资标准', value: '0'},
	 * ];
	 */
	@ExcelAttribute(name = "其他", maxLength = 50)
	@Length(max = 50, message = "其他不能超过50个字符")
	@ExcelProperty("其他")
	@Schema(description = "其他  (工资形式其他时的工资)")
	private String otherWage;
	/**
	 * 劳务费（元/月）
	 */
	@ExcelAttribute(name = "劳务费（元/月）", maxLength = 50)
	@ExcelProperty("劳务费（元/月）")
	@Schema(description = "劳务费（元/月）")
	private String laborCost;
	/**
	 * 违约责任（金额）
	 */
	@ExcelAttribute(name = "违约责任（金额）", maxLength = 50)
	@ExcelProperty("违约责任（金额）")
	@Schema(description = "违约责任（金额）")
	private String defaultAmount;
	/**
	 * 工资结算周期
	 */
	@ExcelAttribute(name = "工资结算周期", maxLength = 50)
	@ExcelProperty("工资结算周期")
	@Schema(description = "工资结算周期")
	private String settlementCycle;
	/**
	 * 工资发放时间
	 */
	@ExcelAttribute(name = "工资发放时间", maxLength = 50)
	@ExcelProperty("工资发放时间")
	@Schema(description = "工资发放时间")
	private String paymentTime;
	/**
	 * 工资发放方式 0
	 * export const paymentTypeOpts = [
	 *     { label: '直接发放', value: '0'},
	 *     { label: '委托银行代发', value: '1'},
	 * ];
	 */
	@ExcelAttribute(name = "工资发放方式")
	@ExcelProperty("工资发放方式")
	@Schema(description = "工资发放方式 0 直接发放/委托银行代发")
	private String paymentType;
	/**
	 * 实习期限 无/一个月/两个月.../十二个月
	 * export const internshipPeriodOpts = [
	 *     { label: '无', value: '0'},
	 *     { label: '1个月', value: '1'},
	 *     { label: '2个月', value: '2'},
	 *     { label: '3个月', value: '3'},
	 *     { label: '4个月', value: '4'},
	 *     { label: '5个月', value: '5'},
	 *     { label: '6个月', value: '6'},
	 *     { label: '7个月', value: '7'},
	 *     { label: '8个月', value: '8'},
	 *     { label: '9个月', value: '9'},
	 *     { label: '10个月', value: '10'},
	 *     { label: '11个月', value: '11'},
	 *     { label: '12个月', value: '12'}
	 * ];
	 */
	@ExcelAttribute(name = "实习期限")
	@ExcelProperty("实习期限")
	@Schema(description = "实习期限 无/一个月/两个月.../十二个月")
	private String internshipPeriod;
	/**
	 * 实习开始日期
	 * export const internshipPeriodStartOpts = [
	 *     { label: '入职日期', value: '0'},
	 * ];
	 */
	@ExcelAttribute(name = "实习开始日期")
	@ExcelProperty("实习开始日期")
	@Schema(description = "实习开始日期")
	private String internshipPeriodStart;
	/**
	 * 实习结束日期
	 * export const internshipPeriodEndOpts = [
	 *     { label: '根据实习期限自动计算', value: '0'}
	 * ];
	 */
	@ExcelAttribute(name = "实习结束日期")
	@ExcelProperty("实习结束日期")
	@Schema(description = "实习结束日期")
	private String internshipPeriodEnd;
	/**
	 * 派遣期限年
	 * export const dispatchPeriodYearOpts = [
	 *     { label: '1年', value: '1'},
	 *     { label: '2年', value: '2'},
	 *     { label: '3年', value: '3'},
	 *     { label: '4年', value: '4'},
	 *     { label: '5年', value: '5'},
	 *     { label: '6年', value: '6'},
	 *     { label: '7年', value: '7'},
	 *     { label: '8年', value: '8'},
	 *     { label: '9年', value: '9'},
	 *     { label: '10年', value: '10'},
	 * ];
	 */
	@ExcelAttribute(name = "派遣期限-年")
	@ExcelProperty("派遣期限-年")
	@Schema(description = "派遣期限-年")
	private String dispatchPeriodYear;
	/**
	 * 派遣期限-月
	 *   export const dispatchPeriodMonthOpts = [
	 *     { label: '1个月', value: '1'},
	 *     { label: '2个月', value: '2'},
	 *     { label: '3个月', value: '3'},
	 *     { label: '4个月', value: '4'},
	 *     { label: '5个月', value: '5'},
	 *     { label: '6个月', value: '6'},
	 *     { label: '7个月', value: '7'},
	 *     { label: '8个月', value: '8'},
	 *     { label: '9个月', value: '9'},
	 *     { label: '10个月', value: '10'},
	 *     { label: '11个月', value: '11'},
	 *     { label: '12个月', value: '12'}
	 *
	 * ];
	 */
	@ExcelAttribute(name = "派遣期限-月")
	@ExcelProperty("派遣期限-月")
	@Schema(description = "派遣期限-月")
	private String dispatchPeriodMonth;
	/**
	 * 派遣开始日期
	 * export const dispatchPeriodStartOpts = [
	 *     { label: '入职日期', value: '0'},
	 * ];
	 */
	@ExcelAttribute(name = "派遣开始日期")
	@ExcelProperty("派遣开始日期")
	@Schema(description = "派遣开始日期")
	private String dispatchPeriodStart;
	/**
	 * 派遣结束日期
	 * export const dispatchPeriodEndOpts = [
	 *     { label: '根据“派遣期限”推算', value: '0'},
	 * ];
	 */
	@ExcelAttribute(name = "派遣结束日期")
	@ExcelProperty("派遣结束日期")
	@Schema(description = "派遣结束日期")
	private String dispatchPeriodEnd;
	/**
	 * 工作方式 0 第一种方式 1 第二种方式
	 */
	@ExcelAttribute(name = "工作方式", maxLength = 50)
	@Length(max = 50, message = "工作方式不能超过50个字符")
	@ExcelProperty("工作方式")
	@Schema(description = "工作方式 0 第一种方式 1 第二种方式")
	private String workType;
	/**
	 * 每周工作天数
	 */
	@ExcelAttribute(name = "每周工作天数", maxLength = 50)
	@ExcelProperty("每周工作天数")
	@Schema(description = "每周工作天数")
	private String workDayCount;
	/**
	 * 每周工作日
	 */
	@ExcelAttribute(name = "每周工作日", maxLength = 50)
	@Length(max = 50, message = "每周工作日不能超过50个字符")
	@ExcelProperty("每周工作日")
	@Schema(description = "每周工作日")
	private String workDay;
	/**
	 * 每日工作时长
	 */
	@ExcelAttribute(name = "每日工作时长", maxLength = 50)
	@ExcelProperty("每日工作时长")
	@Schema(description = "每日工作时长")
	private String workHours;
	/**
	 * 其他工作时间 （工作方式为第二种方式）
	 * export const otherWorkDayOpts = [
	 *     { label: '每日工作时间不超过四小时，每周工作时间累计不超过二十四小时', value: '0'},
	 * ];
	 */
	@ExcelAttribute(name = "其他工作时间 ", maxLength = 50)
	@Length(max = 50, message = "其他工作时间 不能超过50个字符")
	@ExcelProperty("其他工作时间 ")
	@Schema(description = "其他工作时间 （工作方式为第二种方式）")
	private String otherWorkDay;

}
