/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.msg.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.msg.constant.MesConstants;
import com.yifu.cloud.plus.v1.msg.entity.MsgInfo;
import com.yifu.cloud.plus.v1.msg.mapper.MsgInfoMapper;
import com.yifu.cloud.plus.v1.msg.service.MsgInfoService;
import com.yifu.cloud.plus.v1.msg.vo.EkpAlertVo;
import com.yifu.cloud.plus.v1.msg.vo.EkpInsertMsgVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 
 *
 * @author fxj
 * @date 2023-06-01 10:41:25
 */
@Log4j2
@Service
public class MsgInfoServiceImpl extends ServiceImpl<MsgInfoMapper, MsgInfo> implements MsgInfoService {
    /**
     * 简单分页查询
     * @param msgInfo 
     * @return
     */
    @Override
    public IPage<MsgInfo> getMsgInfoPage(Page<MsgInfo> page, MsgInfo msgInfo){
        return baseMapper.getMsgInfoPage(page,msgInfo);
    }

	@Override
	public List<MsgInfo> getMsgInfo(MsgInfo msgInfo) {
		return baseMapper.getMsgInfo(msgInfo);
	}

	/**
	 * @Author fxj
	 * @Description 生成 待办 变更 提醒数据
	 * @Date 19:36 2023/5/30
	 * @Param
	 * @return
	 **/
	@Override
	public R<Boolean> createMsg(EkpAlertVo vo) {
		if (Common.isNotNull(vo)){
			if (Common.isEmpty(vo.getItem())
					|| Common.isEmpty(vo.getType())
					|| Common.isEmpty(vo.getOrderId())
					|| Common.isEmpty(vo.getAlertUser())){
				return R.failed(CommonConstants.PARAM_INFO_ERROR);
			}
			MsgInfo save =  null;
			// 项目订单处理
			if (CommonConstants.ZERO_STRING.equals(vo.getItem())){
				// 接单提醒
				if (CommonConstants.ZERO_STRING.equals(vo.getType())){
					save = baseMapper.getMsgByOrderId(vo.getOrderId());
					if (Common.isNotNull(save)){
						save.setCreateTime(LocalDateTime.now());
						save.setUrl(MesConstants.orderUrl+vo.getOrderId());
						save.setAlertUser(vo.getAlertUser().replace("\"",""));
						baseMapper.insert(save);
						log.error(JSON.toJSONString(save));
					}
				}
				// 变更提醒
				if (CommonConstants.TWO_STRING.equals(vo.getType())){
					save = baseMapper.getMsgByOrderId(vo.getOrderId());
					if (Common.isNotNull(save)){
						save.setCreateTime(LocalDateTime.now());
						save.setUrl(MesConstants.orderUrl+save.getOrderId());
						save.setAlertType(CommonConstants.TWO_STRING);
						save.setAlertUser(vo.getAlertUser().replace("\"",""));
						baseMapper.insert(save);
						log.error(JSON.toJSONString(save));
					}
				}
			}
			return R.ok();
		}else {
			return R.failed(CommonConstants.PARAM_INFO_ERROR);
		}
	}
	/**
	 * @Author fxj
	 * @Description 定时刷新待办任务
	 * @Date 20:07 2023/5/30
	 * @Param
	 * @return
	 **/
	@Transactional
	@Override
	public void updateOverTimeMsg() {
		// 获取所有已经产生的数据 后面直接排除
		List<MsgInfo>  temps = baseMapper.selectList(Wrappers.<MsgInfo>query().lambda()
				.eq(MsgInfo::getAlertType,CommonConstants.ONE_STRING));
		Map<String,MsgInfo> tempMap = new HashMap<>();
		if (Common.isNotNull(temps)){
			for (MsgInfo msg:temps){
				tempMap.put(msg.getOrderNo(),msg);
			}
		}
		List<MsgInfo>  msgInfos = baseMapper.getMsgByTask();
		List<MsgInfo>  saves = new ArrayList<>();
		if (Common.isNotNull(msgInfos)){
			//2. 重新生成
			MsgInfo temp;
			for (MsgInfo ms:msgInfos){
				temp = tempMap.get(ms.getOrderNo());
				if (Common.isNotNull(temp)){
					tempMap.remove(ms.getOrderNo());
					continue;
				}
				ms.setCreateTime(LocalDateTime.now());
				ms.setUrl(MesConstants.orderUrl+ms.getOrderId());
				saves.add(ms);
			}
			if (Common.isNotNull(tempMap)){
				this.removeByIds(tempMap.values().stream().map(MsgInfo::getId).collect(Collectors.toList()));
			}
			if (Common.isNotNull(saves)){
				this.saveBatch(saves);
				// 发给李鑫
				for (MsgInfo sv:saves){
					sv.setId(null);
					sv.setAlertUser("lixin");
				}
				this.saveBatch(saves);
				//  发给高叶卉
				for (MsgInfo sv:saves){
					sv.setId(null);
					sv.setAlertUser("gaoyh");
				}
				this.saveBatch(saves);
			}
		}
	}

	/**
	 * @Author wzb
	 * @Description 薪资状态变更待支出提醒
	 * @Date 14:58 2023/7/3
	 * @Param
	 * @return
	 **/
	@Transactional
	@Override
	public void statusChangeTimeMsg(){
		List<MsgInfo>  temps = baseMapper.selectList(Wrappers.<MsgInfo>query().lambda()
				.eq(MsgInfo::getAlertType,CommonConstants.THREE_STRING));
		Map<String,MsgInfo> tempMap = new HashMap<>();
		if (Common.isNotNull(temps)){
			for (MsgInfo msg:temps){
				tempMap.put(msg.getOrderNo(),msg);
			}
		}
		List<MsgInfo>  msgInfos = baseMapper.getMsgByTaskOne();
		List<MsgInfo>  saves = new ArrayList<>();
		if (Common.isNotNull(msgInfos)){
			//2. 重新生成
			MsgInfo temp;
			for (MsgInfo ms:msgInfos){
				temp = tempMap.get(ms.getOrderNo());
				if (Common.isNotNull(temp)){
					tempMap.remove(ms.getOrderNo());
					continue;
				}
				ms.setCreateTime(LocalDateTime.now());
				ms.setUrl(MesConstants.orderUrl+ms.getOrderId());
				saves.add(ms);
			}
			if (Common.isNotNull(tempMap)){
				this.removeByIds(tempMap.values().stream().map(MsgInfo::getId).collect(Collectors.toList()));
			}
			this.saveBatch(saves);
		}
	}

	@Override
	public void cancelHandledMsg() {
		List<String> orderNos = baseMapper.getOrderNos();
		if (Common.isNotNull(orderNos)){
			baseMapper.deleteHandledMsg(orderNos);
		}
	}

	@Override
	public R sendZbMessage(EkpInsertMsgVo vo) {
		int a = baseMapper.insertMsg(vo);
		if (a != -1) {
			return R.ok();
		} else {
			return R.failed("插入失败");
		}
	}

}
