/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialSoldierLog;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 自动化日志
 *
 * @author hgw
 * @date 2024-08-30 10:27:16
 */
public interface TSocialSoldierLogService extends IService<TSocialSoldierLog> {
	/**
	 * 自动化日志简单分页查询
	 *
	 * @param tSocialSoldierLog 自动化日志
	 * @return
	 */
	IPage<TSocialSoldierLog> getTSocialSoldierLogPage(Page<TSocialSoldierLog> page, TSocialSoldierLogSearchVo tSocialSoldierLog);

	/**
	 * @Description: 获取最新的拉取时间
	 * @Author: hgw
	 * @Date: 2025/3/18 18:10
	 * @return: java.time.LocalDateTime
	 **/
	LocalDateTime getMaxTimeToLog();

	void listExport(HttpServletResponse response, TSocialSoldierLogSearchVo searchVo);

	List<TSocialSoldierLog> noPageDiy(TSocialSoldierLogSearchVo searchVo);

	/**
	 * @param vo 社保模板
	 * @param type 类型
	 * @param remark 备注结果
	 * @Description: 社保提交日志
	 * @Author: hgw
	 * @Date: 2024/9/2 16:33
	 * @return: void
	 **/
	TSocialSoldierLog getYgsSoldierLog(SocialSoldierYgsAddVo vo, String type, String remark);
	// 医保提交日志
	TSocialSoldierLog getYsdSoldierLog(SocialSoldierYsdAddVo vo, String type, String remark);

	// 社保提交日志-税友
	TSocialSoldierLog getFriendLog(SociaFriendYgsAddVo vo, String type, String dispatchItem, String remark);
	// 拉取提交结果日志 dispatchItem 社保、医保
	TSocialSoldierLog getSocialFriendLog(TSocialInfo social, String type, String dispatchItem, String remark);

	// 审核社保提交日志
	TSocialSoldierLog getYgsSoldierAuditLog(SocialSoldierYgsAuditVo vo, String type, String remark);
	// 审核医保提交日志
	TSocialSoldierLog getYsdSoldierAuditLog(SocialSoldierYsdAuditVo vo, String type, String remark);

	// 拉取提交结果日志 dispatchItem 社保、医保
	TSocialSoldierLog getSocialSoldierLog(TSocialInfo social, String type, String dispatchItem, String remark);

}
