/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author fxj
 * @date 2023-06-13 15:42:17
 */
@Data
@TableName("t_personnel_roster")
@Schema(description = "")
public class TPersonnelRoster extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelIgnore
	private String id;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelProperty("客户名称")
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String customerName;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String departName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String departNo;
	/**
	 * 业务类型
	 */
	@ExcelAttribute(name = "业务类型", maxLength = 50)
	@Length(max = 50, message = "业务类型不能超过50个字符")
	@ExcelProperty("业务类型")
	@Schema(description = "业务类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String businessPrimary;
	/**
	 * 二级分类
	 */
	@ExcelAttribute(name = "二级分类", maxLength = 50)
	@Length(max = 50, message = "二级分类不能超过50个字符")
	@ExcelProperty("二级分类")
	@Schema(description = "二级分类")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String businessSecond;
	/**
	 * 三级分类
	 */
	@ExcelAttribute(name = "三级分类", maxLength = 50)
	@Length(max = 50, message = "三级分类不能超过50个字符")
	@ExcelProperty("三级分类")
	@Schema(description = "三级分类")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String businessThird;
	/**
	 * 标签
	 */
	@ExcelAttribute(name = "标签", maxLength = 50)
	@Length(max = 50, message = "标签不能超过50个字符")
	@ExcelProperty("标签")
	@Schema(description = "标签")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String label;
	/**
	 * 条线类型
	 */
	@ExcelAttribute(name = "条线类型", maxLength = 50)
	@Length(max = 50, message = "条线类型不能超过50个字符")
	@ExcelProperty("条线类型")
	@Schema(description = "条线类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String businessType;
	/**
	 * BU归属
	 */
	@ExcelAttribute(name = "BU归属", maxLength = 30)
	@Length(max = 30, message = "BU归属不能超过30个字符")
	@ExcelProperty("BU归属")
	@Schema(description = "BU归属")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String buBelong;
	/**
	 * 员工类型
	 */
	@ExcelAttribute(name = "员工类型", errorInfo = "员工类型不能为空", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Length(max = 20, message = "员工类型不能超过20个字符")
	@ExcelProperty("员工类型")
	@Schema(description = "员工类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empType;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 20)
	@Length(max = 20, message = "员工姓名不能超过20个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empName;
	/**
	 * 性别
	 */
	@ExcelAttribute(name = "性别", maxLength = 10,isDataId = true,readConverterExp = "1=男,2=女")
	@Length(max = 10, message = "性别不能超过10个字符")
	@ExcelProperty("性别")
	@Schema(description = "性别")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empSex;
	/**
	 * 出生日期
	 */
	@ExcelAttribute(name = "出生日期", isDate = true)
	@ExcelProperty("出生日期")
	@Schema(description = "出生日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empBirthDate;
	/**
	 * 年龄
	 */
	@ExcelAttribute(name = "年龄", maxLength = 3)
	@Length(max = 3, message = "年龄不能超过3个字符")
	@ExcelProperty("年龄")
	@Schema(description = "年龄")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empAge;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empIdcard;
	/**
	 * 银行卡号
	 */
	@ExcelAttribute(name = "银行卡号", maxLength = 25)
	@Length(max = 25, message = "银行卡号不能超过25个字符")
	@ExcelProperty("银行卡号")
	@Schema(description = "银行卡号")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankNo;
	/**
	 * 开户行总行
	 */
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Length(max = 50, message = "开户行总行不能超过50个字符")
	@ExcelProperty("开户行总行")
	@Schema(description = "开户行总行")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankName;
	/**
	 * 开户行-省
	 */
	@ExcelAttribute(name = "开户行-省", maxLength = 30,isArea = true)
	@Length(max = 30, message = "开户行-省不能超过30个字符")
	@ExcelProperty("开户行-省")
	@Schema(description = "开户行-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankProvince;
	/**
	 * 开户行-市
	 */
	@ExcelAttribute(name = "开户行-市", maxLength = 30,isArea = true,parentField = "bankProvince")
	@Length(max = 30, message = "开户行-市不能超过30个字符")
	@ExcelProperty("开户行-市")
	@Schema(description = "开户行-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankCity;
	/**
	 * 开户行支行
	 */
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Length(max = 50, message = "开户行支行不能超过50个字符")
	@ExcelProperty("开户行支行")
	@Schema(description = "开户行支行")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankNameSub;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 15)
	@Length(max = 15, message = "手机号码不能超过15个字符")
	@ExcelProperty("手机号码")
	@Schema(description = "手机号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empPhone;
	/**
	 * 档案地-省
	 */
	@ExcelAttribute(name = "档案地-省", maxLength = 30,isArea = true)
	@Length(max = 30, message = "档案地-省不能超过30个字符")
	@ExcelProperty("档案地-省")
	@Schema(description = "档案地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empProvince;
	/**
	 * 档案地-市
	 */
	@ExcelAttribute(name = "档案地-市", maxLength = 30,isArea = true,parentField = "empProvince")
	@Length(max = 30, message = "档案地-市不能超过30个字符")
	@ExcelProperty("档案地-市")
	@Schema(description = "档案地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empCity;
	/**
	 * 档案地-县
	 */
	@ExcelAttribute(name = "档案地-县", maxLength = 30,isArea = true,parentField = "empCity")
	@Length(max = 30, message = "档案地-县不能超过30个字符")
	@ExcelProperty("档案地-县")
	@Schema(description = "档案地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empTown;
	/**
	 * 社保缴纳地-省
	 */
	@ExcelAttribute(name = "社保缴纳地", maxLength = 50,isArea = true)
	@Length(max = 50, message = "社保缴纳地不能超过50个字符")
	@ExcelProperty("社保缴纳地")
	@Schema(description = "社保缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String socialProvince;
	/**
	 * 社保缴纳地-市
	 */
	@ExcelAttribute(name = "社保缴纳地-市", maxLength = 50,isArea = true,parentField = "socialProvince")
	@Length(max = 50, message = "社保缴纳地-市不能超过50个字符")
	@ExcelProperty("社保缴纳地-市")
	@Schema(description = "社保缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String socialCity;
	/**
	 * 社保缴纳地-县
	 */
	@ExcelAttribute(name = "社保缴纳地-县", maxLength = 50,isArea = true,parentField = "socialCity")
	@Length(max = 50, message = "社保缴纳地-县不能超过50个字符")
	@ExcelProperty("社保缴纳地-县")
	@Schema(description = "社保缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String socialTown;

	/**
	 * 合同申请编号
	 */
	@ExcelAttribute(name = "合同申请编号", maxLength = 32)
	@Length(max = 32, message = "合同申请编号不能超过32个字符")
	@ExcelProperty("合同申请编号")
	@Schema(description = "合同申请编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractApplyNo;
	/**
	 * 合同起始时间
	 */
	@ExcelAttribute(name = "合同起始时间", maxLength = 20)
	@Length(max = 20, message = "合同起始时间不能超过20个字符")
	@ExcelProperty("合同起始时间")
	@Schema(description = "合同起始时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractStart;
	/**
	 * 合同截止时间
	 */
	@ExcelAttribute(name = "合同截止时间", maxLength = 20)
	@Length(max = 20, message = "合同截止时间不能超过20个字符")
	@ExcelProperty("合同截止时间")
	@Schema(description = "合同截止时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractEnd;
	/**
	 * 合同类型
	 */
	@ExcelAttribute(name = "合同类型")
	@Length(max = 10, message = "合同类型不能超过10个字符")
	@ExcelProperty("合同类型")
	@Schema(description = "合同类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractType;
	/**
	 * 业务细分
	 */
	@ExcelAttribute(name = "业务细分")
	@Length(max = 20, message = "业务细分不能超过20个字符")
	@ExcelProperty("业务细分")
	@Schema(description = "业务细分")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String businessDetail;
	/**
	 * 签订类型
	 */
	@ExcelAttribute(name = "签订类型")
	@Length(max = 20, message = "签订类型不能超过20个字符")
	@ExcelProperty("签订类型")
	@Schema(description = "签订类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String signType;
	/**
	 * 签订期限
	 */
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Length(max = 10, message = "签订期限不能超过10个字符")
	@ExcelProperty("签订期限")
	@Schema(description = "签订期限")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String signTerm;
	/**
	 * 合同甲方
	 */
	@ExcelAttribute(name = "合同甲方", maxLength = 50)
	@Length(max = 50, message = "合同甲方不能超过50个字符")
	@ExcelProperty("合同甲方")
	@Schema(description = "合同甲方")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractPartyA;
	/**
	 * 合同岗位
	 */
	@ExcelAttribute(name = "合同岗位", maxLength = 20)
	@Length(max = 20, message = "合同岗位不能超过20个字符")
	@ExcelProperty("合同岗位")
	@Schema(description = "合同岗位")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractPost;
	/**
	 * 工时制
	 */
	@ExcelAttribute(name = "工时制",maxLength = 10,isDataId = true,dataType = ExcelAttributeConstants.WORKING_HOURS)
	@Length(max = 10, message = "工时制不能超过10个字符")
	@ExcelProperty("工时制")
	@Schema(description = "工时制")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractTaskTime;
	/**
	 * 合同编码
	 */
	@ExcelAttribute(name = "合同编码", maxLength = 30)
	@Length(max = 30, message = "合同编码不能超过30个字符")
	@ExcelProperty("合同编码")
	@Schema(description = "合同编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractCode;
	/**
	 * 合同创建人
	 */
	@ExcelAttribute(name = "合同创建人", maxLength = 10)
	@Length(max = 10, message = "合同创建人不能超过10个字符")
	@ExcelProperty("合同创建人")
	@Schema(description = "合同创建人")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractCreater;
	/**
	 * 合同创建时间
	 */
	@ExcelAttribute(name = "合同创建时间", maxLength = 10)
	@Length(max = 10, message = "合同创建时间不能超过10个字符")
	@ExcelProperty("合同创建时间")
	@Schema(description = "合同创建时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String contractCreateTime;
	/**
	 * 数据生成月
	 */
	@ExcelAttribute(name = "数据生成月", maxLength = 10)
	@Length(max = 10, message = "数据生成月不能超过10个字符")
	@ExcelProperty("数据生成月")
	@Schema(description = "数据生成月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelIgnore
	private String dataCreateMonth;

	/**
	 * 项目
	 */
	@Length(max = 32, message = "项目 不能超过32个字符" )
	@ExcelAttribute(name = "项目", maxLength = 32)
	@Schema(description = "项目" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目" )
	private String settleDomain;

}
