/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddCompanyInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddPersonAccount;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 法大大个人实名认证表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
public interface FddPersonAccountService extends IService<FddPersonAccount> {

	/**
	 * 法大大个人实名认证表简单分页查询
	 * @param fddPersonAccount 法大大个人实名认证表
	 * @return IPage
	 */
	IPage<FddPersonAccount> getFddPersonAccountPage(Page<FddPersonAccount> page, FddPersonAccount fddPersonAccount);

	/**
	 * 邀请客服进行法大大实名
	 * @param fddPersonAccount 邀请客服进行法大大实名
	 * @return R
	 */
	R<String> getPersonUnionIdUrl(FddPersonAccount fddPersonAccount) throws ApiException;

	/**
	 * 邀请客服加入组织
	 * @param fddPersonAccount 邀请客服加入组织
	 * @return R
	 */
	R<String> getAddEmployeeUrl(List<FddPersonAccount> fddPersonAccount) throws ApiException;

	/**
	 * 移除员工
	 * @param companyUnionIds
	 * @param unionIds
	 * @return R
	 */
	R<String> delEmployee(String id,List<String> companyUnionIds,String unionIds) throws ApiException;

	/**
	 * 主动发送员工进行法大大实名
	 * @param id
	 * @return R
	 */
	R<String> sendAuthMessage(String id) throws ApiException;

	/**
	 * 主动发送员工进行法大大实名
	 * @param id
	 * @return R
	 */
	R<List<FddCompanyInfo>> getAllDepart(String id);

	/**
	 * 新增员工
	 * @param fddPersonAccount
	 * @return R
	 */
	R saveInfo (FddPersonAccount fddPersonAccount);
}

