/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCertRecord;
import com.yifu.cloud.plus.v1.yifu.archives.vo.CertRecordSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TCertRecordVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 证明开具记录表
 *
 * @author fxj
 * @date 2022-06-25 11:05:11
 */
public interface TCertRecordService extends IService<TCertRecord> {

	R<TCertRecordVo> getCertRecordInfo(String id);

    IPage<TCertRecord> pageDiy(Page page, CertRecordSearchVo searchVo);

	List<TCertRecord> getTCertRecordNoPage(CertRecordSearchVo searchVo);
}
