package com.yifu.cloud.plus.v1.business.util;

import com.yifu.cloud.plus.v1.business.mapper.system.TBusWarningEmployeeMapper;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.QuerySendResult;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.YiFuSmsUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * 异步执行短信发送任务
 *
 * @Author fxj
 * @Date 2021-05-24
 * @return
 **/
@Component
@Slf4j
public class SmsTaskExecute {

     @Async
     public void querySendDetailTask(TBusWarningEmployeeMapper mapper, String bizId, String phone) {
          try {
               TimeUnit.SECONDS.sleep(10);
               QuerySendResult res = YiFuSmsUtil.querySendDetail(phone, bizId,
                       DateUtil.getCurrentDateString(DateUtil.ISO_DATE_FORMAT), null, null);
               this.updateSmsResult(mapper, bizId, res);
          } catch (Exception ex) {
               log.error("查询短信状态异常！", ex);
          }
     }

     private void updateSmsResult(TBusWarningEmployeeMapper mapper, String bizId, QuerySendResult res) {
          if (null != res && null != res.getSmsSendDetailDTOs() &&
                  Common.isNotNull(res.getSmsSendDetailDTOs().getSmsSendDetailDTO())) {
               mapper.updateSendStatusByBizId(
                       res.getSmsSendDetailDTOs().getSmsSendDetailDTO().get(0).getSendStatus().toString(),
                       CommonConstants.ONE_STRING, bizId);
          }
     }
}
