package com.yifu.cloud.plus.v1.yifu.common.core.util;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @Author fxj
 * @Date 2022/6/22
 * @Description
 * @Version 1.0
 */
@Component
public class RedisUtil {
	@Autowired
	private RedisTemplate  redisTemplate;

	public static RedisTemplate redis;

	@PostConstruct
	public void getRedisTemplate(){
		redis = redisTemplate;
	}

	/**
	 * 批量删除对应的Value
	 * @param keys
	 */
	public void remove(final String... keys) {
		for (String key : keys) {
			remove(key);
		}
	}

	/**
	 * 批量删除KEY
	 * @param pattern
	 */
	public void removePattern(final String pattern) {
		Set<Serializable> keys = redisTemplate.keys(pattern);
		if (keys.size() > 0) {
			redisTemplate.delete(keys);
		}
	}
	/**
	 * 删除对应的value
	 * @param key
	 */
	public void  remove(final String key){
		if (exists(key)){
			redisTemplate.delete(key);
		}
	}

	/**
	 * 判断缓存中是否有对应的value
	 * @param key
	 * @return
	 */
	public boolean exists(final  String key){
		return  redisTemplate.hasKey(key);
	}

	/**
	 * 读取缓存
	 * @param key
	 * @return
	 */
	public Object get(final  String key){
		Object result = null;
		ValueOperations<Serializable,Object>    operations = redisTemplate.opsForValue();
		result = operations.get(key);
		return  result;
	}

	/**
	 * 写入缓存
	 * @param key
	 * @param value
	 * @return
	 */
	public boolean set(final  String key ,Object value){
		boolean result = false;
		try {
			ValueOperations<Serializable,Object> operations = redisTemplate.opsForValue();
			operations.set(key,value);
			result = true;
		} catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}
	/**
	 * 写入缓存
	 * @param key
	 * @param value
	 * @param expireTime
	 * @return
	 */
	public  boolean set(final  String key ,Object value,Long expireTime){
		boolean result = false;
		try {
			ValueOperations<Serializable,Object> operations = redisTemplate.opsForValue();
			operations.set(key,value);
			redisTemplate.expire(key,expireTime, TimeUnit.SECONDS);
			result = true;
		} catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}
}
