package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 商险待办导出vo
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@Data
public class TEmployeeInsurancePreExportVo implements Serializable {

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 购买类型， 1新增、3批增、4替换
	 */
	@ExcelAttribute(name = "投保类型")
	@Schema(description = "投保类型， 1新增、3批增、4替换")
	@ExcelProperty("投保类型")
	private String buyType;
	/**
	 * 保险公司名称
	 */
	@ExcelAttribute(name = "保险公司")
	@Schema(description = "保险公司")
	@ExcelProperty("保险公司")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@ExcelAttribute(name = "险种")
	@Schema(description = "险种")
	@ExcelProperty("险种")
	private String insuranceTypeName;

	/**
	 * 是否地市自购0是 1 否
	 */
	@ExcelAttribute(name = "是否地市自购0是 1 否")
	@Schema(description = "是否地市自购0是 1 否")
	@ExcelProperty("是否地市自购0是 1 否")
	private String isAddress;

	/**
	 * 保单起止时间
	 */
	@ExcelAttribute(name = "保单起止时间")
	@Schema(description = "保单起止时间")
	@ExcelProperty("保单起止时间")
	private String policyStartEnd;

	/**
	 * 购买标准
	 */
	@ExcelAttribute(name = "购买标准")
	@Schema(description = "购买标准")
	@ExcelProperty("购买标准")
	private String buyStandard;

	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期", isDate = true)
	@Schema(description = "入职日期")
	@ExcelProperty("入职日期")
	@DateTimeFormat("yyyy-MM-dd")
	private Date joinLeaveDate;

	/**
	 * 预计派单时间
	 */
	@ExcelAttribute(name = "预计派单时间", isDate = true)
	@Schema(description = "预计派单时间")
	@ExcelProperty("预计派单时间")
	private LocalDateTime expectedCollectionTime;

	/**
	 * 前端客服
	 */
	@ExcelAttribute(name = "前端客服")
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String customerUsername;

	/**
	 * 状态,0短信待发送,1信息待填写,2信息待审核,3拒绝入职4已完成
	 */
	@ExcelAttribute(name = "状态")
	@Schema(description = "状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已完成")
	@ExcelProperty("状态")
	private String processStatus;

}
