package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.Date;

/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@Data
public class TEmployeeInsurancePreVo implements Serializable {

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 手机号码
	 */
	@Length(max = 11, message = "手机号码 不能超过11 个字符")
	@ExcelAttribute(name = "手机号码", maxLength = 11)
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String empPhone;
	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期", isDate = true)
	@Schema(description = "入职日期")
	@ExcelProperty("入职日期")
	private Date joinLeaveDate;
	/**
	 * 状态,0短信待发送,1信息待填写,2信息待审核,3拒绝入职4已完成
	 */
	@ExcelAttribute(name = "状态,0短信待发送,1信息待填写,2信息待审核,3拒绝入职4已完成")
	@Schema(description = "状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已完成")
	@ExcelProperty("状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已完成")
	private String processStatus;
	/**
	 * 前端客服
	 */
	@ExcelAttribute(name = "前端客服")
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String customerUsername;
	/**
	 * 前端客服登录名
	 */
	@ExcelAttribute(name = "前端客服登录名")
	@Schema(description = "前端客服登录名")
	@ExcelProperty("前端客服登录名")
	private String customerUserLoginname;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id")
	@Schema(description = "项目id")
	@ExcelProperty("项目id")
	private String deptId;
	/**
	 * 预计派单时间
	 */
	@ExcelAttribute(name = "预计派单时间", isDate = true)
	@Schema(description = "预计派单时间")
	@ExcelProperty("预计派单时间")
	private Date expectedCollectionTime;

	/**
	 * 保险公司名称
	 */
	@ExcelAttribute(name = "保险公司名称")
	@Schema(description = "保险公司名称")
	@ExcelProperty("保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@ExcelAttribute(name = "险种名称")
	@Schema(description = "险种名称")
	@ExcelProperty("险种名称")
	private String insuranceTypeName;

	/**
	 * 险种主键
	 */
	@ExcelAttribute(name = "险种主键")
	@Schema(description = "险种主键")
	@ExcelProperty("险种主键")
	private String insuranceTypeId;

	/**
	 * 购买标准
	 */
	@ExcelAttribute(name = "购买标准")
	@Schema(description = "购买标准")
	@ExcelProperty("购买标准")
	private String buyStandard;

	/**
	 * 购买类型， 1新增、3批增、4替换
	 */
	@ExcelAttribute(name = "购买类型， 1新增、3批增、4替换")
	@Schema(description = "购买类型， 1新增、3批增、4替换")
	@ExcelProperty("购买类型， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 保单开始时间
	 */
	@ExcelAttribute(name = "保单开始时间", isDate = true)
	@Schema(description = "保单开始时间")
	@ExcelProperty("保单开始时间")
	private Date policyStart;

	/**
	 * 保单结束时间
	 */
	@ExcelAttribute(name = "保单结束时间", isDate = true)
	@Schema(description = "保单结束时间")
	@ExcelProperty("保单结束时间")
	private Date policyEnd;

	@ExcelAttribute(name = "保单预计生效日期", isDate = true)
	@Schema(description = "保单预计生效日期")
	@ExcelProperty("保单预计生效日期")
	private Date policyEffect;

	/**
	 * 保单号
	 */
	@ExcelAttribute(name = "保单号")
	@Schema(description = "保单号")
	@ExcelProperty("保单号")
	private String policyNo;

	/**
	 * 是否地市自购0是 1 否
	 */
	@ExcelAttribute(name = "是否地市自购0是 1 否")
	@Schema(description = "是否地市自购0是 1 否")
	@ExcelProperty("是否地市自购0是 1 否")
	private String isAddress;

	/**
	 * 就职岗位
	 */
	@ExcelAttribute(name = "就职岗位")
	@Schema(description = "就职岗位")
	@ExcelProperty("就职岗位")
	private String position;

	/**
	 * 数据来源1客户端 2客服端
	 */
	@ExcelAttribute(name = "数据来源1客户端 2客服端")
	@Schema(description = "数据来源1客户端 2客服端")
	@ExcelProperty("数据来源1客户端 2客服端")
	private String dataSource;

	/**
	 * 购买地-省
	 */
	@ExcelAttribute(name = "购买地-省")
	@Schema(description = "购买地-省")
	@ExcelProperty("购买地-省")
	private String fileProvince;

	/**
	 * 购买地-市
	 */
	@ExcelAttribute(name = "购买地-市")
	@Schema(description = "购买地-市")
	@ExcelProperty("购买地-市")
	private String fileCity;

	/**
	 * 购买地-省id
	 */
	@ExcelAttribute(name = "购买地-省id")
	@Schema(description = "购买地-省id")
	@ExcelProperty("购买地-省id")
	private String provinceCode;

	/**
	 * 购买地-市id
	 */
	@ExcelAttribute(name = "购买地-市id")
	@Schema(description = "购买地-市id")
	@ExcelProperty("购买地-市id")
	private String cityCode;

	/**
	 * 入职确认信息id
	 */
	@ExcelAttribute(name = "入职确认信息主表id")
	@Schema(description = "入职确认信息主表id")
	@ExcelProperty("入职确认信息主表id")
	private String registerId;

	/**
	 * 替换员工姓名
	 */
	@ExcelAttribute(name = "替换员工姓名")
	@Schema(description = "替换员工姓名")
	@ExcelProperty("替换员工姓名")
	private String replaceEmployeeName;

	/**
	 * 替换身份证号
	 */
	@ExcelAttribute(name = "替换身份证号")
	@Schema(description = "替换身份证号")
	@ExcelProperty("替换身份证号")
	private String replaceEmpIdcard;

	/**
	 * 替换项目编码
	 */
	@ExcelAttribute(name = "替换项目编码")
	@Schema(description = "替换项目编码")
	@ExcelProperty("替换项目编码")
	private String replaceDeptNo;

	@Schema(description = "商险ID")
	private String insurancesId;

	/**
	 * 配置名称
	 */
	@ExcelAttribute(name = "配置名称")
	@Schema(description = "配置名称")
	@ExcelProperty("配置名称")
	private String configName;

	@Schema(description = "创建人-姓名")
	private String createName;

	@Schema(description = "创建人")
	private String createBy;

	@Schema(description = "更新人")
	private String updateBy;

	@Schema(description = "保单开始日期类型 1的话默认等于入职日期")
	private String policyStartType;

}
