package com.yifu.cloud.plus.v1.job.compont;


import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author hgw
 * @Description 定时任务具体执行类
 * @Date 2022-11-24 15:03:14
 * @Param
 * @return
 **/
@Component(value = "archiveTask")
@Slf4j
@EnableConfigurationProperties(DaprArchivesProperties.class)
public class ArchiveTask {

	@Autowired
	private DaprArchivesProperties daprArchivesProperties;


	public void updateEmployeeAgeTask() {
		log.info("-------------每年1月1号刷新在职和离职人员的年龄信息-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(), daprArchivesProperties.getAppId(),
				"/temployeeinfo/inner/updateEmployeeAgeTask", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每年1月1号刷新在职和离职人员的年龄信息-定时任务结束------------");
	}
	/**
	 * @Author hgw
	 * @Description 每月1号清理人员档案、项目档案的薪资状态
	 * @Date 2022-11-24 15:06:37
	 * @Param
	 **/
	public void everyMonthUpdateSalaryStatus() {
		log.info("-------------每月1号清理人员档案、项目档案的薪资状态-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(), daprArchivesProperties.getAppId(),
				"/temployeeinfo/inner/everyMonthUpdateSalaryStatus", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每月1号清理人员档案、项目档案的薪资状态-定时任务结束------------");
	}

	/**
	 * @Author hgw
	 * @Description 每天更新人员档案、项目档案的过期合同为2不在用
	 * @Date 2022-11-24 15:06:37
	 * @Param
	 **/
	public void everyDayUpdateEmployeeContractStatus() {
		log.info("-------------每天更新人员档案、项目档案的过期合同为2不在用-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(), daprArchivesProperties.getAppId(),
				"/temployeeinfo/inner/everyDayUpdateEmployeeContractStatus", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每天更新人员档案、项目档案的过期合同为2不在用-定时任务结束------------");
	}


	public void retireeRemind() {
		log.info("-------------每日凌晨1点人员退休提醒-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(), daprArchivesProperties.getAppId(),
				"/temployeeretirement/inner/retireeRemind", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每日凌晨1点人员退休提醒-定时任务开始------------");
	}

	public void everyMonthUpdateRoster() {
		log.info("-------------每月26号更新人员花名册-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(), daprArchivesProperties.getAppId(),
				"/tpersonnelroster/inner/everyMonthUpdateRoster", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每月26号更新人员花名册-定时任务开始------------");
	}

	public void everyDayCreateComlpeteMonitor() {
		log.info("-------------每日刷新档案完整监控数据------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(), daprArchivesProperties.getAppId(),
				"/tcompletemonitor/inner/createComlpeteMonitor", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每日刷新档案完整监控数据-定时任务开始------------");
	}


	public void everyDayCreateRiskMonitor() {
		log.info("-------------每日刷新运营风险管控数据------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(), daprArchivesProperties.getAppId(),
				"/triskmonitor/inner/createRiskMonitor", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------每日刷新运营风险管控数据-定时任务开始------------");
	}
}