package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 审批记录表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@Data
@TableName("t_audit_record")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "审批记录表")
public class TAuditRecord extends BaseEntity {

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	@NotBlank(message = "流程id不能为空")
	@Length(max = 32, message = "流程id不能超过32个字符")
	@Schema(description = "流程id")
	private String flowId;

	@NotBlank(message = "实体id不能为空")
	@Length(max = 32, message = "实体id不能超过32个字符")
	@Schema(description = "实体id")
	private String domainId;

	@NotBlank(message = "节点id不能为空")
	@Length(max = 32, message = "节点id不能超过32个字符")
	@Schema(description = "节点id")
	private String nodeId;

	@NotBlank(message = "审核人id不能为空")
	@Length(max = 32, message = "审核人id不能超过32个字符")
	@Schema(description = "审核人id")
	private String approvalMan;

	@NotBlank(message = "审核人姓名不能为空")
	@Length(max = 50, message = "审核人姓名不能超过50个字符")
	@Schema(description = "审核人姓名")
	private String approvalManName;

	@Schema(description = "审核时间")
	private LocalDateTime approvalTime;

	@Length(max = 1, message = "审核结果0：通过1：不通过 2 待审核不能超过1个字符")
	@Schema(description = "审核结果0：通过1：不通过 2 待审核 3提交")
	private String approvalResult;

	@Length(max = 500, message = "审核意见不能超过500个字符")
	@Schema(description = "审核意见")
	private String approvalOpinion;

	@Length(max = 1, message = "删除表示 0未删除 1删除不能超过1个字符")
	@Schema(description = "删除表示 0未删除 1删除")
	@TableLogic
	private String deleteFlag;

	@Length(max = 1, message = "之前审核记录标识不能超过1个字符")
	@Schema(description = "之前审核记录标识 0之前记录 1当前审核记录。用于当前审核流程过滤判断")
	private String preFlag;

	@Length(max = 32, message = "提交人id不能超过32个字符")
	@Schema(description = "提交人id")
	private String submitMan;

	@Length(max = 32, message = "提交人姓名不能超过32个字符")
	@Schema(description = "提交人姓名")
	private String submitManName;

	@Length(max = 500, message = "申请原因不能超过500个字符")
	@Schema(description = "申请原因")
	private String reason;

	@Length(max = 2, message = "审核类型 0不购买商险审核不能超过2个字符")
	@Schema(description = "审核类型 0不购买商险审核")
	private String auditType;

	@Schema(description = "创建时间")
	private LocalDateTime createTime;

	@Length(max = 50, message = "节点名称不能超过50个字符")
	@Schema(description = "节点名称")
	private String nodeName;

	@Length(max = 300, message = "实体名称不能超过300个字符")
	@Schema(description = "实体名称")
	private String entityName;

	@Schema(description = "提交时间")
	private LocalDateTime submitCreateTime;

	@Length(max = 1, message = "退回状态 0 未退回 1已退回不能超过1个字符")
	@Schema(description = "退回状态 0 未退回 1已退回")
	private String backFlag;

	@Length(max = 50, message = "退回节点名称不能超过50个字符")
	@Schema(description = "退回节点名称")
	private String backNodeName;

	@Length(max = 32, message = "退回节点Id不能超过32个字符")
	@Schema(description = "退回节点Id")
	private String backNodeId;

	@Length(max = 32, message = "加签节点的id不能超过32个字符")
	@Schema(description = "加签节点的id")
	private String addSignNodeId;
}
