package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAttaInfo;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 附件信息表
 *
 * @author pwang
 * @date 2021-02-19 16:16:07
 */
public interface TAttaInfoService extends IService<TAttaInfo> {

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    IPage<TAttaInfo> getTAttaInfoPage(Page<TAttaInfo> page, TAttaInfo tAttaInfo);

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    List<TAttaInfo> getTAttaInfoList(TAttaInfo tAttaInfo);
	/**
	 * @param domainId 关联id
	 * @Description: 根据domainId获取附件
	 * @Author: hgw
	 * @Date: 2024/6/17 18:23
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo>
	 **/
	List<TAttaInfo> getTAttaInfoListByDoMainId(String domainId);

    TAttaInfo add(TAttaInfo attaInfo);

    void update(List<TAttaInfo> attaList, String domainId, String relationType);

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    Boolean batchOssFileDelete(List<TAttaInfo> delAttaList);

    List<TAttaInfo> getKeenAtta(LocalDateTime dayStart, Collection<String> values);

    Boolean updateDomainId(String domainId, List<String> ids);

	/**
	 * @param applyId
	 * @Description: 收入证明使用
	 * @Author: hgw
	 * @Date: 2023/2/22 10:50
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo>>
	 **/
	R<List<TAttaInfo>> getAttaByApplyId(String applyId);

	/**
	 * @param domainId 关联id
	 * @Description: 删除附件
	 * @Author: hgw
	 * @Date: 2024/6/20 14:50
	 * @return: void
	 **/
	void deleteByDomainId(String domainId);

	void deleteByDomainIdAndOther(String domainId);

	void deleteByDomainIdAndType(String domainId, int relationType);

}
