/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @Author fxj
 * @Description 系统配置表
 * @Date 9:38 2025/3/13
 * @Param
 * @return
**/
@Data
@TableName("sys_config")
@Schema(description = "系统配置表")
public class SysConfig {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 配置键
	 */
	@ExcelAttribute(name = "配置键", isNotEmpty = true, errorInfo = "配置键不能为空", maxLength = 32)
	@NotBlank(message = "配置键不能为空")
	@Length(max = 32, message = "配置键不能超过32个字符")
	@ExcelProperty("配置键")
	@Schema(description = "配置键")
	private String configKey;
	/**
	 * 配置值
	 */
	@ExcelAttribute(name = "配置值", isNotEmpty = true, errorInfo = "配置值不能为空")
	@NotBlank(message = "配置值不能为空")
	@ExcelProperty("配置值")
	@Schema(description = "配置值")
	private String configValue;
	/**
	 * 配置值1
	 */
	@ExcelAttribute(name = "配置值1")
	@ExcelProperty("配置值1")
	@Schema(description = "配置值1")
	private String configValue1;
	/**
	 * 配置值2
	 */
	@ExcelAttribute(name = "配置值2")
	@ExcelProperty("配置值2")
	@Schema(description = "配置值2")
	private String configValue2;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Length(max = 255, message = "备注不能超过255个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;

}
