/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 商险定时失败的企微
 *
 * @author hgw
 * @date 2025-08-07 17:49:14
 */
@Data
@TableName("t_employee_insurance_pre_qw")
@Schema(description = "商险定时失败的企微")
public class TEmployeeInsurancePreQw {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 前端客服
	 */
	@ExcelAttribute(name = "前端客服", maxLength = 30)
	@Length(max = 30, message = "前端客服不能超过30个字符")
	@ExcelProperty("前端客服")
	@Schema(description = "前端客服")
	private String customerUsername;
	/**
	 * 前端客服登录名
	 */
	@ExcelAttribute(name = "前端客服登录名", isNotEmpty = true, errorInfo = "前端客服登录名不能为空", maxLength = 30)
	@NotBlank(message = "前端客服登录名不能为空")
	@Length(max = 30, message = "前端客服登录名不能超过30个字符")
	@ExcelProperty("前端客服登录名")
	@Schema(description = "前端客服登录名")
	private String customerUserLoginname;
	/**
	 * 内容
	 */
	@ExcelAttribute(name = "内容", isNotEmpty = true, errorInfo = "内容不能为空", maxLength = 200)
	@NotBlank(message = "内容不能为空")
	@Length(max = 200, message = "内容不能超过200个字符")
	@ExcelProperty("内容")
	@Schema(description = "内容")
	private String description;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	@ColumnWidth(18)
	private LocalDateTime createTime;

}
