package com.yifu.cloud.plus.v1.business.entity.vacation;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * B端离职信息表
 *
 * @author hgw
 * @date 2021-08-17 17:02:47
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_leave")
@Schema(description = "B端离职信息表")
public class TBusLeave extends Model<TBusLeave> {
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "")
     private String id;
     /**
      * 电信工号
      */
     @Length(max = 50, message = "电信工号不能超过50个字符")
     @ExcelAttribute(name = "电信工号", maxLength = 50)
     @Schema(description = "电信工号")
     private String teleNo;
     /**
      * 姓名
      */
     @Length(max = 50, message = "姓名不能超过50个字符")
     @ExcelAttribute(name = "姓名", maxLength = 50)
     @Schema(description = "姓名")
     private String name;
     /**
      * 身份证
      */
     @Length(max = 25, message = "身份证不能超过25个字符")
     @ExcelAttribute(name = "身份证", maxLength = 25)
     @Schema(description = "身份证")
     private String idCard;
     /**
      * 岗位
      */
     @Length(max = 50, message = "岗位不能超过50个字符")
     @ExcelAttribute(name = "岗位", maxLength = 50)
     @Schema(description = "岗位")
     private String post;
     /**
      * 部门id
      */
     @ExcelAttribute(name = "部门id")
     @Schema(description = "部门id")
     private Integer deptId;
     /**
      * 所属部门
      */
     @Length(max = 100, message = "所属部门不能超过100个字符")
     @ExcelAttribute(name = "所属部门", maxLength = 100)
     @Schema(description = "所属部门")
     private String deptName;
     /**
      * 部门tree
      */
     @Length(max = 200, message = "部门tree不能超过200个字符")
     @ExcelAttribute(name = "部门tree", maxLength = 200)
     @Schema(description = "部门tree")
     private String deptTreeLogo;
     /**
      * 离职日期
      */
     @ExcelAttribute(name = "离职日期")
     @Schema(description = "离职日期")
     private LocalDate leaveDate;
     /**
      * 离岗日期
      */
     @ExcelAttribute(name = "离岗日期")
     @Schema(description = "离岗日期")
     private LocalDate leavePostDate;
     /**
      * 离职原因
      */
     @Length(max = 200, message = "离职原因不能超过200个字符")
     @ExcelAttribute(name = "离职原因", maxLength = 200)
     @Schema(description = "离职原因")
     private String leaveReason;
     /**
      * 创建人id
      */
     @NotBlank(message = "创建人id不能为空")
     @Length(max = 32, message = "创建人id不能超过32个字符")
     @ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id不能为空", maxLength = 32)
     @Schema(description = "创建人id")
     private String createUserId;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @ExcelAttribute(name = "创建人姓名", maxLength = 50)
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 删除标志，0未删除
      */
     @ExcelAttribute(name = "删除标志，0未删除")
     @Schema(description = "删除标志，0未删除")
     private Integer deleteFlag;

     @TableField(exist = false)
     @Schema(description = "离职日期开始")
     private LocalDate leaveDateStart;
     @TableField(exist = false)
     @Schema(description = "离职日期截止")
     private LocalDate leaveDateEnd;

     @TableField(exist = false)
     @Schema(description = "离岗日期开始")
     private LocalDate leavePostStart;
     @TableField(exist = false)
     @Schema(description = "离岗日期截止")
     private LocalDate leavePostEnd;
}
