package com.yifu.cloud.plus.v1.csp.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.csp.entity.EmployeeRegistration;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationReceiveVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationSearchVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationUpdateVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProjectBelongDept;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeProjectBelongDeptSearchCspVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 入离职登记表
 *
 * @author huych
 * @date 2025-02-25 14:48:11
 */
public interface EmployeeRegistrationService extends IService<EmployeeRegistration> {
    /**
     * 入离职登记表简单分页查询
     * @param employeeRegistration 入离职登记表
     * @return
     */
    IPage<EmployeeRegistration> getEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration);

	/**
	 * 入离职登记表简单分页查询
	 * @param employeeRegistration 入离职登记表
	 * @return
	 */
	IPage<EmployeeRegistration> getHrEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration);

	/**
	 * 作业自动化-入离职登记列表简单分页查询
	 * @param employeeRegistration 入离职登记表
	 * @return
	 */
	IPage<EmployeeRegistration> getHrAutoEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration);


	/**
	 * 入职待确认简单分页查询
	 * @param employeeRegistration 入离职登记表
	 * @return
	 */
	IPage<EmployeeRegistration> getHrConfirmEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration);

	/**
	 * 入离职登记表导入
	 * @param inputStream 文件流
	 * @return
	 */
    R<List<ErrorMessage>> importDiy(InputStream inputStream,String deptId, String dataSource);

	/**
	 * 入离职登记新增
	 * @param registration 入离职登记
	 * @return
	 */
	R registAdd(EmployeeRegistration registration);

	/**
	 * 确认提交
	 * @param registration 入离职登记
	 * @return
	 */
	R confirmSubmit(EmployeeRegistration registration);

	/**
	 * 单个更新
	 * @param registration 入离职登记
	 * @return
	 */
	R updateRegist(EmployeeRegistration registration);

	/**
	 * 导出
	 * @param searchVo 入离职登记
	 * @return
	 */
    void listExport(HttpServletResponse response, EmployeeRegistrationSearchVo searchVo);

	/**
	 * 代办列表导出
	 * @param searchVo 入离职登记
	 * @return
	 */
	void listHrExport(HttpServletResponse response, EmployeeRegistrationSearchVo searchVo);

	/**
	 * 作业自动化-入离职登记导出
	 * @param searchVo 入离职登记
	 * @return
	 */
	void hrRegistrationExport(HttpServletResponse response, EmployeeRegistrationSearchVo searchVo);


	/**
	 * 入职待确认表导出
	 * @param searchVo 入离职登记
	 * @return
	 */
	void hrConfirmExport(HttpServletResponse response, EmployeeRegistrationSearchVo searchVo);

	/**
	 * 入职待确认身份证查询
	 * @param searchVo 入离职登记
	 * @return
	 */
	List<EmployeeRegistration> getHrConfirmIdcardList(EmployeeRegistrationSearchVo searchVo);

	/**
	 * 入职待确认表确认接收
	 * @param preVo 入离职登记
	 * @return
	 */
	R confirmReceive(EmployeeRegistrationPreVo preVo);

	/**
	 * 入职待确认表批量确认接收
	 * @param preVo 入离职登记
	 * @return
	 */
	R batchConfirmReceive(EmployeeRegistrationPreVo preVo);

	/**
	 * 批量更新
	 * @param employeeRegistList 入离职登记
	 * @return
	 */
	R batchUpdatePreById(List<EmployeeRegistrationReceiveVo> employeeRegistList);

	/**
	 * 批量更新
	 * @param updateVo 状态和日志新增vo
	 * @return
	 */
	Boolean updateRegistByPreInfo(EmployeeRegistrationUpdateVo updateVo);

	/**
	 * 批量更新
	 * @param updateVo 前端客服信息更新vo
	 * @return
	 */
	Boolean updateRegistCustomerUserInfo(EmployeeRegistrationCustomerUserUpdateVo updateVo);

	/**
	 * 查询入职待确认数量
	 * @param searchVo 查询入职待确认数量vo
	 * @return
	 */
	long getRegisterPreCount(EmployeeRegistrationSearchVo searchVo);

	/**
	 * @param searchCspVo 身份证 与 类型
	 * @Description: 获取已接收的入离职申请，同步所属部门到项目档案里
	 * @Author: hgw
	 * @Date: 2025/3/3 16:54
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProjectBelongDept
	 **/
	TEmployeeProjectBelongDept getZeroRegistrationAndUpdateTwo(TEmployeeProjectBelongDeptSearchCspVo searchCspVo);

}
