package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;


/**
 * 薪资原表识别主表
 *
 * @author hgw
 * @date 2024-4-1 18:06:46
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_salary_standard_original")
@Tag(name = "薪资原表识别主表")
public class TSalaryStandardOriginal extends BaseEntity {
	private static final long serialVersionUID = 1L;
	/**
	 *
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
	private String id;
	/**
	 * 部门ID
	 */
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID不能为空", maxLength = 32)
	@NotBlank(message = "部门ID不能为空")
	@Length(max = 32, message = "部门ID不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String deptId;
	/**
	 * 部门名称
	 */
	@ExcelAttribute(name = "部门名称", isNotEmpty = true, errorInfo = "部门名称不能为空", maxLength = 50)
	@NotBlank(message = "部门名称不能为空")
	@Length(max = 50, message = "部门名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门名称")
	private String deptName;
	/**
	 * 部门编码
	 */
	@ExcelAttribute(name = "部门编码", maxLength = 32)
	@Length(max = 32, message = "部门编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门编码")
	private String deptNo;
	/**
	 * 原表类型
	 */
	@NotBlank(message = "原表类型不能为空")
	@ExcelAttribute(name = "原表类型", maxLength = 50)
	@Length(max = 50, message = "原表类型不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原表类型")
	private String setName;
	/**
	 * sheet名
	 */
	@ExcelAttribute(name = "sheet名", maxLength = 100)
	@Length(max = 100, message = "sheet名不能超过100个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("sheet名")
	private String sheetName;

	/**
	 * 附件名称
	 */
	@ExcelAttribute(name = "附件名称", maxLength = 200)
	@Length(max = 200, message = "附件名称不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("附件名称")
	private String attaName;
	/**
	 * 资源路径
	 */
	@ExcelAttribute(name = "资源路径", maxLength = 200)
	@Length(max = 200, message = "资源路径不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源路径")
	private String attaSrc;
	/**
	 * 资源地址
	 */
	@ExcelAttribute(name = "资源地址", maxLength = 100)
	@Length(max = 100, message = "资源地址不能超过100个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源地址")
	private String attaUrl;
	/**
	 * 资源大小
	 */
	@ExcelAttribute(name = "资源大小")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源大小")
	private Long attaSize;
	/**
	 * 资源类型（数据字典）
	 */
	@ExcelAttribute(name = "资源类型（数据字典）", maxLength = 32)
	@Length(max = 32, message = "资源类型（数据字典）不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("资源类型（数据字典）")
	private String attaType;
	/**
	 * 是否删除0：未删除；1:已删除
	 */
	@ExcelAttribute(name = "是否删除0：未删除；1:已删除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否删除0：未删除；1:已删除")
	private Integer deleteFlag;
	/**
	 * 数据所在行
	 */
	@ExcelAttribute(name = "数据所在行")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据所在行")
	private Integer dateNum;

	/**
	 * 是否固定列，1是，默认，0否
	 */
	@ExcelAttribute(name = "是否固定列")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否固定列")
	private Integer isFixedColumn;

	/**
	 * 明细
	 */
	@TableField(exist = false)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "明细")
	private List<TSalaryStandardOriginalDetail> detailList = new ArrayList<>();
}
