/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 统计-本期申报-回盘数据
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
@TableName("t_statistics_current_report_market")
@Schema(description = "统计-本期申报-回盘数据")
public class TStatisticsCurrentReportMarket {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 税务主体(封面抬头)
	 */
	@ExcelAttribute(name = "税务主体(封面抬头)", maxLength = 50)
	@Length(max = 50, message = "税务主体(封面抬头)不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税务主体(封面抬头)")
	private String invoiceTitle;
	/**
	 * 结算部门id
	 */
	@ExcelAttribute(name = "结算部门id", maxLength = 32)
	@Length(max = 32, message = "结算部门id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门id")
	private String settleDepartId;
	/**
	 * 结算部门no
	 */
	@ExcelAttribute(name = "结算部门no", maxLength = 50)
	@Length(max = 50, message = "结算部门no不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门no")
	private String settleDepartNo;
	/**
	 * 结算部门name
	 */
	@ExcelAttribute(name = "结算部门name", maxLength = 50)
	@Length(max = 50, message = "结算部门name不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算部门name")
	private String settleDepartName;
	/**
	 * 申报月份（YYYYMM）
	 */
	@ExcelAttribute(name = "申报月份（YYYYMM）", isNotEmpty = true, errorInfo = "申报月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "申报月份（YYYYMM）不能为空")
	@Length(max = 6, message = "申报月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份（YYYYMM）")
	private String declareMonth;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 50)
	@Length(max = 50, message = "姓名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 证照类型
	 */
	@ExcelAttribute(name = "证照类型", maxLength = 32)
	@Length(max = 32, message = "证照类型不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证照类型")
	private String empIdcardType;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 25)
	@Length(max = 25, message = "身份证号不能超过25个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 税款所属期起
	 */
	@ExcelAttribute(name = "税款所属期起", maxLength = 20)
	@Length(max = 20, message = "税款所属期起不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税款所属期起")
	private String createStart;
	/**
	 * 税款所属期止
	 */
	@ExcelAttribute(name = "税款所属期止", maxLength = 20)
	@Length(max = 20, message = "税款所属期止不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税款所属期止")
	private String createEnd;
	/**
	 * 所得项目
	 */
	@ExcelAttribute(name = "所得项目", maxLength = 20)
	@Length(max = 20, message = "所得项目不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所得项目")
	private String item;
	/**
	 * 本期收入
	 */
	@ExcelAttribute(name = "本期收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期收入")
	private BigDecimal realSalary;
	/**
	 * 本期费用
	 */
	@ExcelAttribute(name = "本期费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期费用")
	private BigDecimal currentExpenses;
	/**
	 * 本期免税收入
	 */
	@ExcelAttribute(name = "本期免税收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期免税收入")
	private BigDecimal currentTaxFreeIncome;
	/**
	 * 累计减除费用
	 */
	@ExcelAttribute(name = "累计减除费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计减除费用")
	private BigDecimal costReduction;
	/**
	 * 累计专项扣除
	 */
	@ExcelAttribute(name = "累计专项扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计专项扣除")
	private BigDecimal specialDeduction;
	/**
	 * 累计子女教育
	 */
	@ExcelAttribute(name = "累计子女教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计子女教育")
	private BigDecimal childEduinfoMoney;
	/**
	 * 累计住房租金
	 */
	@ExcelAttribute(name = "累计住房租金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房租金")
	private BigDecimal housingRentalinfoMoney;
	/**
	 * 累计住房贷款
	 */
	@ExcelAttribute(name = "累计住房贷款")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房贷款")
	private BigDecimal housingLoanInterestExpenseMoney;
	/**
	 * 累计赡养老人
	 */
	@ExcelAttribute(name = "累计赡养老人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计赡养老人")
	private BigDecimal supportElderlyExpenseMoney;
	/**
	 * 累计继续教育
	 */
	@ExcelAttribute(name = "累计继续教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计继续教育")
	private BigDecimal continuingEducationExpenseMoney;
	/**
	 * 本期基本养老
	 */
	@ExcelAttribute(name = "本期基本养老")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期基本养老")
	private BigDecimal personalPensionMoney;
	/**
	 * 本期基本医疗
	 */
	@ExcelAttribute(name = "本期基本医疗")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期基本医疗")
	private BigDecimal personalMedicalMoney;
	/**
	 * 本期失业
	 */
	@ExcelAttribute(name = "本期失业")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期失业")
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额")
	private BigDecimal personalBigmailmentMoney;
	/**
	 * 累计住房公积金
	 */
	@ExcelAttribute(name = "累计住房公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房公积金")
	private BigDecimal personalProvidentFee;
	/**
	 * 累计企业年金
	 */
	@ExcelAttribute(name = "累计企业年金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计企业年金")
	private BigDecimal enterpriseAnnuity;
	/**
	 * 累计应纳税所得
	 */
	@ExcelAttribute(name = "累计应纳税所得")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应纳税所得")
	private BigDecimal taxable;
	/**
	 * 本期商业健康保险费
	 */
	@ExcelAttribute(name = "本期商业健康保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期商业健康保险费")
	private BigDecimal nowTakingRisks;
	/**
	 * 本期税延养老保险费
	 */
	@ExcelAttribute(name = "本期税延养老保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期税延养老保险费")
	private BigDecimal nowTaxDeferred;
	/**
	 * 本期其他扣除(其他)
	 */
	@ExcelAttribute(name = "本期其他扣除(其他)")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期其他扣除(其他)")
	private BigDecimal nowOther;
	/**
	 * 累计收入额
	 */
	@ExcelAttribute(name = "累计收入额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计收入额")
	private BigDecimal allIncome;
	/**
	 * 累计其他扣除
	 */
	@ExcelAttribute(name = "累计其他扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计其他扣除")
	private BigDecimal allOther;
	/**
	 * 累计准予扣除的捐赠
	 */
	@ExcelAttribute(name = "累计准予扣除的捐赠")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计准予扣除的捐赠")
	private BigDecimal allDonate;
	/**
	 * 税率
	 */
	@ExcelAttribute(name = "税率")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税率")
	private BigDecimal taxFee;
	/**
	 * 速算扣除
	 */
	@ExcelAttribute(name = "速算扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("速算扣除")
	private BigDecimal quickDeducation;
	/**
	 * 累计应纳税额
	 */
	@ExcelAttribute(name = "累计应纳税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应纳税额")
	private BigDecimal salaryTax;
	/**
	 * 累计减免税额
	 */
	@ExcelAttribute(name = "累计减免税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计减免税额")
	private BigDecimal allTaxDeduction;
	/**
	 * 累计应扣缴税额
	 */
	@ExcelAttribute(name = "累计应扣缴税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应扣缴税额")
	private BigDecimal allWithholdingTax;
	/**
	 * 累计已预缴税额
	 */
	@ExcelAttribute(name = "累计已预缴税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计已预缴税额")
	private BigDecimal allTaxPrepaid;
	/**
	 * 累计应补(退)税额
	 */
	@ExcelAttribute(name = "累计应补(退)税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应补(退)税额")
	private BigDecimal allTaxPayable;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Length(max = 255, message = "备注不能超过255个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remark;
	/**
	 * 单位id
	 */
	@ExcelAttribute(name = "单位id", maxLength = 32)
	@Length(max = 32, message = "单位id不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位id")
	private String unitId;
	/**
	 * 单位no
	 */
	@ExcelAttribute(name = "单位no", maxLength = 50)
	@Length(max = 50, message = "单位no不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位no")
	private String unitNo;
	/**
	 * 单位name
	 */
	@ExcelAttribute(name = "单位name", maxLength = 50)
	@Length(max = 50, message = "单位name不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位name")
	private String unitName;
	/**
	 * 累计3岁以下婴幼儿照护
	 */
	@ExcelAttribute(name = "累计3岁以下婴幼儿照护")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计3岁以下婴幼儿照护")
	private BigDecimal sumBabyMoney;

	@ExcelAttribute(name = "累计个人养老金", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计个人养老金")
	private BigDecimal sumPrivatePension;

}
