/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsCurrentReport;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsCurrentReportSearchVo;

import javax.servlet.http.HttpServletResponse;

/**
 * 统计-本期申报
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TStatisticsCurrentReportService extends IService<TStatisticsCurrentReport> {
    /**
     * 统计-本期申报简单分页查询
     * @param tStatisticsCurrentReport 统计-本期申报
     * @return
     */
    IPage<TStatisticsCurrentReport> getTStatisticsCurrentReportPage(Page<TStatisticsCurrentReport> page, TStatisticsCurrentReportSearchVo tStatisticsCurrentReport);

	/**
	 * @Description: 导出
	 * @Author: hgw
	 * @Date: 2022/8/19 17:04
	 * @return: void
	 **/
	void listExport(HttpServletResponse response, TStatisticsCurrentReportSearchVo tStatisticsCurrentReport);

	/**
	 * @param yearMonth
	 * @Description: 删除-按申报月份
	 * @Author: hgw
	 * @Date: 2020/6/16 15:17
	 * @return: int
	 **/
	int deleteByYearMonth(String yearMonth);

	/**
	 * @param declareMonth
	 * @Description: 按结算月刷新本期申报
	 * @Author: hgw
	 * @Date: 2022/2/23 15:10
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	R<String> doRefreshStatisticsCurrentReport(String declareMonth, String lastMonth, String lastTwoMonth);
}
