/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractAreaRes;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmployeeContractAreaResService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmpContractAreaExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractAreaResSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractAreaResVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 合同地市权限配置表
 *
 * @author fxj
 * @date 2022-11-01 10:30:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/temployeecontractareares")
@Tag(name = "合同地市权限配置表管理")
public class TEmployeeContractAreaResController {

	private final TEmployeeContractAreaResService tEmployeeContractAreaResService;


	/**
	 * 简单分页查询
	 *
	 * @param page                     分页对象
	 * @param tEmployeeContractAreaRes 合同地市权限配置表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TEmployeeContractAreaRes>> getTEmployeeContractAreaResPage(Page<TEmployeeContractAreaRes> page, TEmployeeContractAreaResSearchVo tEmployeeContractAreaRes) {
		return new R<>(tEmployeeContractAreaResService.getTEmployeeContractAreaResPage(page, tEmployeeContractAreaRes));
	}

	/**
	 * 不分页查询
	 *
	 * @param searchVo 合同地市权限配置表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('temployeecontractareares_get')" )
	public R<List<TEmpContractAreaExportVo>> getTEmployeeContractAreaResNoPage(@RequestBody TEmployeeContractAreaResSearchVo searchVo) {
		return R.ok(tEmployeeContractAreaResService.noPageDiy(searchVo,null, Common.getList(searchVo.getIds()),null));
	}

	/**
	 * 通过id查询合同地市权限配置表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('temployeecontractareares_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('temployeecontractareares_get')")
	public R<TEmployeeContractAreaRes> getById(@PathVariable("id") String id) {
		return R.ok(tEmployeeContractAreaResService.getById(id));
	}

	/**
	 * 新增合同地市权限配置表
	 *
	 * @param areaRes 合同地市权限配置表
	 * @return R
	 */
	@Operation(summary = "新增合同地市权限配置表", description = "新增合同地市权限配置表：hasPermission('temployeecontractareares_add')")
	@SysLog("新增合同地市权限配置表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('temployeecontractareares_add')")
	public R<Boolean> save(@RequestBody TEmployeeContractAreaRes areaRes) {
		TEmployeeContractAreaRes res = null;
		if (Common.isEmpty(areaRes.getFileTown())){
			res = tEmployeeContractAreaResService.getOne(Wrappers.<TEmployeeContractAreaRes>query().lambda()
					.eq(TEmployeeContractAreaRes::getFileProvince,areaRes.getFileProvince())
					.eq(TEmployeeContractAreaRes::getFileCity,areaRes.getFileCity())
					.isNull(TEmployeeContractAreaRes::getFileTown)
					.eq(TEmployeeContractAreaRes::getUserId,areaRes.getUserId())
					.last(CommonConstants.LAST_ONE_SQL));
		}
		if (Common.isEmpty(areaRes.getFileCity())){
			res = tEmployeeContractAreaResService.getOne(Wrappers.<TEmployeeContractAreaRes>query().lambda()
					.eq(TEmployeeContractAreaRes::getFileProvince,areaRes.getFileProvince())
					.isNull(TEmployeeContractAreaRes::getFileCity)
					.eq(TEmployeeContractAreaRes::getUserId,areaRes.getUserId())
					.last(CommonConstants.LAST_ONE_SQL));
		}
		if (Common.isNotNull(res)){
			return R.failed("已存在对应审核人及地市配置！");
		}
		// 清理缓存
		tEmployeeContractAreaResService.removeAuthCache();
		return R.ok(tEmployeeContractAreaResService.save(areaRes));
	}

	/**
	 * 修改合同地市权限配置表
	 *
	 * @param tEmployeeContractAreaRes 合同地市权限配置表
	 * @return R
	 */
	@Operation(summary = "修改合同地市权限配置表", description = "修改合同地市权限配置表：hasPermission('temployeecontractareares_edit')")
	@SysLog("修改合同地市权限配置表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('temployeecontractareares_edit')")
	public R<Boolean> updateById(@RequestBody TEmployeeContractAreaRes tEmployeeContractAreaRes) {
		return R.ok(tEmployeeContractAreaResService.updateById(tEmployeeContractAreaRes));
	}
	/**
	 * 通过id启用或禁用合同地市权限配置表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id启用或禁用合同地市权限配置表", description = "通过id启用或禁用(0 启用，1禁用)合同地市权限配置表：hasPermission('temployeecontractareares_edit')")
	@SysLog("通过id启用或禁用合同地市权限配置表")
	@PutMapping("/updateStatus")
	@PreAuthorize("@pms.hasPermission('temployeecontractareares_edit')")
	public R<Boolean> removeById(@RequestParam(name = "id",required = true) String id,
								 @RequestParam(name = "status",required = true) String status) {
		TEmployeeContractAreaRes areaRes = tEmployeeContractAreaResService.getById(id);
		if (Common.isEmpty(areaRes)
				|| !(CommonConstants.ONE_STRING).equals(status)
				&& !CommonConstants.ZERO_STRING.equals(status)){
			return R.failed(CommonConstants.PARAM_INFO_ERROR);
		}
		areaRes.setStatus(status);
		// 清理缓存
		tEmployeeContractAreaResService.removeAuthCache();
		return R.ok(tEmployeeContractAreaResService.updateById(areaRes));
	}
	/**
	 * 通过id删除合同地市权限配置表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除合同地市权限配置表", description = "通过id删除合同地市权限配置表：hasPermission('temployeecontractareares_del')")
	@SysLog("通过id删除合同地市权限配置表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('temployeecontractareares_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		// 清理缓存
		tEmployeeContractAreaResService.removeAuthCache();
		return R.ok(tEmployeeContractAreaResService.removeById(id));
	}

	/**
	 * 合同地市权限配置表 批量导入
	 *
	 * @author fxj
	 * @date 2022-11-01 10:30:12
	 **/
	@SneakyThrows
	@Operation(description = "批量新增合同地市权限配置表 hasPermission('temployeecontractareares-batch-import')")
	@SysLog("批量新增合同地市权限配置表")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('temployeecontractareares-batch-import')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return tEmployeeContractAreaResService.importDiy(file.getInputStream());
	}

	/**
	 * 合同地市权限配置表 批量导出
	 *
	 * @author fxj
	 * @date 2022-11-01 10:30:12
	 **/
	@Operation(description = "导出合同地市权限配置表 hasPermission('temployeecontractareares-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('temployeecontractareares-export')")
	public void export(HttpServletResponse response, @RequestBody TEmployeeContractAreaResSearchVo searchVo) {
		tEmployeeContractAreaResService.listExport(response, searchVo);
	}
}
