/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascEditLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.TFascEditLogService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 法大大编辑日志表
 *
 * @author hgw
 * @date 2025-10-09 10:39:43
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tfasceditlog")
@Tag(name = "法大大编辑日志表管理")
public class TFascEditLogController {

	private final TFascEditLogService tFascEditLogService;


	/**
	 * 简单分页查询
	 *
	 * @param page         分页对象
	 * @param tFascEditLog 法大大编辑日志表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TFascEditLog>> getTFascEditLogPage(Page<TFascEditLog> page, TFascEditLog tFascEditLog) {
		return new R<>(tFascEditLogService.getTFascEditLogPage(page, tFascEditLog));
	}

	/**
	 * 不分页查询
	 *
	 * @param tFascEditLog 法大大编辑日志表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TFascEditLog>> getTFascEditLogList(@RequestBody TFascEditLog tFascEditLog) {
		return R.ok(tFascEditLogService.getTFascEditLogList(tFascEditLog));
	}
}
